-- -------------------------------------------------------------------- 
-- >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<< 
-- -------------------------------------------------------------------- 
-- Copyright (c) 2001 by Lattice Semiconductor Corporation 
-- -------------------------------------------------------------------- 
-- 
-- 
--                     Lattice Semiconductor Corporation 
--                     5555 NE Moore Court 
--                     Hillsboro, OR 97214 
--                     U.S.A 
-- 
--                     TEL: 1-800-Lattice (USA and Canada) 
--                          408-826-6000 (other locations) 
-- 
--                     web: http://www.latticesemi.com/ 
--                     email: techsupport@latticesemi.com 
-- 
-- -------------------------------------------------------------------- 
-- 
-- Simulation Library File for GDX2 device 
-- 
-- -------------------------------------------------------------------- 
-- 
-- Revision History : 


--$Header: R:/src/mod_kits/Mach/vital/rcs/GDX2.vhd 1.27 2004/03/31 00:35:18Z jli Exp jli $ 

----------------------------------------------------------------
-- 
-- FILE CONTENTS:    GDX2 VITAL Library 
-- DATE CREATED :    Wen Sept  15 1998
-- 
-- LIBRARY      :    GDX2
-- REVISION     :    1.2 
-- TIME SCALE   :    1 ns
-- LOGIC SYSTEM :    IEEE-1164
-- NOTES        :    
-- HISTORY      :
-- 
-- version 1.0, Initial beta version for beta testing 
-- version 1.1, Change the array size to pass model tech.
-- version 1.2, Change the default for setup and hold for DFF/TFF/DLAT
--              Modified the index range to pass Modelsim EE 5.2e warnings
-- version 1.3, Change the default pw, period for FF and LATCH.

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.VITAL_timing.all;
USE IEEE.VITAL_primitives.all;
 
 
package VLOGTOVITAL_TABLES is
 
---------------------------------------------------------------------------------
-- Local type declaration
---------------------------------------------------------------------------------

    TYPE edge_table IS ARRAY (std_ulogic, std_ulogic) OF boolean ;

---------------------------------------------------------------------------------
-- Contants Specifications
-- posedge, negedge
---------------------------------------------------------------------------------
    CONSTANT POSEDGE : edge_table := (
    --      ---------------------------------------------------------
    --      |  U      X      0      1      Z      W      L      H      - |   |
    --      ---------------------------------------------------------
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | U |
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | X |
            ( FALSE, TRUE,  FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 0 |
            ( FALSE, FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 1 |
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | Z |
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | W |
            ( FALSE, TRUE,  FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | L |
            ( FALSE, FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE ), -- | H |
            ( FALSE, FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE )  -- | - |
        );

    CONSTANT NEGEDGE : edge_table := (
    --      ---------------------------------------------------- -----
    --      |  U    X    0    1    Z    W    L    H    - |   |
    --      ---------------------------------------------------- -----
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | U |
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | X |
            ( FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 0 |
            ( FALSE, TRUE,  TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 1 |
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | Z |
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | W |
            ( FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | L |
            ( FALSE, TRUE,  TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | H |
            ( FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE, FALSE )  -- | - |
        );

        -------------------------------------------------------------------------------
        --State Table Declaration
        -------------------------------------------------------------------------------

	CONSTANT dfftab : VitalStateTableType := (
	-- D CLK R S lstSt Q
	( '-', '-', '0', '1', '-', '0' ),
	( '-', '-', '1', '0', '-', '1' ),
	( '1', '/', '1', '-', '-', '1' ),
	( '0', '/', '-', '1', '-', '0' ),
	( '1', '-', '1', '*', '1', '1' ),
	( '-', '0', '1', '*', '1', '1' ),
	( '-', '1', '1', '*', '1', '1' ),
	( '1', '-', '0', '\', '0', 'X' ),---
	( '-', '0', '0', '\', '0', 'X' ),---
	( '-', '1', '0', '\', '0', 'X' ),---
	( '0', '-', '*', '1', '0', '0' ),
	( '-', '0', '*', '1', '0', '0' ),
	( '-', '1', '*', '1', '0', '0' ),
	( '0', '-', '\', '0', '1', 'X' ),--
	( '-', '0', '\', '0', '1', 'X' ),--
	( '-', '1', '\', '0', '1', 'X' ),--
	( '1', 'R', '1', '1', '1', '1' ),
	( '0', 'R', '1', '1', '0', '0' ),
	( '-', '\', '-', '-', '-', 'S' ),
	( '-', 'v', '-', '-', '-', 'S' ),
	( '0', 'r', '-', '-', '0', 'S' ),
	( '0', 'f', '-', '-', '0', 'S' ),
	( '1', 'r', '-', '-', '1', 'S' ),
	( '1', 'f', '-', '-', '1', 'S' ),
	( '*', '1', '-', '-', '-', 'S' ),
	( '*', '0', '-', '-', '-', 'S' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT latchtab : VitalStateTableType := (
	-- D LAT R S lstSt Q
	( '-', '-', '0', '1', '-', '0' ),
	( '-', '-', '1', '0', '-', '1' ),
	( '*', '0', '1', '1', '-', 'S' ),
	( '-', '\', '1', '1', '-', 'S' ),
	( '-', 'v', '1', '1', '-', 'S' ),
	( '-', 'f', '1', '1', '-', 'S' ),
	( '0', '^', '-', '1', '-', '0' ),
	( '1', '^', '1', '-', '-', '1' ),
	( '0', 'r', '1', '1', '0', '0' ),
	( '1', 'r', '1', '1', '1', '1' ),
	( '\', '1', '-', '1', '-', '0' ),
	( 'v', '1', '-', '1', '-', '0' ),
	( '/', '1', '1', '-', '-', '1' ),
	( '^', '1', '1', '-', '-', '1' ),
	( '0', '/', '-', '1', '-', '0' ),
	( '1', '/', '1', '-', '-', '1' ),
	( '-', '0', '1', '/', '-', 'S' ),
	( '-', '0', '1', '^', '-', 'S' ),
	( '-', '0', '/', '1', '-', 'S' ),
	( '-', '0', '^', '1', '-', 'S' ),
	( '0', '1', '-', '/', '-', '0' ),
	( '0', '1', '-', '^', '-', '0' ),
	( '1', '1', '/', '-', '-', '1' ),
	( '1', '1', '^', '-', '-', '1' ),
	( '1', '1', '1', '/', '-', '1' ),
	( '1', '1', '1', '^', '-', '1' ),
	( '0', '1', '/', '1', '-', '0' ),
	( '0', '1', '^', '1', '-', '0' ),
	( '/', 'X', '1', '-', '1', '1' ),
	( '^', 'X', '1', '-', '1', '1' ),
	( '\', 'X', '-', '1', '0', '0' ),
	( 'v', 'X', '-', '1', '0', '0' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT jkfftab : VitalStateTableType := (
	-- CLK J K S R lstSt Q
	( '-', '-', '-', '0', '1', '-', '1' ),
	( '-', '-', '-', '1', '0', '-', '0' ),
	( '-', '-', '-', '*', '1', '1', '1' ),
	( '-', '-', '-', '1', '*', '0', '0' ),
	( '/', '0', '0', '1', '1', '-', 'S' ),
	( '/', '0', '1', '1', '1', '-', '0' ),
	( '/', '1', '0', '1', '1', '-', '1' ),
	( '/', '1', '1', '1', '1', '1', '0' ),
	( '/', '1', '1', '1', '1', '0', '1' ),
	( '\', '-', '-', '-', '-', '-', 'S' ),
	( 'B', '*', '-', '-', '-', '-', 'S' ),
	( 'B', '-', '*', '-', '-', '-', 'S' ),
	( 'R', '0', '0', '1', '1', '-', 'S' ),
	( 'R', '0', '-', '1', '-', '0', 'S' ),
	( 'R', '-', '0', '-', '1', '1', 'S' ),
	( 'v', '-', '-', '-', '-', '-', 'S' ),
	( 'f', '0', '0', '1', '1', '-', 'S' ),
	( 'f', '0', '-', '1', '-', '0', 'S' ),
	( 'f', '-', '0', '-', '1', '1', 'S' ),
	( 'X', '*', '0', '-', '1', '1', 'S' ),
	( 'X', '0', '*', '1', '-', '0', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT rsfftab : VitalStateTableType := (
	-- CLK RE SE S R lstSt Q
	( '-', '-', '-', '0', '1', '-', '1' ),
	( '-', '-', '-', '1', '0', '-', '0' ),
	( '-', '1', '1', '/', '1', '-', 'S' ),
	( '-', '1', '1', '^', '1', '-', 'S' ),
	( '-', '1', '1', '1', '/', '-', 'S' ),
	( '-', '1', '1', '1', '^', '-', 'S' ),
	( '/', '0', '0', '1', '1', '-', 'S' ),
	( '/', '0', '1', '1', '1', '-', '1' ),
	( '/', '1', '0', '1', '1', '-', '0' ),
	( '\', '-', '-', '-', '-', '-', 'S' ),
	( 'R', '0', '0', '1', '1', '-', 'S' ),
	( 'R', '0', '-', '1', '-', '0', 'S' ),
	( 'R', '-', '0', '-', '1', '1', 'S' ),
	( 'v', '-', '-', '-', '-', '-', 'S' ),
	( 'f', '0', '0', '1', '1', '-', 'S' ),
	( 'f', '0', '-', '1', '-', '0', 'S' ),
	( 'f', '-', '0', '-', '1', '1', 'S' ),
	( 'X', '*', '0', '-', '1', '1', 'S' ),
	( 'X', '0', '*', '1', '-', '0', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'S', '/', '-', 'S' ),----
	( 'S', 'S', 'S', '/', 'S', '-', 'S' ),----
	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),----
	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ),
	( '-', '*', '-', '1', '1', '-', 'S' ),
	( '-', '-', '*', '1', '1', '-', 'S' ));


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT tfftab : VitalStateTableType := (
	-- CLK T S R lstSt Q
	( '-', '-', '0', '1', '-', '1' ),
	( '-', '-', '1', '0', '-', '0' ),
	( 'X', '0', '1', '-', '0', 'S' ),
	( '-', '-', '*', '1', '1', '1' ),
	( '-', '-', '1', '*', '0', '0' ),
	( '/', '0', '1', '1', '-', 'S' ),
	( '/', '1', '1', '1', '1', '0' ),
	( '/', '1', '1', '1', '0', '1' ),
	( '\', '-', '-', '-', '-', 'S' ),
	( 'B', '*', '-', '-', '-', 'S' ),
	( 'R', '0', '1', '1', '-', 'S' ),
	( 'R', '0', '1', '-', '0', 'S' ),
	( 'R', '0', '-', '1', '1', 'S' ),
	( 'v', '-', '-', '-', '-', 'S' ),
	( 'f', '0', '1', '1', '-', 'S' ),
	( 'f', '-', '-', '1', '1', 'S' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT dffcetab : VitalStateTableType := (
	-- D CLK R S CE lstSt Q
	( '-', '-', '0', '1', '-', '-', '0' ),
	( '-', '-', '1', '0', '-', '-', '1' ),
	( '-', '-', '1', '1', '0', '-', 'S' ),
	( '1', '/', '1', '-', '1', '-', '1' ),
	( '0', '/', '-', '1', '1', '-', '0' ),
	( '1', '-', '1', '*', '1', '1', '1' ),
	( '-', '0', '1', '*', '1', '1', '1' ),
	( '-', '1', '1', '*', '1', '1', '1' ),
	( '0', '-', '*', '1', '1', '0', '0' ),
	( '-', '0', '*', '1', '1', '0', '0' ),
	( '-', '1', '*', '1', '1', '0', '0' ),
	( '1', 'R', '1', '1', '1', '1', '1' ),
	( '0', 'R', '1', '1', '1', '0', '0' ),
	( '-', '\', '-', '-', '1', '-', 'S' ),
	( '-', 'v', '-', '-', '1', '-', 'S' ),
	( '0', 'r', '-', '-', '1', '0', 'S' ),
	( '0', 'f', '-', '-', '1', '0', 'S' ),
	( '1', 'r', '-', '-', '1', '1', 'S' ),
	( '1', 'f', '-', '-', '1', '1', 'S' ),
	( '*', '1', '-', '-', '1', '-', 'S' ),
	( '*', '0', '-', '-', '1', '-', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( '-', '-', '1', '1', '*', '-', 'S' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ) );


end VLOGTOVITAL_TABLES;
 
----- VITAL model for cell AND2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND2 : entity is TRUE;
end AND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of AND2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) AND (I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_AND2_VITAL of AND2 is 
        for VITAL
        end for; 
end CFG_AND2_VITAL;
----- VITAL model for cell AND3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND3 : entity is TRUE;
end AND3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of AND3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) AND (I0_ipd) AND (I2_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_AND3_VITAL of AND3 is 
        for VITAL
        end for; 
end CFG_AND3_VITAL;
----- VITAL model for cell AND4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND4 : entity is TRUE;
end AND4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of AND4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_AND4_VITAL of AND4 is 
        for VITAL
        end for; 
end CFG_AND4_VITAL;
----- VITAL model for cell AND5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND5 : entity is TRUE;
end AND5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of AND5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd) AND (I4_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_AND5_VITAL of AND5 is 
        for VITAL
        end for; 
end CFG_AND5_VITAL;
----- VITAL model for cell AND6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND6 : entity is TRUE;
end AND6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of AND6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd) AND (I4_ipd) AND
         (I5_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_AND6_VITAL of AND6 is 
        for VITAL
        end for; 
end CFG_AND6_VITAL;
----- VITAL model for cell AND7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND7 : entity is TRUE;
end AND7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of AND7 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd) AND (I4_ipd) AND
         (I5_ipd) AND (I6_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_AND7_VITAL of AND7 is 
        for VITAL
        end for; 
end CFG_AND7_VITAL;
----- VITAL model for cell AND8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AND8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AND8 : entity is TRUE;
end AND8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of AND8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) AND (I0_ipd) AND (I2_ipd) AND (I3_ipd) AND (I4_ipd) AND
         (I5_ipd) AND (I6_ipd) AND (I7_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_AND8_VITAL of AND8 is 
        for VITAL
        end for; 
end CFG_AND8_VITAL;


----- CELL MUX2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX2 : entity is TRUE;
end MUX2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, S0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => (I1_ipd, I0_ipd),
                  dselect => (0 => S0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (S0_ipd'last_event, tpd_S0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX2_VITAL of MUX2 is
   for VITAL
   end for;
end CFG_MUX2_VITAL;


----- CELL MUX4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX4 : entity is TRUE;
end MUX4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   VitalWireDelay (S1_ipd, S1, tipd_S1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, S0_ipd, S1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => (I3_ipd, I2_ipd, I1_ipd, I0_ipd),
                  dselect => (S1_ipd, S0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (S0_ipd'last_event, tpd_S0_O, TRUE),
                 5 => (S1_ipd'last_event, tpd_S1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX4_VITAL of MUX4 is
   for VITAL
   end for;
end CFG_MUX4_VITAL;
 
----- VITAL model for cell BI_DIR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity BI_DIR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      OUTOPEN        : string  := "Off";
      PULL           : string  := "Off";
      tpd_OE_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I0_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      IO                             :	inout STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BI_DIR : entity is TRUE;
end BI_DIR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of BI_DIR is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL IO_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   VitalWireDelay (IO_ipd, IO, tipd_IO);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------

   VITALBehavior : process (OE_ipd, I0_ipd, IO_ipd)


   -- functionality results
     VARIABLE O_zd : std_ulogic ;

   -- output glitch detection variables
     VARIABLE IO_GlitchData	: VitalGlitchDataType;
     VARIABLE O_GlitchData	: VitalGlitchDataType;
     VARIABLE IO_zd : std_ulogic ;

   begin
      -------------------------
      --  Functionality Section
      -------------------------

      if (OE_ipd = '0') then
         IO_zd := 'Z';
      elsif (OE_ipd = '1') then
         if (OUTOPEN = "Off") then
             IO_zd := TO_X01(I0_ipd);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
             if (I0_ipd = '0') then
                IO_zd := '0';
             elsif (I0_ipd = '1') then
                IO_zd := 'Z';
             else
                IO_zd := 'X';
             end if;
         end if;
      end if;


      if (PULL = "Off") then
           O_zd := TO_X01(IO_ipd);
      elsif (PULL = "Up") then
           CASE TO_X01Z(IO_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := '1';
              WHEN others => O_zd := 'X';
           END CASE;
      elsif (PULL = "Down") then
           CASE TO_X01Z(IO_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := '0';
              WHEN others => O_zd := 'X';
           END CASE;
      elsif (PULL = "Hold") then
           CASE TO_X01Z(IO_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := O_zd;
              WHEN others => O_zd := 'X';
           END CASE;
      end if;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => IO,
       GlitchData => IO_GlitchData,
       OutSignalName => "IO",
       OutTemp => IO_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_IO), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_IO), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (IO_ipd'last_event, tpd_IO_O, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BI_DIR_VITAL of BI_DIR is 
        for VITAL
        end for; 
end CFG_BI_DIR_VITAL;

----- VITAL model for cell BUFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFF : entity is TRUE;
end BUFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of BUFF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BUFF_VITAL of BUFF is 
        for VITAL
        end for; 
end CFG_BUFF_VITAL;

----- VITAL model for cell BUFTH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFTH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      OUTOPEN        : string := "Off";
      tpd_OE_O                       :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFTH : entity is TRUE;
end BUFTH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of BUFTH is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------

       if (OE = '0') then
          O_zd := 'Z';
       elsif (OE = '1') then
         if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_ipd);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_ipd = '0') then
              O_zd := '0';
           elsif (I0_ipd = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
         end if;
       end if;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => VitalTransport,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_BUFTH_VITAL of BUFTH is 
        for VITAL
        end for; 
end CFG_BUFTH_VITAL;

----- VITAL model for cell BUFTL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFTL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      OUTOPEN       : string := "Off";
      tpd_OE_O                       :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFTL : entity is TRUE;
end BUFTL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of BUFTL is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
       if (OE = '1') then
          O_zd := 'Z';
       elsif (OE = '0') then
         if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_ipd);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_ipd = '0') then
              O_zd := '0';
           elsif (I0_ipd = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
         end if;
       end if;
      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => VitalTransport,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_BUFTL_VITAL of BUFTL is 
        for VITAL
        end for; 
end CFG_BUFTL_VITAL;

----- VITAL model for cell CLKI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CLKI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_PAD_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_PAD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CLKI : entity is TRUE;
end CLKI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of CLKI is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL PAD_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (PAD_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(PAD_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (PAD_ipd'last_event, tpd_PAD_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_CLKI_VITAL of CLKI is 
        for VITAL
        end for; 
end CFG_CLKI_VITAL;

----- VITAL model for cell DFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      R_DELAY : TIME := 2 ns;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 1.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 1.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFF : entity is TRUE;
end DFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFF is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R              : STD_ULOGIC := '0';

begin

   R <= '1' after R_DELAY; 

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, R ,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFF_VITAL of DFF is 
        for VITAL
        end for; 
end CFG_DFF_VITAL;

----- VITAL model for cell DFFC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      R_DELAY : TIME := 2 ns;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge        :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 1.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFC : entity is TRUE;
end DFFC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFC is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R              : STD_ULOGIC := '0';

begin

   R <= '1' after R_DELAY; 

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(CE_ipd) = '1',
          HeaderMsg               => InstancePath & "/DFFC",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_posedge or Tviol_CE_CLK_posedge or Pviol_CLK_CE_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly, R ,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFC_VITAL of DFFC is 
        for VITAL
        end for; 
end CFG_DFFC_VITAL;

----- VITAL model for cell DFFCR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCR : entity is TRUE;
end DFFCR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFCR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, R_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) AND (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_CE_CLK_R_EQ_1_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_posedge_posedge,
          SetupLow                => tsetup_CE_CLK_posedge_posedge,
          HoldHigh                => thold_CE_CLK_posedge_posedge,
          HoldLow                 => thold_CE_CLK_posedge_posedge,
          CheckEnabled            => TO_X01(R_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_R_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_R_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) AND (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge or Tviol_CE_CLK_R_EQ_1_posedge or Tviol_R_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_R_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly,R_CLK_dly,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCR_VITAL of DFFCR is 
        for VITAL
        end for; 
end CFG_DFFCR_VITAL;
----- VITAL model for cell DFFCRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge 		:	VitalDelayType := 1.000 ns;
      tpw_R_posedge 		:	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCRH : entity is TRUE;
end DFFCRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFCRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, R_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R				: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R				: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT R_CLK_dly)) AND (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_CE_CLK_R_EQ_0_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(NOT R_CLK_dly)= '1', 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_R_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_R_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(((NOT R_CLK_dly)) AND (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge or Tviol_CE_CLK_R_EQ_0_posedge or Tviol_R_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_R_EQ_0 or Pviol_R;
      R_inverted := (NOT R_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly,R_inverted,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCRH_VITAL of DFFCRH is 
        for VITAL
        end for; 
end CFG_DFFCRH_VITAL;

----- VITAL model for cell DFFCS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCS : entity is TRUE;
end DFFCS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFCS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, S_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) AND (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_CE_CLK_S_EQ_1_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_posedge_posedge,
          SetupLow                => tsetup_CE_CLK_posedge_posedge,
          HoldHigh                => thold_CE_CLK_posedge_posedge,
          HoldLow                 => thold_CE_CLK_posedge_posedge,
          CheckEnabled            => TO_X01(S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_S_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                          TO_X01((S_CLK_dly) AND (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge or Tviol_CE_CLK_S_EQ_1_posedge or Tviol_S_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly,'1',S_CLK_dly, CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCS_VITAL of DFFCS is 
        for VITAL
        end for; 
end CFG_DFFCS_VITAL;
----- VITAL model for cell DFFCSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tpw_S_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCSH : entity is TRUE;
end DFFCSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFCSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, S_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_CE_CLK_S_EQ_0_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(NOT S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(CE_ipd) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_S_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge or Tviol_CE_CLK_S_EQ_0_posedge or Tviol_S_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_CLK_dly, CLK_dly,'1', S_inverted, CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCSH_VITAL of DFFCSH is 
        for VITAL
        end for; 
end CFG_DFFCSH_VITAL;

----- VITAL model for cell DFFCRS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFFCRS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      tsetup_CE_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      thold_CE_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCRS : entity is TRUE;
end DFFCRS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFCRS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_CLK_dly, CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE CE_delayed : STD_ULOGIC := 'X';
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) AND (CE_CLK_dly) AND (S_CLK_dly))
                            /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_posedge_posedge,
          SetupLow                => tsetup_CE_CLK_posedge_posedge,
          HoldHigh                => thold_CE_CLK_posedge_posedge,
          HoldLow                 => thold_CE_CLK_posedge_posedge,
          CheckEnabled            => TO_X01(R_CLK_dly AND S_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) AND (CE_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) AND (CE_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( (NOT S_CLK_dly) ) OR ( (NOT R_CLK_dly) )
                            ) /= '1',
          HeaderMsg               => InstancePath & "/DFFCRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1_posedge or Tviol_CE_CLK_R_EQ_1_AN_S_EQ_1_posedge or Tviol_R_CLK_CE_EQ_1_AN_S_EQ_1_posedge or Pviol_CLK_CE_EQ_1_AN_R_EQ_1_AN_S_EQ_1 or Tviol_S_CLK_CE_EQ_1_AN_R_EQ_1_posedge;
      CE_delayed := CE_CLK_dly;
      D_delayed := D_CLK_dly;
      CLK_delayed := CLK_dly;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_delayed, CLK_delayed, R_CLK_dly, S_CLK_dly,CE_delayed ));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCRS_VITAL of DFFCRS is 
        for VITAL
        end for; 
end CFG_DFFCRS_VITAL;
----- VITAL model for cell DFFCRSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity DFFCRSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tpw_R_posedge :	VitalDelayType := 1.000 ns;
      tpw_S_posedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCRSH : entity is TRUE;
end DFFCRSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFCRSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';


begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_CLK_dly, CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE CE_delayed : STD_ULOGIC := 'X';
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT R_CLK_dly)) AND (CE_CLK_dly) AND ((NOT
                            S_CLK_dly))) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TO_X01((NOT R_CLK_dly) AND (NOT S_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND (CE_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(((NOT R_CLK_dly)) AND (CE_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( S_CLK_dly ) OR ( R_CLK_dly ) ) /= '1',
          HeaderMsg               => InstancePath & "/DFFCRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0_posedge or Tviol_CE_CLK_R_EQ_0_AN_S_EQ_0_posedge or Tviol_R_CLK_CE_EQ_1_AN_S_EQ_0_posedge or Tviol_S_CLK_CE_EQ_1_AN_R_EQ_0_posedge or Pviol_CLK_CE_EQ_1_AN_R_EQ_0_AN_S_EQ_0 or Pviol_R or Pviol_S;
      CE_delayed := CE_CLK_dly;
      D_delayed := D_CLK_dly;
      CLK_delayed := CLK_dly;
      R_inverted := (NOT R_CLK_dly);
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcetab,
        DataIn => (
               D_delayed, CLK_delayed,R_inverted,S_inverted,CE_delayed));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCRSH_VITAL of DFFCRSH is 
        for VITAL
        end for; 
end CFG_DFFCRSH_VITAL;

----- VITAL model for cell DFFR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFR : entity is TRUE;
end DFFR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/DFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_R_EQ_1_posedge or Tviol_R_CLK_posedge or Pviol_CLK_R_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
              D_CLK_dly, CLK_dly, R_CLK_dly, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFR_VITAL of DFFR is 
        for VITAL
        end for; 
end CFG_DFFR_VITAL;
----- VITAL model for cell DFFRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.000 ns;
      tpw_R_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRH : entity is TRUE;
end DFFRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_R_EQ_0_posedge or Tviol_R_CLK_posedge or Pviol_CLK_R_EQ_0 or Pviol_R;
      R_inverted := (NOT R_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, R_inverted, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRH_VITAL of DFFRH is 
        for VITAL
        end for; 
end CFG_DFFRH_VITAL;
----- VITAL model for cell DFFRS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFFRS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.000 ns;
      tpw_R_negedge :	VitalDelayType := 1.000 ns;
      tpw_S_negedge :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge   :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRS : entity is TRUE;
end DFFRS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFRS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1_AN_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE Pviol_R			: STD_ULOGIC := '0';
   VARIABLE Pviol_S			: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1_AN_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R			: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S			: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) AND (R_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_negedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1_AN_S_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1_AN_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( (NOT S_CLK_dly) ) OR ( (NOT R_CLK_dly) )
                            ) /= '1',
          HeaderMsg               => InstancePath & "/DFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_delayed := D_CLK_dly;
      CLK_delayed := CLK_dly;
      Violation := Tviol_D_CLK_R_EQ_1_AN_S_EQ_1_posedge or Tviol_R_CLK_S_EQ_1_posedge or Tviol_S_CLK_R_EQ_1_posedge or Pviol_CLK_R_EQ_1_AN_S_EQ_1 or Pviol_R or Pviol_S;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_delayed, CLK_delayed, R_CLK_dly, S_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRS_VITAL of DFFRS is 
        for VITAL
        end for; 
end CFG_DFFRS_VITAL;
----- VITAL model for cell DFFRSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFFRSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge 		     :	VitalDelayType := 1.000 ns;
      tpw_R_posedge 		     :	VitalDelayType := 1.000 ns;
      tpw_S_posedge 		     :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge   	     :	VitalDelayType := 1.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge     :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge     :	VitalDelayType := 0.000 ns;
      ticd_CLK                        :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                      :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                      :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                      :	VitalDelayType := 0.000 ns;
      tipd_D                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                          :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRSH : entity is TRUE;
end DFFRSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFRSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_0_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_0_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0_AN_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R			: STD_ULOGIC := '0';
   VARIABLE Pviol_S			: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0_AN_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R			: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S			: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE D_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE R_inverted: STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND ((NOT R_CLK_dly))) /=
                            '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_0_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01((NOT S_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_0_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01((NOT R_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0_AN_S_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0_AN_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( S_CLK_dly ) OR ( R_CLK_dly ) ) /= '1',
          HeaderMsg               => InstancePath & "/DFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_delayed := D_CLK_dly;
      CLK_delayed := CLK_dly;
      R_inverted := NOT R_CLK_dly;
      S_inverted := NOT S_CLK_dly;
      Violation := Tviol_D_CLK_R_EQ_0_AN_S_EQ_0_posedge or Tviol_R_CLK_S_EQ_0_posedge or Tviol_S_CLK_R_EQ_0_posedge or Pviol_CLK_R_EQ_0_AN_S_EQ_0 or Pviol_R or Pviol_S;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_delayed, CLK_delayed, R_inverted, S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRSH_VITAL of DFFRSH is 
        for VITAL
        end for; 
end CFG_DFFRSH_VITAL;

----- VITAL model for cell DFFS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFS : entity is TRUE;
end DFFS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_1,
          PeriodData              => PInfo_CLK_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/DFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_S_EQ_1_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, '1', S_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFS_VITAL of DFFS is 
        for VITAL
        end for; 
end CFG_DFFS_VITAL;
----- VITAL model for cell DFFSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.000 ns;
      tpw_S_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFSH : entity is TRUE;
end DFFSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DFFSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_0,
          PeriodData              => PInfo_CLK_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_S_EQ_0_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_0;
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, '1', S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFSH_VITAL of DFFSH is 
        for VITAL
        end for; 
end CFG_DFFSH_VITAL;
----- VITAL model for cell DLAT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLAT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge            :	VitalDelayType := 1.000 ns;
      tpw_LAT_posedge                :	VitalDelayType := 1.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLAT : entity is TRUE;
end DLAT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DLAT is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_negedge,
          TimingData              => Tmkr_D_LAT_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLAT",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT,
          PeriodData              => PInfo_LAT,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/DLAT",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_negedge or Pviol_LAT;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly,'1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLAT_VITAL of DLAT is 
        for VITAL
        end for; 
end CFG_DLAT_VITAL;
----- VITAL model for cell DLATR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 1.0 ns;
      trecovery_R_LAT_posedge_negedge :	VitalDelayType := 0.1 ns;
      thold_R_LAT_posedge_negedge    :	VitalDelayType := 0.0 ns;
      ticd_LAT                       :	VitalDelayType := 0.0 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.0 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.0 ns;
      tipd_D                         :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_R                         :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATR : entity is TRUE;
end DLATR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DLATR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_1_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_1_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01(R_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_negedge,
          TimingData              => Tmkr_R_LAT_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_posedge_negedge,
          Removal                 => thold_R_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_1,
          PeriodData              => PInfo_LAT_R_EQ_1,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(R_LAT_dly ) = '1',
          HeaderMsg               => InstancePath & "/DLATR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_R_EQ_1_negedge or Tviol_R_LAT_negedge or Pviol_LAT_R_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, R_LAT_dly,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATR_VITAL of DLATR is 
        for VITAL
        end for; 
end CFG_DLATR_VITAL;
----- VITAL model for cell DLATRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.1 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.0 ns;
      tpw_LAT_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_R_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_LAT_negedge_negedge    :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATRH : entity is TRUE;
end DLATRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DLATRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01((R_LAT_dly)) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_negedge,
          TimingData              => Tmkr_R_LAT_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_negedge_negedge,
          Removal                 => thold_R_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_0,
          PeriodData              => PInfo_LAT_R_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((R_LAT_dly) ) = '0',
          HeaderMsg               => InstancePath & "/DLATRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_R_EQ_0_negedge or Tviol_R_LAT_negedge or Pviol_LAT_R_EQ_0;
      R_inverted := (NOT R_LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly,R_inverted,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATRH_VITAL of DLATRH is 
        for VITAL
        end for; 
end CFG_DLATRH_VITAL;
----- VITAL model for cell DLATRS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATRS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge :	VitalDelayType := 1.000 ns;
      tpw_R_negedge :	VitalDelayType := 1.000 ns;
      tpw_S_negedge :	VitalDelayType := 1.000 ns;
      tperiod_LAT_posedge  :	VitalDelayType := 1.000 ns;
      trecovery_R_LAT_posedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_LAT_posedge_negedge :	VitalDelayType := 0.000 ns;
      trecovery_S_LAT_posedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_LAT_posedge_negedge :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATRS : entity is TRUE;
end DLATRS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DLATRS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_S_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_S_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_R_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_R_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_1_ANB_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_1_ANB_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';
   VARIABLE NOT_S_zd : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01((S_LAT_dly) AND (R_LAT_dly)) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_S_EQ_1_negedge,
          TimingData              => Tmkr_R_LAT_S_EQ_1_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_posedge_negedge,
          Removal                 => thold_R_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(S_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_R_EQ_1_negedge,
          TimingData              => Tmkr_S_LAT_R_EQ_1_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_posedge_negedge,
          Removal                 => thold_S_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(R_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_1_ANB_S_EQ_1,
          PeriodData              => PInfo_LAT_R_EQ_1_ANB_S_EQ_1,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( S_LAT_dly ) AND ( R_LAT_dly ) ) = '1',
          HeaderMsg               => InstancePath & "/DLATRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------

        NOT_S_zd := VitalINV (S_LAT_dly);
        D_in_zd := VitalOR2 (NOT_S_zd , D_LAT_dly);

      Violation := Tviol_D_LAT_R_EQ_1_ANB_S_EQ_1_negedge or Tviol_S_LAT_R_EQ_1_negedge or Pviol_LAT_R_EQ_1_ANB_S_EQ_1 or Tviol_R_LAT_S_EQ_1_negedge;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, R_LAT_dly, S_LAT_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE),
                 3 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATRS_VITAL of DLATRS is 
        for VITAL
        end for; 
end CFG_DLATRS_VITAL;
----- VITAL model for cell DLATRSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATRSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge :	VitalDelayType := 1.000 ns;
      tpw_R_posedge :	VitalDelayType := 1.000 ns;
      tpw_S_posedge :	VitalDelayType := 1.000 ns;
      tperiod_LAT_posedge  :	VitalDelayType := 1.000 ns;
      trecovery_R_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_LAT_negedge_negedge     :	VitalDelayType := 0.000 ns;
      trecovery_S_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_LAT_negedge_negedge     :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATRSH : entity is TRUE;
end DLATRSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DLATRSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_R_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_R_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_0_ANB_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R : STD_ULOGIC := '0';
   VARIABLE Pviol_S : STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_0_ANB_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01(((NOT S_LAT_dly)) AND ((NOT R_LAT_dly))) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_S_EQ_0_negedge,
          TimingData              => Tmkr_R_LAT_S_EQ_0_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_negedge_negedge,
          Removal                 => thold_R_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(S_LAT_dly) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_R_EQ_0_negedge,
          TimingData              => Tmkr_S_LAT_R_EQ_0_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_negedge_negedge,
          Removal                 => thold_S_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01(R_LAT_dly) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_0_ANB_S_EQ_0,
          PeriodData              => PInfo_LAT_R_EQ_0_ANB_S_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(((NOT S_LAT_dly)) AND ((NOT R_LAT_dly))) = '1',
          HeaderMsg               => InstancePath & "/DLATRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------

        D_in_zd := VitalOR2 (S_LAT_dly , D_LAT_dly);

      Violation := Tviol_D_LAT_R_EQ_0_ANB_S_EQ_0_negedge or Tviol_R_LAT_S_EQ_0_negedge or Tviol_S_LAT_R_EQ_0_negedge or Pviol_LAT_R_EQ_0_ANB_S_EQ_0 or Pviol_R or Pviol_S;
      S_inverted := (NOT S_LAT_dly);
      R_inverted := (NOT R_LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, R_inverted, S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE),
                 3 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATRSH_VITAL of DLATRSH is 
        for VITAL
        end for; 
end CFG_DLATRSH_VITAL;
----- VITAL model for cell DLATS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 1.0 ns;
      trecovery_S_LAT_posedge_negedge :	VitalDelayType := 0.1 ns;
      thold_S_LAT_posedge_negedge    :	VitalDelayType := 0.0 ns;
      ticd_LAT                       :	VitalDelayType := 0.0 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.0 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.0 ns;
      tipd_D                         :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_S                         :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATS : entity is TRUE;
end DLATS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DLATS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_S_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_S_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_S_EQ_1_negedge,
          TimingData              => Tmkr_D_LAT_S_EQ_1_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01(S_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_negedge,
          TimingData              => Tmkr_S_LAT_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_posedge_negedge,
          Removal                 => thold_S_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_S_EQ_1,
          PeriodData              => PInfo_LAT_S_EQ_1,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(S_LAT_dly ) = '1',
          HeaderMsg               => InstancePath & "/DLATS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_S_EQ_1_negedge or Tviol_S_LAT_negedge or Pviol_LAT_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly,'1', S_LAT_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATS_VITAL of DLATS is 
        for VITAL
        end for; 
end CFG_DLATS_VITAL;
----- VITAL model for cell DLATSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.1 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.0 ns;
      tpw_LAT_posedge         :	VitalDelayType := 1.000 ns;
      tpw_S_posedge         :	VitalDelayType := 1.000 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 1.000 ns;
      trecovery_S_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_LAT_negedge_negedge    :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATSH : entity is TRUE;
end DLATSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of DLATSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_S_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_S_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => 
                           TO_X01((S_LAT_dly)) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_negedge,
          TimingData              => Tmkr_S_LAT_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_negedge_negedge,
          Removal                 => thold_S_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_S_EQ_0,
          PeriodData              => PInfo_LAT_S_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((S_LAT_dly) ) = '0',
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_S_EQ_0_negedge or Tviol_S_LAT_negedge or Pviol_LAT_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, '1',S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATSH_VITAL of DLATSH is 
        for VITAL
        end for; 
end CFG_DLATSH_VITAL;
----- VITAL model for cell GND -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GND is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True);

   port(
      X                              :	out   STD_ULOGIC := '0');
attribute VITAL_LEVEL0 of GND : entity is TRUE;
end GND;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of GND is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

	SIGNAL SUPPLY0    :   STD_ULOGIC := '0';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   --  empty
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------

Inst1 : VitalBUF (X,SUPPLY0);

end VITAL;

configuration CFG_GND_VITAL of GND is 
        for VITAL
        end for; 
end CFG_GND_VITAL;
----- VITAL model for cell GSRBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GSRBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_SRI_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_SRI                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      SRI                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of GSRBUF : entity is TRUE;
end GSRBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of GSRBUF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL SRI_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (SRI_ipd, SRI, tipd_SRI);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (SRI_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(SRI_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (SRI_ipd'last_event, tpd_SRI_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_GSRBUF_VITAL of GSRBUF is 
        for VITAL
        end for; 
end CFG_GSRBUF_VITAL;

----- VITAL model for cell IBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity IBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      PULL           : string  := "Off";
      tpd_I0_O                       :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of IBUF : entity is TRUE;
end IBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of IBUF is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_ULOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_ULOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
        if (PULL = "Off") then
           O_zd := TO_X01(I0_ipd);
        elsif (PULL = "Up") then
           CASE TO_X01Z(I0_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := '1';
              WHEN others => O_zd := 'X';
           END CASE;
        elsif (PULL = "Down") then
           CASE TO_X01Z(I0_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := '0';
              WHEN others => O_zd := 'X';
           END CASE;
        elsif (PULL = "Hold") then
           CASE TO_X01Z(I0_ipd) IS
              WHEN '0'  =>  O_zd := '0';
              WHEN '1'  =>  O_zd := '1';
              WHEN 'Z'  =>  O_zd := O_zd;
              WHEN others => O_zd := 'X';
           END CASE;
        end if;
      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_IBUF_VITAL of IBUF is 
        for VITAL
        end for; 
end CFG_IBUF_VITAL;

----- VITAL model for cell INV -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity INV is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of INV : entity is TRUE;
end INV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of INV is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (NOT I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_INV_VITAL of INV is 
        for VITAL
        end for; 
end CFG_INV_VITAL;

----- VITAL model for cell INVTH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity INVTH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      OUTOPEN        : string := "Off";
      tpd_OE_O                       :	VitalDelayType01z := (0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of INVTH : entity is TRUE;
end INVTH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of INVTH is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);
   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;
   VARIABLE I0_inv          : STD_ULOGIC := 'X';

   begin

      -------------------------
      --  Functionality Section
      -------------------------
       I0_inv := not I0_ipd;

       if (OE = '0') then
          O_zd := 'Z';
       elsif (OE = '1') then
         if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_inv);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_inv = '0') then
              O_zd := '0';
           elsif (I0_inv = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
         end if;
       end if;


      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_INVTH_VITAL of INVTH is 
        for VITAL
        end for; 
end CFG_INVTH_VITAL;

----- VITAL model for cell INVTL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity INVTL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      OUTOPEN        : string := "Off";
      tpd_OE_O                       :	VitalDelayType01z := (0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of INVTL : entity is TRUE;
end INVTL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of INVTL is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;
   VARIABLE I0_inv          : STD_ULOGIC := 'X';

   begin

      -------------------------
      --  Functionality Section
      -------------------------
       I0_inv := not I0_ipd;

       if (OE = '1') then
          O_zd := 'Z';
       elsif (OE = '0') then
         if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_inv);
         elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_inv = '0') then
              O_zd := '0';
           elsif (I0_inv = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
         end if;
       end if;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_INVTL_VITAL of INVTL is 
        for VITAL
        end for; 
end CFG_INVTL_VITAL;

----- VITAL model for cell NAN2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN2 : entity is TRUE;
end NAN2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of NAN2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := ((NOT I1_ipd)) OR ((NOT I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NAN2_VITAL of NAN2 is 
        for VITAL
        end for; 
end CFG_NAN2_VITAL;
----- VITAL model for cell NAN3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I1                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I2                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN3 : entity is TRUE;
end NAN3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of NAN3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NAN3_VITAL of NAN3 is 
        for VITAL
        end for; 
end CFG_NAN3_VITAL;
----- VITAL model for cell NAN4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN4 : entity is TRUE;
end NAN4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of NAN4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NAN4_VITAL of NAN4 is 
        for VITAL
        end for; 
end CFG_NAN4_VITAL;
----- VITAL model for cell NAN5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN5 : entity is TRUE;
end NAN5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of NAN5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd))
         OR ((NOT I4_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NAN5_VITAL of NAN5 is 
        for VITAL
        end for; 
end CFG_NAN5_VITAL;
----- VITAL model for cell NAN6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN6 : entity is TRUE;
end NAN6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of NAN6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd))
         OR ((NOT I4_ipd)) OR ((NOT I5_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NAN6_VITAL of NAN6 is 
        for VITAL
        end for; 
end CFG_NAN6_VITAL;
----- VITAL model for cell NAN7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN7 : entity is TRUE;
end NAN7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of NAN7 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd))
         OR ((NOT I4_ipd)) OR ((NOT I5_ipd)) OR ((NOT I6_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NAN7_VITAL of NAN7 is 
        for VITAL
        end for; 
end CFG_NAN7_VITAL;
----- VITAL model for cell NAN8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NAN8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NAN8 : entity is TRUE;
end NAN8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of NAN8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) OR ((NOT I0_ipd)) OR ((NOT I2_ipd)) OR ((NOT I3_ipd))
         OR ((NOT I4_ipd)) OR ((NOT I5_ipd)) OR ((NOT I6_ipd)) OR ((NOT
         I7_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NAN8_VITAL of NAN8 is 
        for VITAL
        end for; 
end CFG_NAN8_VITAL;

----- VITAL model for cell NOR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I1                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR2 : entity is TRUE;
end NOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of NOR2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := ((NOT I1_ipd)) AND ((NOT I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NOR2_VITAL of NOR2 is 
        for VITAL
        end for; 
end CFG_NOR2_VITAL;
----- VITAL model for cell NOR3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR3 : entity is TRUE;
end NOR3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of NOR3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NOR3_VITAL of NOR3 is 
        for VITAL
        end for; 
end CFG_NOR3_VITAL;
----- VITAL model for cell NOR4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR4 : entity is TRUE;
end NOR4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of NOR4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_NOR4_VITAL of NOR4 is 
        for VITAL
        end for; 
end CFG_NOR4_VITAL;
----- VITAL model for cell NOR5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR5 : entity is TRUE;
end NOR5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of NOR5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd)) AND ((NOT I4_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NOR5_VITAL of NOR5 is 
        for VITAL
        end for; 
end CFG_NOR5_VITAL;
----- VITAL model for cell NOR6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR6 : entity is TRUE;
end NOR6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of NOR6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd)) AND ((NOT I4_ipd)) AND ((NOT I5_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NOR6_VITAL of NOR6 is 
        for VITAL
        end for; 
end CFG_NOR6_VITAL;
----- VITAL model for cell NOR7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR7 : entity is TRUE;
end NOR7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of NOR7 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd)) AND ((NOT I4_ipd)) AND ((NOT I5_ipd)) AND ((NOT I6_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NOR7_VITAL of NOR7 is 
        for VITAL
        end for; 
end CFG_NOR7_VITAL;
----- VITAL model for cell NOR8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity NOR8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of NOR8 : entity is TRUE;
end NOR8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of NOR8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((NOT I1_ipd)) AND ((NOT I0_ipd)) AND ((NOT I2_ipd)) AND ((NOT
         I3_ipd)) AND ((NOT I4_ipd)) AND ((NOT I5_ipd)) AND ((NOT I6_ipd))
         AND ((NOT I7_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_NOR8_VITAL of NOR8 is 
        for VITAL
        end for; 
end CFG_NOR8_VITAL;

----- VITAL model for cell OBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity OBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      OUTOPEN          : string  := "Off";
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OBUF : entity is TRUE;
end OBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of OBUF is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
       if (OUTOPEN = "Off") then
              O_zd := TO_X01(I0_ipd);
       elsif (OUTOPEN = "Drain" or OUTOPEN = "Collect") then
           if (I0_ipd = '0') then
              O_zd := '0';
           elsif (I0_ipd = '1') then
              O_zd := 'Z';
           else
              O_zd := 'X';
           end if;
       end if;
          

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => VitalTransport,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_OBUF_VITAL of OBUF is 
        for VITAL
        end for; 
end CFG_OBUF_VITAL;
----- VITAL model for cell OR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR2 : entity is TRUE;
end OR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of OR2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_OR2_VITAL of OR2 is 
        for VITAL
        end for; 
end CFG_OR2_VITAL;
----- VITAL model for cell OR3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR3 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR3 : entity is TRUE;
end OR3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of OR3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd) OR (I2_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_OR3_VITAL of OR3 is 
        for VITAL
        end for; 
end CFG_OR3_VITAL;
----- VITAL model for cell OR4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR4 : entity is TRUE;
end OR4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of OR4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_OR4_VITAL of OR4 is 
        for VITAL
        end for; 
end CFG_OR4_VITAL;
----- VITAL model for cell OR5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR5 : entity is TRUE;
end OR5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of OR5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd) OR (I4_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_OR5_VITAL of OR5 is 
        for VITAL
        end for; 
end CFG_OR5_VITAL;
----- VITAL model for cell OR6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR6 : entity is TRUE;
end OR6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of OR6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd) OR (I4_ipd) OR (I5_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_OR6_VITAL of OR6 is 
        for VITAL
        end for; 
end CFG_OR6_VITAL;
----- VITAL model for cell OR7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR7 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR7 : entity is TRUE;
end OR7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of OR7 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd) OR (I4_ipd) OR (I5_ipd)
         OR (I6_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_OR7_VITAL of OR7 is 
        for VITAL
        end for; 
end CFG_OR7_VITAL;
----- VITAL model for cell OR8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OR8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OR8 : entity is TRUE;
end OR8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
 
library GDX2;
architecture VITAL of OR8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (I1_ipd) OR (I0_ipd) OR (I2_ipd) OR (I3_ipd) OR (I4_ipd) OR (I5_ipd)
         OR (I6_ipd) OR (I7_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;
 
configuration CFG_OR8_VITAL of OR8 is 
        for VITAL
        end for; 
end CFG_OR8_VITAL;

----- VITAL model for cell TFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge    :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge     :	VitalDelayType := 0.0 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 1.0 ns;
      tpw_CLK_posedge                :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFF : entity is TRUE;
end TFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of TFF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => '0');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_posedge,
          TimingData              => Tmkr_T_CLK_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TRUE,
          HeaderMsg               => InstancePath &"/TFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, '1', '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFF_VITAL of TFF is 
        for VITAL
        end for; 
end CFG_TFF_VITAL;
----- VITAL model for cell TFFR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFFR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.1 ns;
      thold_R_CLK_posedge_posedge    :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFR : entity is TRUE;
end TFFR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of TFFR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_T_CLK_R_EQ_1_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/TFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_R_EQ_1_posedge or Pviol_CLK_R_EQ_1 or Tviol_R_CLK_posedge;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, '1', R_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFR_VITAL of TFFR is 
        for VITAL
        end for; 
end CFG_TFFR_VITAL;
----- VITAL model for cell TFFRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFFRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.1 ns;
      thold_R_CLK_negedge_posedge    :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.0 ns;
      tpw_R_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFRH : entity is TRUE;
end TFFRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of TFFRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_T_CLK_R_EQ_0_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((R_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/TFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_R_EQ_0_posedge or Tviol_R_CLK_posedge or Pviol_CLK_R_EQ_0;
      R_inverted := (NOT R_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, '1', R_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFRH_VITAL of TFFRH is 
        for VITAL
        end for; 
end CFG_TFFRH_VITAL;
----- VITAL model for cell TFFRS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity TFFRS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q             :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q             :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q           :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.1 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.1 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.0 ns;
      tpw_R_negedge :	VitalDelayType := 1.0 ns;
      tpw_S_negedge :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge   :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFRS : entity is TRUE;
end TFFRS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of TFFRS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_R_EQ_1_AN_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_R_EQ_1_AN_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1_AN_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1_AN_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE T_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TimingData              => Tmkr_T_CLK_R_EQ_1_AN_S_EQ_1_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) AND (R_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => 
                           TO_X01(R_CLK_dly) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1_AN_S_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1_AN_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( (NOT S_CLK_dly) ) OR ( (NOT R_CLK_dly) )
                            ) /= '1',
          HeaderMsg               => InstancePath & "/TFFRS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_R_EQ_1_AN_S_EQ_1_posedge or Tviol_R_CLK_S_EQ_1_posedge or Tviol_S_CLK_R_EQ_1_posedge or Pviol_CLK_R_EQ_1_AN_S_EQ_1 or Pviol_R or Pviol_s;
      T_delayed := T_CLK_dly;
      CLK_delayed := CLK_dly;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly,S_CLK_dly, R_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFRS_VITAL of TFFRS is 
        for VITAL
        end for; 
end CFG_TFFRS_VITAL;
----- VITAL model for cell TFFRSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity TFFRSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.1 ns;
      thold_R_CLK_negedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.1 ns;
      thold_S_CLK_negedge_posedge :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge :	VitalDelayType := 1.0 ns;
      tpw_R_posedge :	VitalDelayType := 1.0 ns;
      tpw_S_posedge :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge   :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFRSH : entity is TRUE;
end TFFRSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of TFFRSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_R_EQ_0_AN_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_R_EQ_0_AN_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0_AN_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0_AN_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE T_delayed : STD_ULOGIC := 'X';
   VARIABLE CLK_delayed : STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TimingData              => Tmkr_T_CLK_R_EQ_0_AN_S_EQ_0_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(((NOT S_CLK_dly)) AND ((NOT R_CLK_dly))) /=
                            '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_0_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01((NOT S_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_0_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => 
                           TO_X01((NOT R_CLK_dly)) /= '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0_AN_S_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0_AN_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(( S_CLK_dly ) OR ( R_CLK_dly ) ) /= '1',
          HeaderMsg               => InstancePath & "/TFFRSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_R_EQ_0_AN_S_EQ_0_posedge or Tviol_S_CLK_R_EQ_0_posedge or Pviol_CLK_R_EQ_0_AN_S_EQ_0 or Tviol_R_CLK_S_EQ_0_posedge or Pviol_R or Pviol_S;
      T_delayed := T_CLK_dly;
      CLK_delayed := CLK_dly;
      S_inverted := NOT S_CLK_dly;
      R_inverted := NOT R_CLK_dly;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly,S_inverted, R_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFRSH_VITAL of TFFRSH is 
        for VITAL
        end for; 
end CFG_TFFRSH_VITAL;
----- VITAL model for cell TFFS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFFS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.1 ns;
      thold_S_CLK_posedge_posedge    :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFS : entity is TRUE;
end TFFS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of TFFS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (S_ipd, S, tipd_S);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_T_CLK_S_EQ_1_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_1,
          PeriodData              => PInfo_CLK_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/TFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_S_EQ_1_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, S_CLK_dly, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFS_VITAL of TFFS is 
        for VITAL
        end for; 
end CFG_TFFS_VITAL;
----- VITAL model for cell TFFSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity TFFSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_T_CLK_noedge_posedge :	VitalDelayType := 0.1 ns;
      thold_T_CLK_noedge_posedge :	VitalDelayType := 0.0 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.1 ns;
      thold_S_CLK_negedge_posedge    :	VitalDelayType := 0.0 ns;
      tpw_CLK_posedge         :	VitalDelayType := 1.0 ns;
      tpw_S_posedge         :	VitalDelayType := 1.0 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 1.0 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_T_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_T                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      T                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TFFSH : entity is TRUE;
end TFFSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of TFFSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL T_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL T_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (T_ipd, T, tipd_T);
   VitalWireDelay (S_ipd, S, tipd_S);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (T_CLK_dly, T_ipd, tisd_T_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, T_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_T_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_T_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_T_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_T_CLK_S_EQ_0_posedge,
          TestSignal              => T_CLK_dly,
          TestSignalName          => "T",
          TestDelay               => tisd_T_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_T_CLK_noedge_posedge,
          SetupLow                => tsetup_T_CLK_noedge_posedge,
          HoldHigh                => thold_T_CLK_noedge_posedge,
          HoldLow                 => thold_T_CLK_noedge_posedge,
          CheckEnabled            => 
                           TO_X01((S_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/TFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_0,
          PeriodData              => PInfo_CLK_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => 
                           TO_X01(S_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/TFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_T_CLK_S_EQ_0_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => tfftab,
        DataIn => (
               CLK_dly, T_CLK_dly, S_inverted, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_TFFSH_VITAL of TFFSH is 
        for VITAL
        end for; 
end CFG_TFFSH_VITAL;
----- VITAL model for cell VCC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity VCC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True);

   port(
      X                              :	out   STD_ULOGIC := '1');
attribute VITAL_LEVEL0 of VCC : entity is TRUE;
end VCC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of VCC is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;
   
   SIGNAL SUPPLY1  : STD_ULOGIC := '1'; 

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   --  empty
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------

Inst1: VitalBUF (X,SUPPLY1);

end VITAL;

configuration CFG_VCC_VITAL of VCC is 
        for VITAL
        end for; 
end CFG_VCC_VITAL;

----- VITAL model for cell XOR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity XOR2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of XOR2 : entity is TRUE;

   -- real names
   -- REAL_NAME of XOR2 is "XOR2"
end XOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of XOR2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (((NOT I0_ipd)) AND (I1_ipd)) OR (((NOT I1_ipd)) AND (I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_XOR2_VITAL of XOR2 is 
        for VITAL
        end for; 
end CFG_XOR2_VITAL;

----- VITAL model for cell XORSOFT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity XORSOFT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of XORSOFT : entity is TRUE;
end XORSOFT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of XORSOFT is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       (((NOT I0_ipd)) AND (I1_ipd)) OR (((NOT I1_ipd)) AND (I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_XORSOFT_VITAL of XORSOFT is 
        for VITAL
        end for; 
end CFG_XORSOFT_VITAL;



library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity SPLL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      IN_FREQ: STRING := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN                    :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of SPLL : entity is FALSE;
end SPLL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of SPLL is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(CLK_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => CLK_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "CLK_OUT",
       OutTemp => O_zd,
       Paths => (0 => (CLK_IN_ipd'last_event, tpd_CLK_IN_CLK_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_SPLL_VITAL of SPLL is 
        for VITAL
        end for; 
end CFG_SPLL_VITAL;

----- VITAL model for cell STDPLL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity STDPLL is
   generic(
      IN_FREQ  : string  := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      MULT     : string  := "1";
      DIV      : string  := "1";
      POST     : string  := "1";
      SECDIV   : string  := "2";
      lock_cyc : integer := 2;
      PLL_DLY  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_PLL_LOCK             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN             :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC;
      PLL_LOCK                       :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of STDPLL : entity is FALSE;
end STDPLL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
use GDX2.components.all;
architecture VITAL of STDPLL is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';
  CONSTANT clockboost: integer := str2int(mult) / str2int(div);
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN
     clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;

  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= CLK_IN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)* real(str2int(div))/real(str2int(mult));
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
       clklock_half_period_minus_dly0 <= (NOW - clklock_last_falling_edge) + tpd;
     END IF;
     END IF;
 
  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)* real(str2int(div))/real(str2int(mult)); 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= (NOW - clklock_last_rising_edge) + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc + 1 THEN
        if(clockboost >1) then
	   FOR i IN 1 TO (2*clockboost) LOOP 	         
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	END LOOP;
      else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
      end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    --CLK_OUT_sig_d_start <='1' after tpd; --072904
end process;

process
begin
   wait until CLK_OUT_sig_d_start = '1'; 
   --wait for tpd; --072904
   
   LOOP
     wait for clklock_half_period1;
     CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
     CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
   END LOOP;
end process;

process(clklock_falling_edge_count)
begin
   if (clklock_falling_edge_count >= lock_cyc + 1) then
       CLK_OUT_start <= '1' after clklock_half_period_minus_dly0;
   end if;
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;


    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
    --CLK_OUT_plus_delay <= CLK_OUT_sig_d  when tpd >= 0 ns else  --072904
                          CLK_OUT_sig_3d; 

    CLK_OUT <= CLK_OUT_plus_delay;

    PLL_LOCK <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus;
               

end VITAL;

configuration CFG_STDPLL_VITAL of STDPLL is 
        for VITAL
        end for; 
end CFG_STDPLL_VITAL;


----- VITAL model for cell STDPLLX -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity STDPLLX is
   generic(
      IN_FREQ  : string  := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      MULT     : string  := "1";
      DIV      : string  := "1";
      POST     : string  := "1";
      LOCK_CYC : integer := 2;
      SECDIV   : string   := "2";
      PLL_DLY  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_PLL_RST_PLL_LOCK :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_PLL_LOCK             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_SEC_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PLL_FBK   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PLL_RST   :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      CLK_IN            : in    STD_ULOGIC;
      PLL_FBK           : in    STD_ULOGIC;
      PLL_RST           : in    STD_ULOGIC;
      CLK_OUT           : out   STD_ULOGIC;
      SEC_OUT           : out   STD_ULOGIC;
      PLL_LOCK          : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of STDPLLX : entity is FALSE;
end STDPLLX;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
use GDX2.components.all;


architecture VITAL of STDPLLX is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL PLL_RST_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL secd_delay_minus1 : TIME :=100 ns;
  SIGNAL secd_delay_minus0 : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';

  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';

  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  CONSTANT secdiv_p: integer := str2int(secdiv);
  CONSTANT clockboost: integer := str2int(mult) / str2int(div);
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN
   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   VitalWireDelay (PLL_RST_ipd, PLL_RST, tipd_PLL_RST);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN
      clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;

  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= CLK_IN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)* real(str2int(div))/real(str2int(mult));
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
       clklock_half_period_minus_dly0 <= (NOW - clklock_last_falling_edge) + tpd;
        secd_delay_minus0 <= clklock_half_period0 * secdiv_p + tpd;
     END IF;
     END IF;
 
  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)* real(str2int(div))/real(str2int(mult)); 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= (NOW - clklock_last_rising_edge) + tpd;
        secd_delay_minus1 <= clklock_half_period1 * secdiv_p + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc + 1 and PLL_RST_ipd ='0' THEN
        if(clockboost >1) then
	   FOR i IN 1 TO (2*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

process
begin
   wait until CLK_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
   END LOOP;
end process;

process(clklock_falling_edge_count)
begin
   if (clklock_falling_edge_count >= lock_cyc + 1 and PLL_RST_ipd = '0') then
       CLK_OUT_start <= '1' after clklock_half_period_minus_dly0;
   end if;
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;

process
begin
   wait until SEC_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1 * secdiv_p;
   SEC_OUT_sig_d_not <= not SEC_OUT_sig_d_not;
     wait for clklock_half_period0 * secdiv_p;
   SEC_OUT_sig_d_not <= not SEC_OUT_sig_d_not ;
   END LOOP;
end process;

process(clklock_falling_edge_count)
begin
   if(clklock_falling_edge_count >= lock_cyc + 1 and PLL_RST_ipd = '0') then
        SEC_OUT_start <= '1' after clklock_half_period_minus_dly0;
   end if;
end process;

process
begin
   wait until  SEC_OUT_start = '1'; LOOP
      SEC_OUT_sig_3d <= not SEC_OUT_sig_3d;
     wait for clklock_half_period1 * secdiv_p;
      SEC_OUT_sig_3d <= not SEC_OUT_sig_3d ;
     wait for clklock_half_period0 * secdiv_p;
     END LOOP;
end process;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    CLK_OUT <= CLK_OUT_plus_delay and not PLL_RST_ipd;

    PLL_LOCK <= PLL_LOCK_plus and not PLL_RST_ipd when tpd >= 0 ns else
                PLL_LOCK_minus and  not PLL_RST_ipd;

    SEC_OUT_sig_d <=  SEC_OUT_sig_d_start and not SEC_OUT_sig_d_not; 

    SEC_OUT_plus_delay <= SEC_OUT_sig_d after tpd when tpd >= 0 ns else
                          SEC_OUT_sig_3d; 

    SEC_OUT <= SEC_OUT_plus_delay and not PLL_RST_ipd;

end VITAL;

configuration CFG_STDPLLX_VITAL of STDPLLX is 
        for VITAL
        end for; 
end CFG_STDPLLX_VITAL;



----- VITAL model for cell LVPECLIN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVPECLIN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_P_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tpd_N_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_N_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_P_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      N_IN                            :	in    STD_ULOGIC;
      P_IN                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVPECLIN : entity is FALSE;
end LVPECLIN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of LVPECLIN is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL P_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (P_IN_ipd, P_IN, tipd_P_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (P_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(P_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IN_ipd'last_event, tpd_P_IN_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVPECLIN_VITAL of LVPECLIN is 
        for VITAL
        end for; 
end CFG_LVPECLIN_VITAL;

----- VITAL model for cell LVPECLOUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity LVPECLOUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I_P_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I                             :	in    STD_ULOGIC;
      P_OUT                             :	out   STD_ULOGIC;
      N_OUT                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVPECLOUT : entity is FALSE;
end LVPECLOUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of LVPECLOUT is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (I_ipd'last_event, tpd_I_P_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVPECLOUT_VITAL of LVPECLOUT is 
        for VITAL
        end for; 
end CFG_LVPECLOUT_VITAL;

----- VITAL model for cell LVPECLTRI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVPECLTRI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                            :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVPECLTRI : entity is FALSE;
end LVPECLTRI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;

architecture VITAL of LVPECLTRI is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_OUT), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_OUT), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_LVPECLTRI_VITAL of LVPECLTRI is 
        for VITAL
        end for; 
end CFG_LVPECLTRI_VITAL;

----- VITAL model for cell LVDSIN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVDSIN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_P_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tpd_N_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_N_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_P_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      N_IN                            :	in    STD_ULOGIC;
      P_IN                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSIN : entity is FALSE;
end LVDSIN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
-- -- use GDX2.VTABLES.all;
architecture VITAL of LVDSIN is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL P_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (P_IN_ipd, P_IN, tipd_P_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (P_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(P_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IN_ipd'last_event, tpd_P_IN_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVDSIN_VITAL of LVDSIN is 
        for VITAL
        end for; 
end CFG_LVDSIN_VITAL;

----- VITAL model for cell LVDSOUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity LVDSOUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I_P_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I                             :	in    STD_ULOGIC;
      P_OUT                             :	out   STD_ULOGIC;
      N_OUT                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSOUT : entity is FALSE;
end LVDSOUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
-- use GDX2.VTABLES.all;
architecture VITAL of LVDSOUT is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (I_ipd'last_event, tpd_I_P_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVDSOUT_VITAL of LVDSOUT is 
        for VITAL
        end for; 
end CFG_LVDSOUT_VITAL;

----- VITAL model for cell LVDSTRI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVDSTRI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                            :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSTRI : entity is FALSE;
end LVDSTRI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
--use GDX2.VTABLES.all;
architecture VITAL of LVDSTRI is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_OUT), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_OUT), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_LVDSTRI_VITAL of LVDSTRI is 
        for VITAL
        end for; 
end CFG_LVDSTRI_VITAL;

----- VITAL model for cell LVDSIO -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity LVDSIO is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_P_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_N_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_P_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_N_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_IO                             :	inout STD_ULOGIC;
      N_IO                             :	inout STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSIO : entity is FALSE;
end LVDSIO;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
--use GDX2.VTABLES.all;
architecture VITAL of LVDSIO is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL P_IO_ipd	 : STD_ULOGIC := 'X';
   SIGNAL N_IO_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   VitalWireDelay (P_IO_ipd, P_IO, tipd_P_IO);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd, P_IO_ipd)


   -- functionality results
--   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
     VARIABLE IO_zd : std_ulogic ;
     VARIABLE O_zd : std_ulogic ;

   -- output glitch detection variables
   VARIABLE IO_GlitchData	: VitalGlitchDataType;
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      IO_zd := VitalBUFIF1 (I_ipd, OE_ipd);
      O_zd := VitalBUF(P_IO_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_IO,
       GlitchData => IO_GlitchData,
       OutSignalName => "P_IO",
       OutTemp => IO_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_IO), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_IO), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IO_ipd'last_event, tpd_P_IO_O, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVDSIO_VITAL of LVDSIO is 
        for VITAL
        end for; 
end CFG_LVDSIO_VITAL;
----- VITAL model for cell BLVDSIN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BLVDSIN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_P_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tpd_N_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_N_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_P_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      N_IN                            :	in    STD_ULOGIC;
      P_IN                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSIN : entity is FALSE;
end BLVDSIN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
-- -- use GDX2.VTABLES.all;
architecture VITAL of BLVDSIN is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL P_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (P_IN_ipd, P_IN, tipd_P_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (P_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(P_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IN_ipd'last_event, tpd_P_IN_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BLVDSIN_VITAL of BLVDSIN is 
        for VITAL
        end for; 
end CFG_BLVDSIN_VITAL;

----- VITAL model for cell BLVDSOUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library GDX2 ;
use GDX2.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity BLVDSOUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I_P_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I                             :	in    STD_ULOGIC;
      P_OUT                             :	out   STD_ULOGIC;
      N_OUT                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSOUT : entity is FALSE;
end BLVDSOUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
-- use GDX2.VTABLES.all;
architecture VITAL of BLVDSOUT is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (I_ipd'last_event, tpd_I_P_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BLVDSOUT_VITAL of BLVDSOUT is 
        for VITAL
        end for; 
end CFG_BLVDSOUT_VITAL;

----- VITAL model for cell BLVDSTRI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BLVDSTRI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                            :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSTRI : entity is FALSE;
end BLVDSTRI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
--use GDX2.VTABLES.all;
architecture VITAL of BLVDSTRI is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_OUT), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_OUT), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_BLVDSTRI_VITAL of BLVDSTRI is 
        for VITAL
        end for; 
end CFG_BLVDSTRI_VITAL;

----- VITAL model for cell BLVDSIO -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity BLVDSIO is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_P_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_N_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_P_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_N_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_IO                             :	inout STD_ULOGIC;
      N_IO                             :	inout STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSIO : entity is FALSE;
end BLVDSIO;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
--use GDX2.VTABLES.all;
architecture VITAL of BLVDSIO is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL P_IO_ipd	 : STD_ULOGIC := 'X';
   SIGNAL N_IO_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   VitalWireDelay (P_IO_ipd, P_IO, tipd_P_IO);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd, P_IO_ipd)


   -- functionality results
--   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
     VARIABLE IO_zd : std_ulogic ;
     VARIABLE O_zd : std_ulogic ;

   -- output glitch detection variables
   VARIABLE IO_GlitchData	: VitalGlitchDataType;
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      IO_zd := VitalBUFIF1 (I_ipd, OE_ipd);
      O_zd := VitalBUF(P_IO_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_IO,
       GlitchData => IO_GlitchData,
       OutSignalName => "P_IO",
       OutTemp => IO_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_IO), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_IO), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IO_ipd'last_event, tpd_P_IO_O, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BLVDSIO_VITAL of BLVDSIO is 
        for VITAL
        end for; 
end CFG_BLVDSIO_VITAL;

----- VITAL model for cell CDRX_10B12B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
use ieee.std_logic_unsigned.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity CDRX_10B12B is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "12";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  : string  := "0.0";
      SYMPAT   : string  := "111111000000";

      F_LKDBW  : string  := "00001111";
      F_LKTBW  : string  := "00111111";
      F_TKDBW  : string  := "00011111";
      F_TKTBW  : string  := "01111111";
      F_LOCK   : string  := "011";

      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tipd_REFCLK    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SIN       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CDRRST    :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      SIN               : in    STD_ULOGIC;
      REFCLK            : in    STD_ULOGIC;
      CDRRST            : in    STD_ULOGIC;
      RXD0              : out   STD_ULOGIC;
      RXD1              : out   STD_ULOGIC;
      RXD2              : out   STD_ULOGIC;
      RXD3              : out   STD_ULOGIC;
      RXD4              : out   STD_ULOGIC;
      RXD5              : out   STD_ULOGIC;
      RXD6              : out   STD_ULOGIC;
      RXD7              : out   STD_ULOGIC;
      RXD8              : out   STD_ULOGIC;
      RXD9              : out   STD_ULOGIC;
      RECCLK            : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC;
      SYDT              : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CDRX_10B12B : entity is FALSE;
end CDRX_10B12B;


architecture VITAL of CDRX_10B12B is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL REFCLK_ipd	 : STD_ULOGIC := '0';
  SIGNAL SIN_ipd	 : STD_ULOGIC := '0';
  SIGNAL CDRRST_ipd	 : STD_ULOGIC := '0';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;

  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL sympat_sig1  : std_logic_vector(11 downto 0) := str2std(sympat);
  SIGNAL sympat_sig  : std_logic_vector(19 downto 0); -- := str2std(sympat);

  CONSTANT clockboost: integer := str2int(mult) / str2int(div);
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

  SIGNAL  RECCLK_sig     : std_logic := '0';
  SIGNAL  CDRLOCK        : std_logic := '0';

  SIGNAL  intrecclk      : std_logic := '0';
  SIGNAL  inthsrecclk    : std_logic_vector(15 downto 0);
  SIGNAL  store_buffer   : std_logic_vector(15 downto 0);
  SIGNAL  shift_buffer, shift_buffer_d   : std_logic_vector(15 downto 0) := (others => '0');
  SIGNAL  aclk, sclk     : std_logic := '0';
  SIGNAL  sclksel        : std_logic_vector(15 downto 0);
  SIGNAL  data_ins, data_ina, data_inaa  : std_logic := '0';
  SIGNAL  time_data, time_clock, time_delta  : time ;
  SIGNAL  transition     : std_logic := '0';
  SIGNAL  dn_ss, dn_s, up_s, dn_clk, up_clk  : std_logic := '0';
  SIGNAL  cntrst, pcntrst   : std_logic := '0';
  SIGNAL  dn_cnt0, up_cnt0, dn_cnt, up_cnt  : std_logic_vector(7 downto 0) := (others => '0');
  SIGNAL  sub_cnt    : std_logic_vector(8 downto 0) := (others => '0');  
  SIGNAL  add_cnt, diff_cnt    : std_logic_vector(7 downto 0) := (others => '0');
  SIGNAL  lkdbw      : std_logic_vector(7 downto 0) := str2std(F_LKDBW);
  SIGNAL  lktbw      : std_logic_vector(7 downto 0) := str2std(F_LKTBW);
  SIGNAL  tkdbw      : std_logic_vector(7 downto 0) := str2std(F_TKDBW);
  SIGNAL  tktbw      : std_logic_vector(7 downto 0) := str2std(F_TKTBW);
  SIGNAL  dbw, tbw   : std_logic_vector(7 downto 0) := (others => '0');
  SIGNAL  diffcmp, totce, totcmp, totcmp_d    : std_logic := '0';
  SIGNAL  pre_pull, pre_push, pull, push      : std_logic := '0';
  SIGNAL  lock_rst   : std_logic := '0';
  SIGNAL  lock_cnt   : std_logic_vector(2 downto 0) := "000";
  SIGNAL  lockcmp, lockcmp_d1, lockcmp_d2  : std_logic := '0';
  SIGNAL  lock_int, lock0, lock1, lock2   : std_logic  := '0';
  SIGNAL  lock_pulse  : std_logic := '0';
  SIGNAL  align, pre_align  : std_logic  := '0';
  SIGNAL  rsypt0, rsypt1, rsypt2   : std_logic := '0';
  SIGNAL  divcnt          : std_logic_vector(2 downto 0) := "000";
  SIGNAL  intrecclk1, intrecclk2      : std_logic := '0';
  SIGNAL  divcnt_start      : std_logic := '0';

BEGIN
   sympat_sig(0) <= '0';
   sympat_sig(1) <= '0';
   sympat_sig(2) <= '0';
   sympat_sig(3) <= '0';
   sympat_sig(4) <= '0';
   sympat_sig(5) <= '0';
   sympat_sig(6) <= '0';
   sympat_sig(7) <= '0';
   sympat_sig(8) <= sympat_sig1(11);
   sympat_sig(9) <= sympat_sig1(10);
   sympat_sig(10) <= sympat_sig1(9);
   sympat_sig(11) <= sympat_sig1(8);
   sympat_sig(12) <= sympat_sig1(7);
   sympat_sig(13) <= sympat_sig1(6);
   sympat_sig(14) <= sympat_sig1(5);
   sympat_sig(15) <= sympat_sig1(4);
   sympat_sig(16) <= sympat_sig1(3);
   sympat_sig(17) <= sympat_sig1(2);
   sympat_sig(18) <= sympat_sig1(1);
   sympat_sig(19) <= sympat_sig1(0);

   WireDelay : block
   begin
   VitalWireDelay (REFCLK_ipd, REFCLK, tipd_REFCLK);
   VitalWireDelay (CDRRST_ipd, CDRRST, tipd_CDRRST);
   VitalWireDelay (SIN_ipd, SIN, tipd_SIN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

       clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;

  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= REFCLK_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)* str2int(div)/str2int(mult);
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     elsif clklock_rising_edge_count = 2 THEN
       clklock_half_period_minus_dly0 <= (NOW - clklock_last_falling_edge) + tpd;
       --clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;
     END IF;
     END IF;
 
  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)* str2int(div)/str2int(mult); 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= (NOW - clklock_last_rising_edge) + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc + 1 THEN
         if(clockboost >1) then
	   FOR i IN 1 TO (2*clockboost) LOOP 	     
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

process
begin
    wait until CLK_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
   END LOOP;
end process;

process
begin
   wait until (clklock_falling_edge_count >= lock_cyc + 1);
    wait for clklock_half_period_minus_dly0;
   CLK_OUT_start <= '1';
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    CSLOCK  <= CSLOCK_sig;
    RECCLK <= RECCLK_sig;

--#################
--#16-phase clocks#
--#################

    inthsrecclk(0) <= CLK_OUT_plus_delay;
    inthsrecclk(1) <= inthsrecclk(0) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(2) <= inthsrecclk(1) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(3) <= inthsrecclk(2) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(4) <= inthsrecclk(3) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(5) <= inthsrecclk(4) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(6) <= inthsrecclk(5) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(7) <= inthsrecclk(6) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(8) <= inthsrecclk(7) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(9) <= inthsrecclk(8) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(10) <= inthsrecclk(9) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(11) <= inthsrecclk(10) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(12) <= inthsrecclk(11) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(13) <= inthsrecclk(12) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(14) <= inthsrecclk(13) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(15) <= inthsrecclk(14) after (clklock_half_period*2*str2int(div)/str2int(mult));

--#################
--#digitial filter#
--#################

  process(sclk, SIN_ipd)
  begin
     if (sclk'event and sclk = '1') then
         data_ins <= SIN_ipd;
     end if;
  end process;

  process
  begin
      WAIT UNTIL (SIN_ipd'EVENT); 
         time_data <= NOW;
  end process;

  process
  begin
      WAIT UNTIL (aclk'EVENT AND aclk='1');
         time_clock <= NOW;
  end process;

  process(time_data, time_clock)
  begin
     if(time_data >= time_clock) then
          time_delta <= time_data - time_clock;
     else
          time_delta <= time_clock - time_data;
     end if;
  end process;

  process(aclk, SIN_ipd)
  begin
     if (aclk'event and aclk = '1') then
         data_inaa <= SIN_ipd;
     end if;
  end process;

  process(aclk, time_delta, data_inaa)
  begin
     if(aclk = '1') then
        if (time_delta < 100 ps) then
            data_ina <= 'X';
        else
            data_ina <= data_inaa;
        end if;
     end if;
  end process;
         
  transition <= data_ins XOR data_ina;

  process(sclk, transition)
  begin
    if (sclk = '1') then
        dn_ss <= transition;
    end if;
  end process;

  process(sclk)
  begin
    if (sclk'event and sclk = '1') then
        dn_s <= dn_ss;
    end if;
  end process;

  process(sclk)
  begin
    if (sclk'event and sclk = '1') then
        up_s <= transition;
    end if;
  end process;

  dn_clk <= dn_s and aclk;
  up_clk <= up_s and aclk;

  process(dn_clk, cntrst)
  begin
      if (cntrst = '1') then
          dn_cnt0 <= "00000000";
      elsif((dn_clk'event and dn_clk = '1') or (dn_clk'event and dn_clk = 'X')) then
          dn_cnt0 <= dn_cnt0 + "00000001";
      end if;
  end process;

  process(up_clk, cntrst)
  begin
      if (cntrst = '1') then
          up_cnt0 <= "00000000";
      elsif((up_clk'event and up_clk = '1') or (up_clk'event and up_clk = 'X')) then
          up_cnt0 <= dn_cnt0 + "00000001";
      end if;
  end process;

  process(aclk)
  begin
    if(aclk'event and aclk = '1') then
        dn_cnt <= dn_cnt0;
        up_cnt <= up_cnt0;
    end if;
  end process;

  process(aclk, cntrst)
  begin
    if(cntrst = '1') then
        sub_cnt <= "000000000";
        add_cnt <= "00000000";
    elsif(aclk'event and aclk = '1') then
        add_cnt <= dn_cnt + up_cnt;
    end if;
  end process;

  dbw <= tkdbw when (CDRLOCK = '1') else lkdbw;
  tbw <= tktbw when (CDRLOCK = '1') else lktbw;

  diff_cnt <= not (sub_cnt(7 downto 0)) when (sub_cnt(8) = '1') else sub_cnt(7 downto 0);

  process(aclk, cntrst)
  begin
    if(cntrst = '1') then
        diffcmp <= '0';
    elsif(aclk'event and aclk = '1') then
       if(diff_cnt >= dbw) then
          diffcmp <= '1';
       else
          diffcmp <= '0';
       end if;
    end if;
  end process;

  totce <= '1' when (add_cnt(7 downto 1) = tbw(7 downto 1)) else '0';

  process(aclk, CDRRST_ipd)
  begin
    if(CDRRST_ipd = '1') then
       totcmp <= '0';
    elsif(aclk'event and aclk = '1') then
       totcmp <= totce;
    end if;
  end process;

  process(aclk, CDRRST_ipd)
  begin
    if(CDRRST_ipd = '1') then
       totcmp_d <= '0';
    elsif(aclk'event and aclk = '1') then
       totcmp_d <= totcmp;
    end if;
  end process;

  cntrst <= CDRRST_ipd or totcmp;
  pcntrst <= CDRRST_ipd or totcmp_d;

  process(aclk, pcntrst) 
  begin
    if(pcntrst = '1') then
       pre_push <= '0';
       pre_pull <= '0';
    elsif(aclk'event and aclk = '1') then
       if(totce = '1') then
           pre_push <= diffcmp and not sub_cnt(8);
           pre_pull <= diffcmp and sub_cnt(8);
       end if;
    end if;
  end process;

  process(aclk, CDRRST_ipd)
  begin
    if(CDRRST_ipd = '1') then
        push <= '0';
        pull <= '0';
    elsif(aclk'event and aclk = '1') then
        push <= pre_push;
        pull <= pre_pull;
    end if;
  end process;

--########################
--#phase shift and select#
--########################

  process(aclk, CDRRST_ipd)
  begin
    if(CDRRST_ipd = '1') then
        sclksel <= X"0100";
    elsif(aclk'event and aclk = '1') then
        if(pull = '1') then
            sclksel <= sclksel(0) & sclksel(15 downto 1);
        elsif(push = '1') then
            sclksel <= sclksel(14 downto 0) & sclksel(15);
        end if;
    end if;
  end process;

  process(sclksel, inthsrecclk)
  begin
     case sclksel is
        when X"0001"  =>  
                   aclk <= inthsrecclk(8);
                   sclk <= inthsrecclk(0);
        when X"0002"  => 
                   aclk <= inthsrecclk(9);
                   sclk <= inthsrecclk(1);
        when X"0004"  => 
                   aclk <= inthsrecclk(10);
                   sclk <= inthsrecclk(2);
        when X"0008"  => 
                   aclk <= inthsrecclk(11);
                   sclk <= inthsrecclk(3);
        when X"0010"  => 
                   aclk <= inthsrecclk(12);
                   sclk <= inthsrecclk(4);
        when X"0020"  => 
                   aclk <= inthsrecclk(13);
                   sclk <= inthsrecclk(5);
        when X"0040"  => 
                   aclk <= inthsrecclk(14);
                   sclk <= inthsrecclk(6);
        when X"0080"  => 
                   aclk <= inthsrecclk(15);
                   sclk <= inthsrecclk(7);
        when X"0100"  => 
                   aclk <= inthsrecclk(0);
                   sclk <= inthsrecclk(8);
        when X"0200"  => 
                   aclk <= inthsrecclk(1);
                   sclk <= inthsrecclk(9);
        when X"0400"  => 
                   aclk <= inthsrecclk(2);
                   sclk <= inthsrecclk(10);
        when X"0800"  => 
                   aclk <= inthsrecclk(3);
                   sclk <= inthsrecclk(11);
        when X"1000"  => 
                   aclk <= inthsrecclk(4);
                   sclk <= inthsrecclk(12);
        when X"2000"  => 
                   aclk <= inthsrecclk(5);
                   sclk <= inthsrecclk(13);
        when X"4000"  => 
                   aclk <= inthsrecclk(6);
                   sclk <= inthsrecclk(14);
        when X"8000"  => 
                   aclk <= inthsrecclk(7);
                   sclk <= inthsrecclk(15);
        when others   => 
                   aclk <= inthsrecclk(0);
                   sclk <= inthsrecclk(8);
     end case;
   end process;

--#############
--#LOCK detect#
--#############

   lock_rst <= CDRRST_ipd or pull or push;

   process(totcmp, lock_rst)
   begin
     if (lock_rst = '1') then
         lock_cnt <= "000";
     elsif(totcmp'event and totcmp = '1') then
         lock_cnt <= lock_cnt + "001";
     end if;
   end process;

   lockcmp <= '1' when (lock_cnt = str2std(F_LOCK)) else '0';

   process(aclk, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
          lockcmp_d1 <= '0';
          lockcmp_d2 <= '0';
     elsif (aclk'event and aclk = '1') then
          lockcmp_d1 <= lockcmp;
          lockcmp_d2 <= lockcmp_d1;
     end if;
   end process;

   lock_pulse <= lockcmp_d1 and not lockcmp_d2;

   process(CDRRST_ipd, lock_pulse)
   begin
     if (CDRRST_ipd = '1') then
         lock_int <= '0';
     elsif (lock_pulse = '1') then
         lock_int <= '1';
     end if;
   end process;

   process(sclk, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
          lock0 <= '0';
          lock1 <= '1';
     elsif (sclk'event and sclk = '1') then
          lock0 <= lock_int;
          lock1 <= lock0;
     end if;
   end process;

   lock2 <= lock1 after 10 ps;

   process(RECCLK_sig, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
          CDRLOCK <= '0';
     elsif (RECCLK_sig'event and RECCLK_sig = '1') then
          CDRLOCK <= lock2;
     end if;
   end process;

--######################################
--#SYNC detect & recover data and clock#
--######################################

   process(sclk)
   begin
     if (sclk'event and sclk = '1') then
         shift_buffer(15) <= data_ins;
         shift_buffer(14 downto 0) <= shift_buffer(15 downto 1);
     end if;
   end process;

   process(sclk, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
         pre_align <= '0';
     elsif (sclk'event and sclk = '1') then
         if (shift_buffer(15 downto 4) = sympat_sig(19 downto 8)) then
               pre_align <= '1';
         else  pre_align <= '0';
         end if;
     end if;
   end process;

   process(sclk, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
         align <= '0';
         rsypt0 <= '0';
     elsif (sclk'event and sclk = '1') then
         align <= pre_align;
         rsypt0 <= pre_align;
     end if;
   end process;

   process(sclk, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
         rsypt1 <= '0';
     elsif (sclk'event and sclk = '1') then
         rsypt1 <= rsypt0;
     end if;
   end process;

   rsypt2 <= rsypt1 after 10 ps;

   process(divcnt, divcnt_start)
   begin
      if(divcnt_start = '1') then
       if (divcnt = "010") then
            intrecclk1 <= '0';
       else
            intrecclk1 <= '1';
       end if;
      end if;
   end process;

   divcnt_start <= divcnt_start or align;
   process(sclk, align, divcnt)
   begin
     if (align'event and align = '1') then
         divcnt <= "111";
     elsif (sclk'event and sclk = '1' and divcnt_start = '1') then
         if (divcnt = "010") then
              divcnt <= "111";
         else
              divcnt <= divcnt - "001";
         end if;
     end if;
   end process;

   process(sclk)
   begin
     if (sclk'event and sclk = '1') then
          intrecclk2 <= intrecclk1;
     end if;
   end process;

   process(intrecclk2, align)
   begin
     if (align = '1') then
          intrecclk <= '0';
     elsif (intrecclk2'event and intrecclk2 = '1') then
          intrecclk <= not intrecclk;
     end if;
   end process;

   process(sclk)
   begin
     if (sclk'event and sclk = '1') then
          RECCLK_sig <= intrecclk;
     end if;
   end process;

   process(RECCLK_sig, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
          SYDT <= '0';
     elsif (RECCLK_sig'event and RECCLK_sig = '1') then
          SYDT <= rsypt2;
     end if;
   end process;

   shift_buffer_d <= shift_buffer after 10 ps;

   process(RECCLK_sig)
   begin
     if (RECCLK_sig'event and RECCLK_sig = '1') then
          store_buffer <= shift_buffer_d;
     end if;
   end process;

   RXD0 <= store_buffer(2);
   RXD1 <= store_buffer(3);
   RXD2 <= store_buffer(4);
   RXD3 <= store_buffer(5);
   RXD4 <= store_buffer(6);
   RXD5 <= store_buffer(7);
   RXD6 <= store_buffer(8);
   RXD7 <= store_buffer(9);
   RXD8 <= store_buffer(10);
   RXD9 <= store_buffer(11);

end VITAL;

configuration CFG_CDRX_10B12B_VITAL of CDRX_10B12B is 
        for VITAL
        end for; 
end CFG_CDRX_10B12B_VITAL;

----- VITAL model for cell CDRX_8B10B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
use ieee.std_logic_unsigned.all;

library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity CDRX_8B10B is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "10";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  : string  := "0.0";
      SYMPAT   : string  := "11000001010011111010";

      F_LKDBW  : string  := "00011001";
      F_LKTBW  : string  := "01111111";
      F_TKDBW  : string  := "00011001";
      F_TKTBW  : string  := "01111111";
      F_LOCK   : string  := "011";

      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tipd_REFCLK    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SIN       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CDRRST    :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      SIN               : in    STD_ULOGIC;
      REFCLK            : in    STD_ULOGIC;
      CDRRST            : in    STD_ULOGIC;
      RXD0              : out   STD_ULOGIC;
      RXD1              : out   STD_ULOGIC;
      RXD2              : out   STD_ULOGIC;
      RXD3              : out   STD_ULOGIC;
      RXD4              : out   STD_ULOGIC;
      RXD5              : out   STD_ULOGIC;
      RXD6              : out   STD_ULOGIC;
      RXD7              : out   STD_ULOGIC;
      RXD8              : out   STD_ULOGIC;
      RXD9              : out   STD_ULOGIC;
      RECCLK            : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC;
      SYDT              : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CDRX_8B10B : entity is FALSE;
end CDRX_8B10B;


architecture VITAL of CDRX_8B10B is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL REFCLK_ipd	 : STD_ULOGIC := '0';
  SIGNAL SIN_ipd	 : STD_ULOGIC := '0';
  SIGNAL CDRRST_ipd	 : STD_ULOGIC := '0';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;

  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL sympat_sig1  : std_logic_vector(19 downto 0) := str2std(sympat);
  SIGNAL sympat_sig  : std_logic_vector(19 downto 0); -- := str2std(sympat);

  CONSTANT clockboost: integer := str2int(mult) / str2int(div);
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

  SIGNAL  RECCLK_sig     : std_logic := '0';
  SIGNAL  CDRLOCK        : std_logic := '0';

  SIGNAL  intrecclk      : std_logic := '0';
  SIGNAL  inthsrecclk    : std_logic_vector(15 downto 0);
  SIGNAL  store_buffer   : std_logic_vector(15 downto 0);
  SIGNAL  shift_buffer, shift_buffer_d   : std_logic_vector(15 downto 0) := (others => '0');
  SIGNAL  aclk, sclk     : std_logic := '0';
  SIGNAL  sclksel        : std_logic_vector(15 downto 0);
  SIGNAL  data_ins, data_ina, data_inaa  : std_logic := '0';
  SIGNAL  time_data, time_clock, time_delta  : time ;
  SIGNAL  transition     : std_logic := '0';
  SIGNAL  dn_ss, dn_s, up_s, dn_clk, up_clk  : std_logic := '0';
  SIGNAL  cntrst, pcntrst   : std_logic := '0';
  SIGNAL  dn_cnt0, up_cnt0, dn_cnt, up_cnt  : std_logic_vector(7 downto 0) := (others => '0');
  SIGNAL  sub_cnt    : std_logic_vector(8 downto 0) := (others => '0');  
  SIGNAL  add_cnt, diff_cnt    : std_logic_vector(7 downto 0) := (others => '0');
  SIGNAL  lkdbw      : std_logic_vector(7 downto 0) := str2std(F_LKDBW);
  SIGNAL  lktbw      : std_logic_vector(7 downto 0) := str2std(F_LKTBW);
  SIGNAL  tkdbw      : std_logic_vector(7 downto 0) := str2std(F_TKDBW);
  SIGNAL  tktbw      : std_logic_vector(7 downto 0) := str2std(F_TKTBW);
  SIGNAL  dbw, tbw   : std_logic_vector(7 downto 0) := (others => '0');
  SIGNAL  diffcmp, totce, totcmp, totcmp_d    : std_logic := '0';
  SIGNAL  pre_pull, pre_push, pull, push      : std_logic := '0';
  SIGNAL  lock_rst   : std_logic := '0';
  SIGNAL  lock_cnt   : std_logic_vector(2 downto 0) := "000";
  SIGNAL  lockcmp, lockcmp_d1, lockcmp_d2  : std_logic := '0';
  SIGNAL  lock_int, lock0, lock1, lock2   : std_logic  := '0';
  SIGNAL  lock_pulse  : std_logic := '0';
  SIGNAL  align, pre_align1, pre_align2  : std_logic  := '0';
  SIGNAL  rsypt0, rsypt1, rsypt2   : std_logic := '0';
  SIGNAL  divcnt          : std_logic_vector(2 downto 0) := "000";
  SIGNAL  intrecclk1, intrecclk2      : std_logic := '0';
  SIGNAL  divcnt_start      : std_logic := '0';

BEGIN
   sympat_sig(0) <= sympat_sig1(19);
   sympat_sig(1) <= sympat_sig1(18);
   sympat_sig(2) <= sympat_sig1(17);
   sympat_sig(3) <= sympat_sig1(16);
   sympat_sig(4) <= sympat_sig1(15);
   sympat_sig(5) <= sympat_sig1(14);
   sympat_sig(6) <= sympat_sig1(13);
   sympat_sig(7) <= sympat_sig1(12);
   sympat_sig(8) <= sympat_sig1(11);
   sympat_sig(9) <= sympat_sig1(10);
   sympat_sig(10) <= sympat_sig1(9);
   sympat_sig(11) <= sympat_sig1(8);
   sympat_sig(12) <= sympat_sig1(7);
   sympat_sig(13) <= sympat_sig1(6);
   sympat_sig(14) <= sympat_sig1(5);
   sympat_sig(15) <= sympat_sig1(4);
   sympat_sig(16) <= sympat_sig1(3);
   sympat_sig(17) <= sympat_sig1(2);
   sympat_sig(18) <= sympat_sig1(1);
   sympat_sig(19) <= sympat_sig1(0);

   WireDelay : block
   begin
   VitalWireDelay (REFCLK_ipd, REFCLK, tipd_REFCLK);
   VitalWireDelay (CDRRST_ipd, CDRRST, tipd_CDRRST);
   VitalWireDelay (SIN_ipd, SIN, tipd_SIN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

       clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;

  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= REFCLK_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)* str2int(div)/str2int(mult);
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     elsif clklock_rising_edge_count = 2 THEN
       clklock_half_period_minus_dly0 <= (NOW - clklock_last_falling_edge) + tpd;
       --clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;
     END IF;
     END IF;
 
  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)* str2int(div)/str2int(mult); 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= (NOW - clklock_last_rising_edge) + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc + 1 THEN
         if(clockboost >1) then
	   FOR i IN 1 TO (2*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

process
begin
    wait until CLK_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
   END LOOP;
end process;

process
begin
   wait until (clklock_falling_edge_count >= lock_cyc + 1);
    wait for clklock_half_period_minus_dly0;
   CLK_OUT_start <= '1';
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    CSLOCK  <= CSLOCK_sig;
    RECCLK <= RECCLK_sig;

--#################
--#16-phase clocks#
--#################

    inthsrecclk(0) <= CLK_OUT_plus_delay;
    inthsrecclk(1) <= inthsrecclk(0) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(2) <= inthsrecclk(1) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(3) <= inthsrecclk(2) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(4) <= inthsrecclk(3) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(5) <= inthsrecclk(4) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(6) <= inthsrecclk(5) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(7) <= inthsrecclk(6) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(8) <= inthsrecclk(7) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(9) <= inthsrecclk(8) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(10) <= inthsrecclk(9) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(11) <= inthsrecclk(10) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(12) <= inthsrecclk(11) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(13) <= inthsrecclk(12) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(14) <= inthsrecclk(13) after (clklock_half_period*2*str2int(div)/str2int(mult));
    inthsrecclk(15) <= inthsrecclk(14) after (clklock_half_period*2*str2int(div)/str2int(mult));

--#################
--#digitial filter#
--#################

  process(sclk, SIN_ipd)
  begin
     if (sclk'event and sclk = '1') then
         data_ins <= SIN_ipd;
     end if;
  end process;

  process
  begin
      WAIT UNTIL (SIN_ipd'EVENT); 
         time_data <= NOW;
  end process;

  process
  begin
      WAIT UNTIL (aclk'EVENT AND aclk='1');
         time_clock <= NOW;
  end process;

  process(time_data, time_clock)
  begin
     if(time_data >= time_clock) then
          time_delta <= time_data - time_clock;
     else
          time_delta <= time_clock - time_data;
     end if;
  end process;

  process(aclk, SIN_ipd)
  begin
     if (aclk'event and aclk = '1') then
         data_inaa <= SIN_ipd;
     end if;
  end process;

  process(aclk, time_delta, data_inaa)
  begin
     if(aclk = '1') then
        if (time_delta < 100 ps) then
            data_ina <= 'X';
        else
            data_ina <= data_inaa;
        end if;
     end if;
  end process;
         
  transition <= data_ins XOR data_ina;

  process(sclk, transition)
  begin
    if (sclk = '1') then
        dn_ss <= transition;
    end if;
  end process;

  process(sclk)
  begin
    if (sclk'event and sclk = '1') then
        dn_s <= dn_ss;
    end if;
  end process;

  process(sclk)
  begin
    if (sclk'event and sclk = '1') then
        up_s <= transition;
    end if;
  end process;

  dn_clk <= dn_s and aclk;
  up_clk <= up_s and aclk;

  process(dn_clk, cntrst)
  begin
      if (cntrst = '1') then
          dn_cnt0 <= "00000000";
      elsif((dn_clk'event and dn_clk = '1') or (dn_clk'event and dn_clk = 'X')) then
          dn_cnt0 <= dn_cnt0 + "00000001";
      end if;
  end process;

  process(up_clk, cntrst)
  begin
      if (cntrst = '1') then
          up_cnt0 <= "00000000";
      elsif((up_clk'event and up_clk = '1') or (up_clk'event and up_clk = 'X')) then
          up_cnt0 <= dn_cnt0 + "00000001";
      end if;
  end process;

  process(aclk)
  begin
    if(aclk'event and aclk = '1') then
        dn_cnt <= dn_cnt0;
        up_cnt <= up_cnt0;
    end if;
  end process;

  process(aclk, cntrst)
  begin
    if(cntrst = '1') then
        sub_cnt <= "000000000";
        add_cnt <= "00000000";
    elsif(aclk'event and aclk = '1') then
        add_cnt <= dn_cnt + up_cnt;
    end if;
  end process;

  dbw <= tkdbw when (CDRLOCK = '1') else lkdbw;
  tbw <= tktbw when (CDRLOCK = '1') else lktbw;

  diff_cnt <= not (sub_cnt(7 downto 0)) when (sub_cnt(8) = '1') else sub_cnt(7 downto 0);

  process(aclk, cntrst)
  begin
    if(cntrst = '1') then
        diffcmp <= '0';
    elsif(aclk'event and aclk = '1') then
       if(diff_cnt >= dbw) then
          diffcmp <= '1';
       else
          diffcmp <= '0';
       end if;
    end if;
  end process;

  totce <= '1' when (add_cnt(7 downto 1) = tbw(7 downto 1)) else '0';

  process(aclk, CDRRST_ipd)
  begin
    if(CDRRST_ipd = '1') then
       totcmp <= '0';
    elsif(aclk'event and aclk = '1') then
       totcmp <= totce;
    end if;
  end process;

  process(aclk, CDRRST_ipd)
  begin
    if(CDRRST_ipd = '1') then
       totcmp_d <= '0';
    elsif(aclk'event and aclk = '1') then
       totcmp_d <= totcmp;
    end if;
  end process;

  cntrst <= CDRRST_ipd or totcmp;
  pcntrst <= CDRRST_ipd or totcmp_d;

  process(aclk, pcntrst) 
  begin
    if(pcntrst = '1') then
       pre_push <= '0';
       pre_pull <= '0';
    elsif(aclk'event and aclk = '1') then
       if(totce = '1') then
           pre_push <= diffcmp and not sub_cnt(8);
           pre_pull <= diffcmp and sub_cnt(8);
       end if;
    end if;
  end process;

  process(aclk, CDRRST_ipd)
  begin
    if(CDRRST_ipd = '1') then
        push <= '0';
        pull <= '0';
    elsif(aclk'event and aclk = '1') then
        push <= pre_push;
        pull <= pre_pull;
    end if;
  end process;

--########################
--#phase shift and select#
--########################

  process(aclk, CDRRST_ipd)
  begin
    if(CDRRST_ipd = '1') then
        sclksel <= X"0100";
    elsif(aclk'event and aclk = '1') then
        if(pull = '1') then
            sclksel <= sclksel(0) & sclksel(15 downto 1);
        elsif(push = '1') then
            sclksel <= sclksel(14 downto 0) & sclksel(15);
        end if;
    end if;
  end process;

  process(sclksel, inthsrecclk)
  begin
     case sclksel is
        when X"0001"  =>  
                   aclk <= inthsrecclk(8);
                   sclk <= inthsrecclk(0);
        when X"0002"  => 
                   aclk <= inthsrecclk(9);
                   sclk <= inthsrecclk(1);
        when X"0004"  => 
                   aclk <= inthsrecclk(10);
                   sclk <= inthsrecclk(2);
        when X"0008"  => 
                   aclk <= inthsrecclk(11);
                   sclk <= inthsrecclk(3);
        when X"0010"  => 
                   aclk <= inthsrecclk(12);
                   sclk <= inthsrecclk(4);
        when X"0020"  => 
                   aclk <= inthsrecclk(13);
                   sclk <= inthsrecclk(5);
        when X"0040"  => 
                   aclk <= inthsrecclk(14);
                   sclk <= inthsrecclk(6);
        when X"0080"  => 
                   aclk <= inthsrecclk(15);
                   sclk <= inthsrecclk(7);
        when X"0100"  => 
                   aclk <= inthsrecclk(0);
                   sclk <= inthsrecclk(8);
        when X"0200"  => 
                   aclk <= inthsrecclk(1);
                   sclk <= inthsrecclk(9);
        when X"0400"  => 
                   aclk <= inthsrecclk(2);
                   sclk <= inthsrecclk(10);
        when X"0800"  => 
                   aclk <= inthsrecclk(3);
                   sclk <= inthsrecclk(11);
        when X"1000"  => 
                   aclk <= inthsrecclk(4);
                   sclk <= inthsrecclk(12);
        when X"2000"  => 
                   aclk <= inthsrecclk(5);
                   sclk <= inthsrecclk(13);
        when X"4000"  => 
                   aclk <= inthsrecclk(6);
                   sclk <= inthsrecclk(14);
        when X"8000"  => 
                   aclk <= inthsrecclk(7);
                   sclk <= inthsrecclk(15);
        when others   => 
                   aclk <= inthsrecclk(0);
                   sclk <= inthsrecclk(8);
     end case;
   end process;

--#############
--#LOCK detect#
--#############

   lock_rst <= CDRRST_ipd or pull or push;

   process(totcmp, lock_rst)
   begin
     if (lock_rst = '1') then
         lock_cnt <= "000";
     elsif(totcmp'event and totcmp = '1') then
         lock_cnt <= lock_cnt + "001";
     end if;
   end process;

   lockcmp <= '1' when (lock_cnt = str2std(F_LOCK)) else '0';

   process(aclk, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
          lockcmp_d1 <= '0';
          lockcmp_d2 <= '0';
     elsif (aclk'event and aclk = '1') then
          lockcmp_d1 <= lockcmp;
          lockcmp_d2 <= lockcmp_d1;
     end if;
   end process;

   lock_pulse <= lockcmp_d1 and not lockcmp_d2;

   process(CDRRST_ipd, lock_pulse)
   begin
     if (CDRRST_ipd = '1') then
         lock_int <= '0';
     elsif (lock_pulse = '1') then
         lock_int <= '1';
     end if;
   end process;

   process(sclk, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
          lock0 <= '0';
          lock1 <= '1';
     elsif (sclk'event and sclk = '1') then
          lock0 <= lock_int;
          lock1 <= lock0;
     end if;
   end process;

   lock2 <= lock1 after 10 ps;

   process(RECCLK_sig, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
          CDRLOCK <= '0';
     elsif (RECCLK_sig'event and RECCLK_sig = '1') then
          CDRLOCK <= lock2;
     end if;
   end process;

--######################################
--#SYNC detect & recover data and clock#
--######################################

   process(sclk)
   begin
     if (sclk'event and sclk = '1') then
         shift_buffer(15) <= data_ins;
         shift_buffer(14 downto 0) <= shift_buffer(15 downto 1);
     end if;
   end process;

   process(sclk, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
         pre_align1 <= '0';
         pre_align2 <= '0';
     elsif (sclk'event and sclk = '1') then
         if (shift_buffer(15 downto 6) = sympat_sig(9 downto 0)) then
               pre_align1 <= '1';
         else  pre_align1 <= '0';
         end if;

         if (shift_buffer(15 downto 6) = sympat_sig(19 downto 10)) then
               pre_align2 <= '1' ;
         else  pre_align2 <= '0';
         end if;
     end if;
   end process;

   process(sclk, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
         align <= '0';
         rsypt0 <= '0';
     elsif (sclk'event and sclk = '1') then
         align <= pre_align1 or pre_align2;
         rsypt0 <= pre_align1 or pre_align2;
     end if;
   end process;

   process(sclk, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
         rsypt1 <= '0';
     elsif (sclk'event and sclk = '1') then
         rsypt1 <= rsypt0;
     end if;
   end process;

   rsypt2 <= rsypt1 after 10 ps;

   process(divcnt, divcnt_start)
   begin
      if(divcnt_start = '1') then
       if (divcnt = "011") then
            intrecclk1 <= '0';
       else
            intrecclk1 <= '1';
       end if;
      end if;
   end process;

   divcnt_start <= divcnt_start or align;
   process(sclk, align, divcnt)
   begin
     if (align'event and align = '1') then
         divcnt <= "111";
     elsif (sclk'event and sclk = '1' and divcnt_start = '1') then
         if (divcnt = "011") then
              divcnt <= "111";
         else
              divcnt <= divcnt - "001";
         end if;
     end if;
   end process;

   process(sclk)
   begin
     if (sclk'event and sclk = '1') then
          intrecclk2 <= intrecclk1;
     end if;
   end process;

   process(intrecclk2, align)
   begin
     if (align = '1') then
          intrecclk <= '0';
     elsif (intrecclk2'event and intrecclk2 = '1') then
          intrecclk <= not intrecclk;
     end if;
   end process;

   process(sclk)
   begin
     if (sclk'event and sclk = '1') then
          RECCLK_sig <= intrecclk;
     end if;
   end process;

   process(RECCLK_sig, CDRRST_ipd)
   begin
     if (CDRRST_ipd = '1') then
          SYDT <= '0';
     elsif (RECCLK_sig'event and RECCLK_sig = '1') then
          SYDT <= rsypt2;
     end if;
   end process;

   shift_buffer_d <= shift_buffer after 10 ps;

   process(RECCLK_sig)
   begin
     if (RECCLK_sig'event and RECCLK_sig = '1') then
          store_buffer <= shift_buffer_d;
     end if;
   end process;

   RXD0 <= store_buffer(3);
   RXD1 <= store_buffer(4);
   RXD2 <= store_buffer(5);
   RXD3 <= store_buffer(6);
   RXD4 <= store_buffer(7);
   RXD5 <= store_buffer(8);
   RXD6 <= store_buffer(9);
   RXD7 <= store_buffer(10);
   RXD8 <= store_buffer(11);
   RXD9 <= store_buffer(12);

end VITAL;

configuration CFG_CDRX_8B10B_VITAL of CDRX_8B10B is 
        for VITAL
        end for; 
end CFG_CDRX_8B10B_VITAL;

----- VITAL model for cell CDRX_SS_4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity CDRX_SS_4 is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "4";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  : string  := "0.0";
      SYMPAT   : string  := "110011001100";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tipd_CAL       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SIN       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS_CLKIN   :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      SIN               : in    STD_ULOGIC;
      CAL               : in    STD_ULOGIC;
      SS_CLKIN          : in    STD_ULOGIC;
      RXD0              : out   STD_ULOGIC;
      RXD1              : out   STD_ULOGIC;
      RXD2              : out   STD_ULOGIC;
      RXD3              : out   STD_ULOGIC;
      RECCLK            : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC;
      SYDT              : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CDRX_SS_4 : entity is FALSE;
end CDRX_SS_4;

architecture VITAL of CDRX_SS_4 is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL SS_CLKIN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL SIN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL CAL_ipd         : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL sync_valid        : std_logic := '0';
  SIGNAL sync_valid_store  : std_logic := '0';
  SIGNAL sync_found        : std_logic := '0';
  SIGNAL sync_detect       : std_logic := '0';
  SIGNAL sync_detect_d     : std_logic := '0';
  SIGNAL sync_detect_d1    : std_logic := '0';
  SIGNAL sync_detect_d2    : std_logic := '0';

  SIGNAL symstr_buffer    : std_logic_vector(11 downto 0) := (others=>'0');
  SIGNAL store_buffer     : std_logic_vector(3 downto 0) := (others=>'0');
  SIGNAL shift_buffer     : std_logic_vector(3 downto 0) := (others=>'0');

  SIGNAL sympat_sig  : std_logic_vector(11 downto 0) := str2std(sympat);

  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (SS_CLKIN_ipd, SS_CLKIN, tipd_SS_CLKIN);
   VitalWireDelay (CAL_ipd, CAL, tipd_CAL);
   VitalWireDelay (SIN_ipd, SIN, tipd_SIN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= SS_CLKIN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= SS_CLKIN;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    --ct101804 intrecclk  <= SS_CLKIN;
    RECCLK     <= intrecclk ;
    CSLOCK  <= CSLOCK_sig;

process(inthsrecclk,SS_CLKIN)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d <= SS_CLKIN;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d1 <= intrecclk_d;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d2 <= intrecclk_d1;
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
       shift_buffer(3)  <= SIN_ipd;
       shift_buffer(2)  <= shift_buffer(3);
       shift_buffer(1)  <= shift_buffer(2);
       shift_buffer(0)  <= shift_buffer(1);

       symstr_buffer(11) <= SIN_ipd;
       symstr_buffer(10) <= symstr_buffer(11);
       symstr_buffer(9)  <= symstr_buffer(10);
       symstr_buffer(8)  <= symstr_buffer(9);
       symstr_buffer(7)  <= symstr_buffer(8);
       symstr_buffer(6)  <= symstr_buffer(7);
       symstr_buffer(5)  <= symstr_buffer(6);
       symstr_buffer(4)  <= symstr_buffer(5);
       symstr_buffer(3)  <= symstr_buffer(4);
       symstr_buffer(2)  <= symstr_buffer(3);
       symstr_buffer(1)  <= symstr_buffer(2);
       symstr_buffer(0)  <= symstr_buffer(1);
    end if;
end process;

process(inthsrecclk, symstr_buffer)
begin
    if(symstr_buffer(11 downto 0) = sympat_sig(11 downto 0)) then
         sync_found <= '1';
    else
         sync_found <= '0';
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_valid <= sync_found or sync_valid;
    end if;
end process;

sync_valid_store <= sync_valid and not sync_detect_d;

process(intrecclk)
begin
    if(intrecclk'event and intrecclk='1') then
         sync_detect <= sync_valid_store and not sync_detect;
    end if;
end process;

process(intrecclk_d1,shift_buffer)
begin
    if(intrecclk_d1'event and intrecclk_d1='1') then
         store_buffer <= shift_buffer; 
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_detect_d <= sync_detect_d2; 
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_detect_d2 <= sync_detect_d1; 
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_detect_d1 <= sync_detect or sync_detect_d1; 
    end if;
end process;

RXD0 <= store_buffer(0) and sync_detect_d;
RXD1 <= store_buffer(1) and sync_detect_d;
RXD2 <= store_buffer(2) and sync_detect_d;
RXD3 <= store_buffer(3) and sync_detect_d;

SYDT <= sync_valid_store;
end VITAL;

configuration CFG_CDRX_SS_4_VITAL of CDRX_SS_4 is 
        for VITAL
        end for; 
end CFG_CDRX_SS_4_VITAL;
----- VITAL model for cell CDRX_SS_6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity CDRX_SS_6 is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "6";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  : string  := "0.0";
      SYMPAT   : string  := "111000111000";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tipd_CAL       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SIN       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS_CLKIN   :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      SIN               : in    STD_ULOGIC;
      CAL               : in    STD_ULOGIC;
      SS_CLKIN          : in    STD_ULOGIC;
      RXD0              : out   STD_ULOGIC;
      RXD1              : out   STD_ULOGIC;
      RXD2              : out   STD_ULOGIC;
      RXD3              : out   STD_ULOGIC;
      RXD4              : out   STD_ULOGIC;
      RXD5              : out   STD_ULOGIC;
      RECCLK            : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC;
      SYDT              : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CDRX_SS_6 : entity is FALSE;
end CDRX_SS_6;


architecture VITAL of CDRX_SS_6 is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL SS_CLKIN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL SIN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL CAL_ipd         : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL sync_valid        : std_logic := '0';
  SIGNAL sync_valid_store  : std_logic := '0';
  SIGNAL sync_found        : std_logic := '0';
  SIGNAL sync_detect       : std_logic := '0';
  SIGNAL sync_detect_d     : std_logic := '0';
  SIGNAL sync_detect_d1    : std_logic := '0';
  SIGNAL sync_detect_d2    : std_logic := '0';

  SIGNAL symstr_buffer    : std_logic_vector(11 downto 0) := (others=>'0');
  SIGNAL store_buffer     : std_logic_vector(5 downto 0) := (others=>'0');
  SIGNAL shift_buffer     : std_logic_vector(5 downto 0) := (others=>'0');

  SIGNAL sympat_sig  : std_logic_vector(11 downto 0) := str2std(sympat);

  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (SS_CLKIN_ipd, SS_CLKIN, tipd_SS_CLKIN);
   VitalWireDelay (CAL_ipd, CAL, tipd_CAL);
   VitalWireDelay (SIN_ipd, SIN, tipd_SIN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= SS_CLKIN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= SS_CLKIN_ipd;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    --ct101804 intrecclk  <= SS_CLKIN;
    RECCLK     <= intrecclk ;
    CSLOCK  <= CSLOCK_sig;

process(inthsrecclk,SS_CLKIN)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d <= SS_CLKIN;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d1 <= intrecclk_d;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d2 <= intrecclk_d1;
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
       shift_buffer(5)  <= SIN_ipd;
       shift_buffer(4)  <= shift_buffer(5);
       shift_buffer(3)  <= shift_buffer(4);
       shift_buffer(2)  <= shift_buffer(3);
       shift_buffer(1)  <= shift_buffer(2);
       shift_buffer(0)  <= shift_buffer(1);

       symstr_buffer(11) <= SIN_ipd;
       symstr_buffer(10) <= symstr_buffer(11);
       symstr_buffer(9)  <= symstr_buffer(10);
       symstr_buffer(8)  <= symstr_buffer(9);
       symstr_buffer(7)  <= symstr_buffer(8);
       symstr_buffer(6)  <= symstr_buffer(7);
       symstr_buffer(5)  <= symstr_buffer(6);
       symstr_buffer(4)  <= symstr_buffer(5);
       symstr_buffer(3)  <= symstr_buffer(4);
       symstr_buffer(2)  <= symstr_buffer(3);
       symstr_buffer(1)  <= symstr_buffer(2);
       symstr_buffer(0)  <= symstr_buffer(1);
    end if;
end process;

process(inthsrecclk, symstr_buffer)
begin
    if(symstr_buffer(11 downto 0) = sympat_sig(11 downto 0)) then
         sync_found <= '1';
    else
         sync_found <= '0';
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_valid <= sync_found or sync_valid;
    end if;
end process;

sync_valid_store <= sync_valid and not sync_detect_d;

process(intrecclk)
begin
    if(intrecclk'event and intrecclk='1') then
         sync_detect <= sync_valid_store and not sync_detect;
    end if;
end process;

process(intrecclk_d1)
begin
    if(intrecclk_d1'event and intrecclk_d1='1') then
         store_buffer <= shift_buffer; 
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_detect_d <= sync_detect_d2; 
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_detect_d2 <= sync_detect_d1; 
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_detect_d1 <= sync_detect or sync_detect_d1; 
    end if;
end process;

RXD0 <= store_buffer(0) and sync_detect_d;
RXD1 <= store_buffer(1) and sync_detect_d;
RXD2 <= store_buffer(2) and sync_detect_d;
RXD3 <= store_buffer(3) and sync_detect_d;
RXD4 <= store_buffer(4) and sync_detect_d;
RXD5 <= store_buffer(5) and sync_detect_d;

SYDT <= sync_valid_store;
end VITAL;

configuration CFG_CDRX_SS_6_VITAL of CDRX_SS_6 is 
        for VITAL
        end for; 
end CFG_CDRX_SS_6_VITAL;
----- VITAL model for cell CDRX_SS_8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity CDRX_SS_8 is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "8";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  : string  := "0.0";
      SYMPAT   : string  := "000011110000";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tipd_CAL       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SIN       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS_CLKIN   :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      SIN               : in    STD_ULOGIC;
      CAL               : in    STD_ULOGIC;
      SS_CLKIN          : in    STD_ULOGIC;
      RXD0              : out   STD_ULOGIC;
      RXD1              : out   STD_ULOGIC;
      RXD2              : out   STD_ULOGIC;
      RXD3              : out   STD_ULOGIC;
      RXD4              : out   STD_ULOGIC;
      RXD5              : out   STD_ULOGIC;
      RXD6              : out   STD_ULOGIC;
      RXD7              : out   STD_ULOGIC;
      RECCLK            : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC;
      SYDT              : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CDRX_SS_8 : entity is FALSE;
end CDRX_SS_8;


architecture VITAL of CDRX_SS_8 is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL SS_CLKIN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL SIN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL CAL_ipd         : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL sync_valid        : std_logic := '0';
  SIGNAL sync_valid_store  : std_logic := '0';
  SIGNAL sync_found        : std_logic := '0';
  SIGNAL sync_detect       : std_logic := '0';
  SIGNAL sync_detect_d     : std_logic := '0';
  SIGNAL sync_detect_d1    : std_logic := '0';
  SIGNAL sync_detect_d2    : std_logic := '0';

  SIGNAL symstr_buffer    : std_logic_vector(11 downto 0) := (others=>'0');
  SIGNAL store_buffer     : std_logic_vector(7 downto 0) := (others=>'0');
  SIGNAL shift_buffer     : std_logic_vector(7 downto 0) := (others=>'0');

  SIGNAL sympat_sig  : std_logic_vector(11 downto 0) := str2std(sympat);

  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (SS_CLKIN_ipd, SS_CLKIN, tipd_SS_CLKIN);
   VitalWireDelay (CAL_ipd, CAL, tipd_CAL);
   VitalWireDelay (SIN_ipd, SIN, tipd_SIN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= SS_CLKIN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= SS_CLKIN_ipd;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    --ct101404 intrecclk  <= SS_CLKIN;
    RECCLK     <= intrecclk ;
    CSLOCK  <= CSLOCK_sig;

process(inthsrecclk,SS_CLKIN)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d <= SS_CLKIN;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d1 <= intrecclk_d;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d2 <= intrecclk_d1;
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
       shift_buffer(7)  <= SIN_ipd;
       shift_buffer(6)  <= shift_buffer(7);
       shift_buffer(5)  <= shift_buffer(6);
       shift_buffer(4)  <= shift_buffer(5);
       shift_buffer(3)  <= shift_buffer(4);
       shift_buffer(2)  <= shift_buffer(3);
       shift_buffer(1)  <= shift_buffer(2);
       shift_buffer(0)  <= shift_buffer(1);

       symstr_buffer(11) <= SIN_ipd;
       symstr_buffer(10) <= symstr_buffer(11);
       symstr_buffer(9)  <= symstr_buffer(10);
       symstr_buffer(8)  <= symstr_buffer(9);
       symstr_buffer(7)  <= symstr_buffer(8);
       symstr_buffer(6)  <= symstr_buffer(7);
       symstr_buffer(5)  <= symstr_buffer(6);
       symstr_buffer(4)  <= symstr_buffer(5);
       symstr_buffer(3)  <= symstr_buffer(4);
       symstr_buffer(2)  <= symstr_buffer(3);
       symstr_buffer(1)  <= symstr_buffer(2);
       symstr_buffer(0)  <= symstr_buffer(1);
    end if;
end process;

process(inthsrecclk, symstr_buffer)
begin
    if(symstr_buffer(11 downto 0) = sympat_sig(11 downto 0)) then
         sync_found <= '1';
    else
         sync_found <= '0';
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_valid <= sync_found or sync_valid;
    end if;
end process;

sync_valid_store <= sync_valid and not sync_detect_d;

process(intrecclk)
begin
    if(intrecclk'event and intrecclk='1') then
         sync_detect <= sync_valid_store and not sync_detect;
    end if;
end process;

process(intrecclk_d1)
begin
    if(intrecclk_d1'event and intrecclk_d1='1') then
         store_buffer <= shift_buffer; 
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_detect_d <= sync_detect_d2; 
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_detect_d2 <= sync_detect_d1; 
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_detect_d1 <= sync_detect or sync_detect_d1; 
    end if;
end process;

RXD0 <= store_buffer(0) and sync_detect_d;
RXD1 <= store_buffer(1) and sync_detect_d;
RXD2 <= store_buffer(2) and sync_detect_d;
RXD3 <= store_buffer(3) and sync_detect_d;
RXD4 <= store_buffer(4) and sync_detect_d;
RXD5 <= store_buffer(5) and sync_detect_d;
RXD6 <= store_buffer(6) and sync_detect_d;
RXD7 <= store_buffer(7) and sync_detect_d;

SYDT <= sync_valid_store;
end VITAL;

configuration CFG_CDRX_SS_8_VITAL of CDRX_SS_8 is 
        for VITAL
        end for; 
end CFG_CDRX_SS_8_VITAL;

----- VITAL model for cell CDRX_SS_10 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity CDRX_SS_10 is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "10";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  : string  := "0.0";
      SYMPAT   : string  := "000011110000";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tipd_CAL       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SIN       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS_CLKIN   :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      SIN               : in    STD_ULOGIC;
      CAL               : in    STD_ULOGIC;
      SS_CLKIN          : in    STD_ULOGIC;
      RXD0              : out   STD_ULOGIC;
      RXD1              : out   STD_ULOGIC;
      RXD2              : out   STD_ULOGIC;
      RXD3              : out   STD_ULOGIC;
      RXD4              : out   STD_ULOGIC;
      RXD5              : out   STD_ULOGIC;
      RXD6              : out   STD_ULOGIC;
      RXD7              : out   STD_ULOGIC;
      RXD8              : out   STD_ULOGIC;
      RXD9              : out   STD_ULOGIC;
      RECCLK            : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC;
      SYDT              : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CDRX_SS_10 : entity is FALSE;
end CDRX_SS_10;


architecture VITAL of CDRX_SS_10 is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL SS_CLKIN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL SIN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL CAL_ipd         : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL sync_valid        : std_logic := '0';
  SIGNAL sync_valid_store  : std_logic := '0';
  SIGNAL sync_found        : std_logic := '0';
  SIGNAL sync_detect       : std_logic := '0';
  SIGNAL sync_detect_d     : std_logic := '0';
  SIGNAL sync_detect_d1    : std_logic := '0';
  SIGNAL sync_detect_d2    : std_logic := '0';

  SIGNAL symstr_buffer    : std_logic_vector(11 downto 0) := (others=>'0');
  SIGNAL store_buffer     : std_logic_vector(9 downto 0) := (others=>'0');
  SIGNAL shift_buffer     : std_logic_vector(9 downto 0) := (others=>'0');

  SIGNAL sympat_sig  : std_logic_vector(11 downto 0) := str2std(sympat);

  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (SS_CLKIN_ipd, SS_CLKIN, tipd_SS_CLKIN);
   VitalWireDelay (CAL_ipd, CAL, tipd_CAL);
   VitalWireDelay (SIN_ipd, SIN, tipd_SIN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= SS_CLKIN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= SS_CLKIN_ipd;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    --ct101804 intrecclk  <= SS_CLKIN;
    RECCLK     <= intrecclk ;
    CSLOCK  <= CSLOCK_sig;

process(inthsrecclk,SS_CLKIN)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d <= SS_CLKIN;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d1 <= intrecclk_d;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d2 <= intrecclk_d1;
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
       shift_buffer(9)  <= SIN_ipd;
       shift_buffer(8)  <= shift_buffer(9);
       shift_buffer(7)  <= shift_buffer(8);
       shift_buffer(6)  <= shift_buffer(7);
       shift_buffer(5)  <= shift_buffer(6);
       shift_buffer(4)  <= shift_buffer(5);
       shift_buffer(3)  <= shift_buffer(4);
       shift_buffer(2)  <= shift_buffer(3);
       shift_buffer(1)  <= shift_buffer(2);
       shift_buffer(0)  <= shift_buffer(1);

       symstr_buffer(11) <= SIN_ipd;
       symstr_buffer(10) <= symstr_buffer(11);
       symstr_buffer(9)  <= symstr_buffer(10);
       symstr_buffer(8)  <= symstr_buffer(9);
       symstr_buffer(7)  <= symstr_buffer(8);
       symstr_buffer(6)  <= symstr_buffer(7);
       symstr_buffer(5)  <= symstr_buffer(6);
       symstr_buffer(4)  <= symstr_buffer(5);
       symstr_buffer(3)  <= symstr_buffer(4);
       symstr_buffer(2)  <= symstr_buffer(3);
       symstr_buffer(1)  <= symstr_buffer(2);
       symstr_buffer(0)  <= symstr_buffer(1);
    end if;
end process;

process(inthsrecclk, symstr_buffer)
begin
    if(symstr_buffer(11 downto 0) = sympat_sig(11 downto 0)) then
         sync_found <= '1';
    else
         sync_found <= '0';
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_valid <= sync_found or sync_valid;
    end if;
end process;

sync_valid_store <= sync_valid and not sync_detect_d;

process(intrecclk)
begin
    if(intrecclk'event and intrecclk='1') then
         sync_detect <= sync_valid_store and not sync_detect;
    end if;
end process;

process(intrecclk_d1)
begin
    if(intrecclk_d1'event and intrecclk_d1='1') then
         store_buffer <= shift_buffer; 
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_detect_d <= sync_detect_d2; 
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_detect_d2 <= sync_detect_d1; 
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
         sync_detect_d1 <= sync_detect or sync_detect_d1; 
    end if;
end process;

RXD0 <= store_buffer(0) and sync_detect_d;
RXD1 <= store_buffer(1) and sync_detect_d;
RXD2 <= store_buffer(2) and sync_detect_d;
RXD3 <= store_buffer(3) and sync_detect_d;
RXD4 <= store_buffer(4) and sync_detect_d;
RXD5 <= store_buffer(5) and sync_detect_d;
RXD6 <= store_buffer(6) and sync_detect_d;
RXD7 <= store_buffer(7) and sync_detect_d;
RXD8 <= store_buffer(8) and sync_detect_d;
RXD9 <= store_buffer(9) and sync_detect_d;

SYDT <= sync_valid_store;
end VITAL;

configuration CFG_CDRX_SS_10_VITAL of CDRX_SS_10 is 
        for VITAL
        end for; 
end CFG_CDRX_SS_10_VITAL;

----- VITAL model for cell HSLB_10B12B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity HSLB_10B12B is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "12";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  : string  := "1";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tipd_REFCLK    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CDRRST    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD0      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD1      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD2      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD3      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD4      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD5      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD6      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD7      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD8      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD9      :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      REFCLK            : in    STD_ULOGIC;
      CDRRST            : in    STD_ULOGIC;
      TXD0              : in    STD_ULOGIC;
      TXD1              : in    STD_ULOGIC;
      TXD2              : in    STD_ULOGIC;
      TXD3              : in    STD_ULOGIC;
      TXD4              : in    STD_ULOGIC;
      TXD5              : in    STD_ULOGIC;
      TXD6              : in    STD_ULOGIC;
      TXD7              : in    STD_ULOGIC;
      TXD8              : in    STD_ULOGIC;
      TXD9              : in    STD_ULOGIC;
      RXD0              : out   STD_ULOGIC;
      RXD1              : out   STD_ULOGIC;
      RXD2              : out   STD_ULOGIC;
      RXD3              : out   STD_ULOGIC;
      RXD4              : out   STD_ULOGIC;
      RXD5              : out   STD_ULOGIC;
      RXD6              : out   STD_ULOGIC;
      RXD7              : out   STD_ULOGIC;
      RXD8              : out   STD_ULOGIC;
      RXD9              : out   STD_ULOGIC;
      RECCLK            : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of HSLB_10B12B : entity is FALSE;
end HSLB_10B12B;


architecture VITAL of HSLB_10B12B is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL REFCLK_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL sec_clk : STD_LOGIC ;
  SIGNAL sec_clk_count : INTEGER := 0 ;
  SIGNAL sec_out_sig : std_logic := '0' ;

  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (REFCLK_ipd, REFCLK, tipd_REFCLK);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= REFCLK_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= REFCLK_ipd;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    RECCLK  <= inthsrecclk;
    CSLOCK  <= CSLOCK_sig;

end VITAL;

configuration CFG_HSLB_10B12B_VITAL of HSLB_10B12B is 
        for VITAL
        end for; 
end CFG_HSLB_10B12B_VITAL;
----- VITAL model for cell HSLB_8B10B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity HSLB_8B10B is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "10";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  : string  := "1";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tipd_REFCLK    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CDRRST    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD0      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD1      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD2      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD3      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD4      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD5      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD6      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD7      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD8      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD9      :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      REFCLK            : in    STD_ULOGIC;
      CDRRST            : in    STD_ULOGIC;
      TXD0              : in    STD_ULOGIC;
      TXD1              : in    STD_ULOGIC;
      TXD2              : in    STD_ULOGIC;
      TXD3              : in    STD_ULOGIC;
      TXD4              : in    STD_ULOGIC;
      TXD5              : in    STD_ULOGIC;
      TXD6              : in    STD_ULOGIC;
      TXD7              : in    STD_ULOGIC;
      TXD8              : in    STD_ULOGIC;
      TXD9              : in    STD_ULOGIC;
      RXD0              : out   STD_ULOGIC;
      RXD1              : out   STD_ULOGIC;
      RXD2              : out   STD_ULOGIC;
      RXD3              : out   STD_ULOGIC;
      RXD4              : out   STD_ULOGIC;
      RXD5              : out   STD_ULOGIC;
      RXD6              : out   STD_ULOGIC;
      RXD7              : out   STD_ULOGIC;
      RXD8              : out   STD_ULOGIC;
      RXD9              : out   STD_ULOGIC;
      RECCLK            : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of HSLB_8B10B : entity is FALSE;
end HSLB_8B10B;


architecture VITAL of HSLB_8B10B is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL REFCLK_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL sec_clk : STD_LOGIC ;
  SIGNAL sec_clk_count : INTEGER := 0 ;
  SIGNAL sec_out_sig : std_logic := '0' ;

  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (REFCLK_ipd, REFCLK, tipd_REFCLK);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= REFCLK_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= REFCLK_ipd;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    RECCLK  <= inthsrecclk;
    CSLOCK  <= CSLOCK_sig;

end VITAL;

configuration CFG_HSLB_8B10B_VITAL of HSLB_8B10B is 
        for VITAL
        end for; 
end CFG_HSLB_8B10B_VITAL;
----- VITAL model for cell RX_SS_4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity RX_SS_4 is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "4";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PHASE_ADJ  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tipd_SIN       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS_CLKIN   :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      SIN               : in    STD_ULOGIC;
      SS_CLKIN          : in    STD_ULOGIC;
      RXD0              : out   STD_ULOGIC;
      RXD1              : out   STD_ULOGIC;
      RXD2              : out   STD_ULOGIC;
      RXD3              : out   STD_ULOGIC;
      RECCLK            : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of RX_SS_4 : entity is FALSE;
end RX_SS_4;


architecture VITAL of RX_SS_4 is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL SS_CLKIN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL SIN_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL store_buffer     : std_logic_vector(3 downto 0) := (others=>'0');
  SIGNAL shift_buffer     : std_logic_vector(3 downto 0) := (others=>'0');

  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(PHASE_ADJ);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (SS_CLKIN_ipd, SS_CLKIN, tipd_SS_CLKIN);
   VitalWireDelay (SIN_ipd, SIN, tipd_SIN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= SS_CLKIN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= SS_CLKIN_ipd;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    RECCLK  <= intrecclk_d1;
    CSLOCK  <= CSLOCK_sig;

process(inthsrecclk,SS_CLKIN)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d <= SS_CLKIn;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d1 <= intrecclk_d;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d2 <= intrecclk_d1;
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
       shift_buffer(3)  <= SIN_ipd;
       shift_buffer(2)  <= shift_buffer(3);
       shift_buffer(1)  <= shift_buffer(2);
       shift_buffer(0)  <= shift_buffer(1);
    end if;
end process;

process(intrecclk_d1)
begin
    if(intrecclk_d1'event and intrecclk_d1='1') then
         store_buffer <= shift_buffer; 
    end if;
end process;

RXD0 <= store_buffer(0);
RXD1 <= store_buffer(1);
RXD2 <= store_buffer(2);
RXD3 <= store_buffer(3);

end VITAL;

configuration CFG_RX_SS_4_VITAL of RX_SS_4 is 
        for VITAL
        end for; 
end CFG_RX_SS_4_VITAL;
----- VITAL model for cell RX_SS_6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity RX_SS_6 is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "6";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PHASE_ADJ  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tipd_CAL       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SIN       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS_CLKIN   :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      SIN               : in    STD_ULOGIC;
      SS_CLKIN          : in    STD_ULOGIC;
      RXD0              : out   STD_ULOGIC;
      RXD1              : out   STD_ULOGIC;
      RXD2              : out   STD_ULOGIC;
      RXD3              : out   STD_ULOGIC;
      RXD4              : out   STD_ULOGIC;
      RXD5              : out   STD_ULOGIC;
      RECCLK            : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of RX_SS_6 : entity is FALSE;
end RX_SS_6;

architecture VITAL of RX_SS_6 is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL SS_CLKIN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL SIN_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL store_buffer     : std_logic_vector(5 downto 0) := (others=>'0');
  SIGNAL shift_buffer     : std_logic_vector(5 downto 0) := (others=>'0');

  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(PHASE_ADJ);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (SS_CLKIN_ipd, SS_CLKIN, tipd_SS_CLKIN);
   VitalWireDelay (SIN_ipd, SIN, tipd_SIN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= SS_CLKIN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= SS_CLKIN_ipd;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    RECCLK  <= intrecclk_d1;
    CSLOCK  <= CSLOCK_sig;

process(inthsrecclk,SS_CLKIN)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d <= SS_CLKIn;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d1 <= intrecclk_d;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d2 <= intrecclk_d1;
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
       shift_buffer(5)  <= SIN_ipd;
       shift_buffer(4)  <= shift_buffer(5);
       shift_buffer(3)  <= shift_buffer(4);
       shift_buffer(2)  <= shift_buffer(3);
       shift_buffer(1)  <= shift_buffer(2);
       shift_buffer(0)  <= shift_buffer(1);
    end if;
end process;

process(intrecclk_d1)
begin
    if(intrecclk_d1'event and intrecclk_d1='1') then
         store_buffer <= shift_buffer; 
    end if;
end process;

RXD0 <= store_buffer(0);
RXD1 <= store_buffer(1);
RXD2 <= store_buffer(2);
RXD3 <= store_buffer(3);
RXD4 <= store_buffer(4);
RXD5 <= store_buffer(5);

end VITAL;

configuration CFG_RX_SS_6_VITAL of RX_SS_6 is 
        for VITAL
        end for; 
end CFG_RX_SS_6_VITAL;
----- VITAL model for cell RX_SS_8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity RX_SS_8 is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "8";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PHASE_ADJ  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tipd_SIN       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS_CLKIN   :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      SIN               : in    STD_ULOGIC;
      SS_CLKIN          : in    STD_ULOGIC;
      RXD0              : out   STD_ULOGIC;
      RXD1              : out   STD_ULOGIC;
      RXD2              : out   STD_ULOGIC;
      RXD3              : out   STD_ULOGIC;
      RXD4              : out   STD_ULOGIC;
      RXD5              : out   STD_ULOGIC;
      RXD6              : out   STD_ULOGIC;
      RXD7              : out   STD_ULOGIC;
      RECCLK            : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of RX_SS_8 : entity is FALSE;
end RX_SS_8;

architecture VITAL of RX_SS_8 is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL SS_CLKIN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL SIN_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL store_buffer     : std_logic_vector(7 downto 0) := (others=>'0');
  SIGNAL shift_buffer     : std_logic_vector(7 downto 0) := (others=>'0');

  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(PHASE_ADJ);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (SS_CLKIN_ipd, SS_CLKIN, tipd_SS_CLKIN);
   VitalWireDelay (SIN_ipd, SIN, tipd_SIN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= SS_CLKIN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (SS_CLKIN_ipd'EVENT AND SS_CLKIN_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= SS_CLKIN_ipd;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    RECCLK  <= intrecclk_d1;
    CSLOCK  <= CSLOCK_sig;


process(inthsrecclk,SS_CLKIN)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d <= SS_CLKIn;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d1 <= intrecclk_d;
    end if;
end process;

process(inthsrecclk,intrecclk_d1)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
        intrecclk_d2 <= intrecclk_d1;
    end if;
end process;

process(inthsrecclk)
begin
    if(inthsrecclk'event and inthsrecclk='1') then
       shift_buffer(7)  <= SIN_ipd;
       shift_buffer(6)  <= shift_buffer(7);
       shift_buffer(5)  <= shift_buffer(6);
       shift_buffer(4)  <= shift_buffer(5);
       shift_buffer(3)  <= shift_buffer(4);
       shift_buffer(2)  <= shift_buffer(3);
       shift_buffer(1)  <= shift_buffer(2);
       shift_buffer(0)  <= shift_buffer(1);
    end if;
end process;

process(intrecclk_d1)
begin
    if(intrecclk_d1'event and intrecclk_d1='1') then
         store_buffer <= shift_buffer; 
    end if;
end process;

RXD0 <= store_buffer(0);
RXD1 <= store_buffer(1);
RXD2 <= store_buffer(2);
RXD3 <= store_buffer(3);
RXD4 <= store_buffer(4);
RXD5 <= store_buffer(5);
RXD6 <= store_buffer(6);
RXD7 <= store_buffer(7);

end VITAL;

configuration CFG_RX_SS_8_VITAL of RX_SS_8 is 
        for VITAL
        end for; 
end CFG_RX_SS_8_VITAL;

----- VITAL model for cell TX_10B12B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_unsigned.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity TX_10B12B is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "12";
      DIV      : string  := "1";
      PLL_DLY  : string  := "0.0";
      LOCK_CYC : integer := 2;
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tsetup_TXD0_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD0_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD1_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD1_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD2_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD2_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD3_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD3_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD4_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD4_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD5_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD5_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD6_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD6_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD7_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD7_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD8_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD8_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD9_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD9_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tipd_REFCLK    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD0      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD1      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD2      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD3      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD4      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD5      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD6      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD7      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD8      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD9      :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      REFCLK            : in    STD_ULOGIC;
      TXD0              : in    STD_ULOGIC;
      TXD1              : in    STD_ULOGIC;
      TXD2              : in    STD_ULOGIC;
      TXD3              : in    STD_ULOGIC;
      TXD4              : in    STD_ULOGIC;
      TXD5              : in    STD_ULOGIC;
      TXD6              : in    STD_ULOGIC;
      TXD7              : in    STD_ULOGIC;
      TXD8              : in    STD_ULOGIC;
      TXD9              : in    STD_ULOGIC;
      SOUT              : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TX_10B12B : entity is FALSE;
end TX_10B12B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library GDX2;
architecture VITAL of TX_10B12B is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL REFCLK_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD0_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD1_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD2_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD3_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD4_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD5_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD6_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD7_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD8_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD9_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL refclk_half_period : TIME :=100 ns;
  SIGNAL refclk_half_period1 : TIME :=100 ns;
  SIGNAL refclk_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;

  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL data_out       : std_logic_vector(11 downto 0) := (others => '0');
  SIGNAL shift_buffer   : std_logic_vector(11 downto 0) := (others => '0');
  SIGNAL cnt            : std_logic_vector(3 downto 0) := (others => '0');

  CONSTANT clockboost: integer := str2int(mult) / str2int(div);
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

  SIGNAL SOUT_int       : std_logic := '0';

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (REFCLK_ipd, REFCLK, tipd_REFCLK);
   VitalWireDelay (TXD0_ipd, TXD0, tipd_TXD0);
   VitalWireDelay (TXD1_ipd, TXD1, tipd_TXD1);
   VitalWireDelay (TXD2_ipd, TXD2, tipd_TXD2);
   VitalWireDelay (TXD3_ipd, TXD3, tipd_TXD3);
   VitalWireDelay (TXD4_ipd, TXD4, tipd_TXD4);
   VitalWireDelay (TXD5_ipd, TXD5, tipd_TXD5);
   VitalWireDelay (TXD6_ipd, TXD6, tipd_TXD6);
   VitalWireDelay (TXD7_ipd, TXD7, tipd_TXD7);
   VitalWireDelay (TXD8_ipd, TXD8, tipd_TXD8);
   VitalWireDelay (TXD9_ipd, TXD9, tipd_TXD9);
   end block;

   VITALBehavior : process

        variable Tviol_TXD0_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD1_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD2_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD3_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD4_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD5_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD6_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD7_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD8_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD9_REFCLK_posedge     : std_ulogic  := '0';
        variable Tmkr_TXD0_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD1_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD2_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD3_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD4_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD5_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD6_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD7_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD8_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD9_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Violation                    : std_ulogic := '0';

   begin

        if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD0_REFCLK_posedge,
          TimingData              => Tmkr_TXD0_REFCLK_posedge,
          TestSignal              => TXD0_ipd,
          TestSignalName          => "TXD0",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD0_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD0_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD0_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD0_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_10B12B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD1_REFCLK_posedge,
          TimingData              => Tmkr_TXD1_REFCLK_posedge,
          TestSignal              => TXD1_ipd,
          TestSignalName          => "TXD1",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD1_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD1_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD1_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD1_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_10B12B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD2_REFCLK_posedge,
          TimingData              => Tmkr_TXD2_REFCLK_posedge,
          TestSignal              => TXD2_ipd,
          TestSignalName          => "TXD2",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD2_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD2_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD2_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD2_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_10B12B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD3_REFCLK_posedge,
          TimingData              => Tmkr_TXD3_REFCLK_posedge,
          TestSignal              => TXD3_ipd,
          TestSignalName          => "TXD3",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD3_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD3_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD3_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD3_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_10B12B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD4_REFCLK_posedge,
          TimingData              => Tmkr_TXD4_REFCLK_posedge,
          TestSignal              => TXD4_ipd,
          TestSignalName          => "TXD4",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD4_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD4_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD4_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD4_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_10B12B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD5_REFCLK_posedge,
          TimingData              => Tmkr_TXD5_REFCLK_posedge,
          TestSignal              => TXD5_ipd,
          TestSignalName          => "TXD5",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD5_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD5_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD5_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD5_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_10B12B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD6_REFCLK_posedge,
          TimingData              => Tmkr_TXD6_REFCLK_posedge,
          TestSignal              => TXD6_ipd,
          TestSignalName          => "TXD6",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD6_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD6_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD6_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD6_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_10B12B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD7_REFCLK_posedge,
          TimingData              => Tmkr_TXD7_REFCLK_posedge,
          TestSignal              => TXD7_ipd,
          TestSignalName          => "TXD7",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD7_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD7_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD7_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD7_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_10B12B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD8_REFCLK_posedge,
          TimingData              => Tmkr_TXD8_REFCLK_posedge,
          TestSignal              => TXD8_ipd,
          TestSignalName          => "TXD8",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD8_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD8_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD8_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD8_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_10B12B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD9_REFCLK_posedge,
          TimingData              => Tmkr_TXD9_REFCLK_posedge,
          TestSignal              => TXD9_ipd,
          TestSignalName          => "TXD9",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD9_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD9_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD9_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD9_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_10B12B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

    Violation := Tviol_TXD0_REFCLK_posedge or Tviol_TXD1_REFCLK_posedge or 
                 Tviol_TXD2_REFCLK_posedge or Tviol_TXD3_REFCLK_posedge or 
                 Tviol_TXD4_REFCLK_posedge or Tviol_TXD5_REFCLK_posedge or 
                 Tviol_TXD6_REFCLK_posedge or Tviol_TXD7_REFCLK_posedge or 
                 Tviol_TXD8_REFCLK_posedge or Tviol_TXD9_REFCLK_posedge ;

    wait on REFCLK_ipd, TXD0_ipd, TXD1_ipd, TXD2_ipd, TXD3_ipd, TXD4_ipd, TXD5_ipd, TXD6_ipd, TXD7_ipd, TXD8_ipd, TXD9_ipd;
  end process VITALBehavior;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

       clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;
       refclk_half_period <= (refclk_half_period0 + refclk_half_period1)/2;

  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= REFCLK_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       refclk_half_period0 <= (NOW - clklock_last_falling_edge);
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)* str2int(div)/str2int(mult);
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     elsif clklock_rising_edge_count = 2 THEN
       clklock_half_period_minus_dly0 <= (NOW - clklock_last_falling_edge) + tpd;
       --clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;
     END IF;
     END IF;
 
  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	refclk_half_period1 <= (NOW - clklock_last_rising_edge); 
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)* str2int(div)/str2int(mult); 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= (NOW - clklock_last_rising_edge) + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc + 1 THEN
         if(clockboost >1) then
	   FOR i IN 1 TO (2*clockboost) LOOP      
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

process
begin
    wait until CLK_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
   END LOOP;
end process;

process
begin
   wait until (clklock_falling_edge_count >= lock_cyc + 1);
    wait for clklock_half_period_minus_dly0;
   CLK_OUT_start <= '1';
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;


    intrecclk <= REFCLK_ipd;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    CSLOCK  <= CSLOCK_sig;

process (inthsrecclk)
begin
        if(inthsrecclk'event and inthsrecclk = '1') then
           if cnt = "1100" then
              cnt <= "0001";
            else
              cnt <= cnt + "0001";
           end if; 
        end if;
end process;


data_out(0)  <= '1' when cnt = "1100" else shift_buffer(1) ;
data_out(1)  <= TXD0_ipd when cnt = "1100" else shift_buffer(2) ;
data_out(2)  <= TXD1_ipd when cnt = "1100" else shift_buffer(3) ;
data_out(3)  <= TXD2_ipd when cnt = "1100" else shift_buffer(4) ;
data_out(4)  <= TXD3_ipd when cnt = "1100" else shift_buffer(5) ;
data_out(5)  <= TXD4_ipd when cnt = "1100" else shift_buffer(6) ;
data_out(6)  <= TXD5_ipd when cnt = "1100" else shift_buffer(7) ;
data_out(7)  <= TXD6_ipd when cnt = "1100" else shift_buffer(8) ;
data_out(8)  <= TXD7_ipd when cnt = "1100" else shift_buffer(9) ;
data_out(9)  <= TXD8_ipd when cnt = "1100" else shift_buffer(10);
data_out(10)  <= TXD9_ipd when cnt = "1100" else shift_buffer(11);
data_out(11)  <= '0' when cnt = "1100" else shift_buffer(0);

process (inthsrecclk,data_out)
begin
        if(inthsrecclk'event and inthsrecclk='1') then
          SOUT_int         <= data_out(0);
          shift_buffer(1)  <= data_out(1);
          shift_buffer(2)  <= data_out(2);
          shift_buffer(3)  <= data_out(3);
          shift_buffer(4)  <= data_out(4);
          shift_buffer(5)  <= data_out(5);
          shift_buffer(6)  <= data_out(6);
          shift_buffer(7)  <= data_out(7);
          shift_buffer(8)  <= data_out(8);
          shift_buffer(9)  <= data_out(9);
          shift_buffer(10)  <= data_out(10);
          shift_buffer(11)  <= data_out(11);
        end if;
end process;

SOUT <= SOUT_int after refclk_half_period*2*str2int(div)/str2int(mult);

end VITAL;

configuration CFG_TX_10B12B_VITAL of TX_10B12B is 
        for VITAL
        end for; 
end CFG_TX_10B12B_VITAL;

----- VITAL model for cell TX_8B10B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity TX_8B10B is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "10";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tsetup_TXD0_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD0_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD1_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD1_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD2_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD2_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD3_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD3_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD4_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD4_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD5_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD5_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD6_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD6_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD7_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD7_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD8_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD8_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD9_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD9_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tipd_REFCLK    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD0      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD1      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD2      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD3      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD4      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD5      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD6      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD7      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD8      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD9      :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      REFCLK            : in    STD_ULOGIC;
      TXD0              : in    STD_ULOGIC;
      TXD1              : in    STD_ULOGIC;
      TXD2              : in    STD_ULOGIC;
      TXD3              : in    STD_ULOGIC;
      TXD4              : in    STD_ULOGIC;
      TXD5              : in    STD_ULOGIC;
      TXD6              : in    STD_ULOGIC;
      TXD7              : in    STD_ULOGIC;
      TXD8              : in    STD_ULOGIC;
      TXD9              : in    STD_ULOGIC;
      SOUT              : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TX_8B10B : entity is FALSE;
end TX_8B10B;


architecture VITAL of TX_8B10B is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL REFCLK_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD0_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD1_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD2_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD3_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD4_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD5_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD6_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD7_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD8_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD9_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL refclk_half_period : TIME :=100 ns;
  SIGNAL refclk_half_period1 : TIME :=100 ns;
  SIGNAL refclk_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;

  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';


  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL data_out       : std_logic_vector(9 downto 0) := (others => '0');
  SIGNAL shift_buffer   : std_logic_vector(9 downto 0) := (others => '0');
  SIGNAL cnt            : std_logic_vector(3 downto 0) := (others => '0');

  CONSTANT clockboost: integer := str2int(mult) / str2int(div);
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

  SIGNAL SOUT_int, SOUT_int1       : std_logic := '0';

BEGIN

   WireDelay : block
   begin
     VitalWireDelay (REFCLK_ipd, REFCLK, tipd_REFCLK);
     VitalWireDelay (TXD0_ipd, TXD0, tipd_TXD0);
     VitalWireDelay (TXD1_ipd, TXD1, tipd_TXD1);
     VitalWireDelay (TXD2_ipd, TXD2, tipd_TXD2);
     VitalWireDelay (TXD3_ipd, TXD3, tipd_TXD3);
     VitalWireDelay (TXD4_ipd, TXD4, tipd_TXD4);
     VitalWireDelay (TXD5_ipd, TXD5, tipd_TXD5);
     VitalWireDelay (TXD6_ipd, TXD6, tipd_TXD6);
     VitalWireDelay (TXD7_ipd, TXD7, tipd_TXD7);
     VitalWireDelay (TXD8_ipd, TXD8, tipd_TXD8);
     VitalWireDelay (TXD9_ipd, TXD9, tipd_TXD9);
   end block;

  VITALBehavior : process

        variable Tviol_TXD0_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD1_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD2_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD3_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD4_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD5_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD6_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD7_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD8_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD9_REFCLK_posedge     : std_ulogic  := '0';
        variable Tmkr_TXD0_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD1_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD2_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD3_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD4_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD5_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD6_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD7_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD8_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD9_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Violation                    : std_ulogic  := '0';
     begin
       if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD0_REFCLK_posedge,
          TimingData              => Tmkr_TXD0_REFCLK_posedge,
          TestSignal              => TXD0_ipd,
          TestSignalName          => "TXD0",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD0_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD0_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD0_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD0_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_8B10B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD1_REFCLK_posedge,
          TimingData              => Tmkr_TXD1_REFCLK_posedge,
          TestSignal              => TXD1_ipd,
          TestSignalName          => "TXD1",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD1_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD1_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD1_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD1_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_8B10B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD2_REFCLK_posedge,
          TimingData              => Tmkr_TXD2_REFCLK_posedge,
          TestSignal              => TXD2_ipd,
          TestSignalName          => "TXD2",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD2_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD2_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD2_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD2_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_8B10B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD3_REFCLK_posedge,
          TimingData              => Tmkr_TXD3_REFCLK_posedge,
          TestSignal              => TXD3_ipd,
          TestSignalName          => "TXD3",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD3_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD3_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD3_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD3_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_8B10B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD4_REFCLK_posedge,
          TimingData              => Tmkr_TXD4_REFCLK_posedge,
          TestSignal              => TXD4_ipd,
          TestSignalName          => "TXD4",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD4_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD4_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD4_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD4_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_8B10B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD5_REFCLK_posedge,
          TimingData              => Tmkr_TXD5_REFCLK_posedge,
          TestSignal              => TXD5_ipd,
          TestSignalName          => "TXD5",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD5_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD5_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD5_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD5_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_8B10B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD6_REFCLK_posedge,
          TimingData              => Tmkr_TXD6_REFCLK_posedge,
          TestSignal              => TXD6_ipd,
          TestSignalName          => "TXD6",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD6_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD6_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD6_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD6_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_8B10B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD7_REFCLK_posedge,
          TimingData              => Tmkr_TXD7_REFCLK_posedge,
          TestSignal              => TXD7_ipd,
          TestSignalName          => "TXD7",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD7_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD7_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD7_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD7_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_8B10B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD8_REFCLK_posedge,
          TimingData              => Tmkr_TXD8_REFCLK_posedge,
          TestSignal              => TXD8_ipd,
          TestSignalName          => "TXD8",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD8_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD8_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD8_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD8_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_8B10B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD9_REFCLK_posedge,
          TimingData              => Tmkr_TXD9_REFCLK_posedge,
          TestSignal              => TXD9_ipd,
          TestSignalName          => "TXD9",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD9_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD9_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD9_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD9_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_8B10B",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
       end if;

    Violation := Tviol_TXD0_REFCLK_posedge or Tviol_TXD1_REFCLK_posedge or 
                 Tviol_TXD2_REFCLK_posedge or Tviol_TXD3_REFCLK_posedge or 
                 Tviol_TXD4_REFCLK_posedge or Tviol_TXD5_REFCLK_posedge or 
                 Tviol_TXD6_REFCLK_posedge or Tviol_TXD7_REFCLK_posedge or 
                 Tviol_TXD8_REFCLK_posedge or Tviol_TXD9_REFCLK_posedge ;

    wait on REFCLK_ipd, TXD0_ipd, TXD1_ipd, TXD2_ipd, TXD3_ipd, TXD4_ipd, TXD5_ipd, TXD6_ipd, TXD7_ipd, TXD8_ipd, TXD9_ipd;
  end process VITALBehavior;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

       clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;
       refclk_half_period <= (refclk_half_period0 + refclk_half_period1)/2;

  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= REFCLK_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       refclk_half_period0 <= (NOW - clklock_last_falling_edge);
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)* str2int(div)/str2int(mult);
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     elsif clklock_rising_edge_count = 2 THEN
       clklock_half_period_minus_dly0 <= (NOW - clklock_last_falling_edge) + tpd;
       --clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;
     END IF;
     END IF;
 
  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	refclk_half_period1 <= (NOW - clklock_last_rising_edge); 
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)* str2int(div)/str2int(mult);
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= (NOW - clklock_last_rising_edge) + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc + 1 THEN
         if(clockboost >1) then
	   FOR i IN 1 TO (2*clockboost) LOOP       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

process
begin
    wait until CLK_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
   END LOOP;
end process;

process
begin
   wait until (clklock_falling_edge_count >= lock_cyc + 1);
    wait for clklock_half_period_minus_dly0;
   CLK_OUT_start <= '1';
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;

    intrecclk <= REFCLK_ipd;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;

    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ;

    CSLOCK  <= CSLOCK_sig;

process (inthsrecclk)
begin
        if(inthsrecclk'event and inthsrecclk = '1') then
           if cnt = "1010" then
              cnt <= "0001";
            else
              cnt <= cnt + "0001";
           end if; 
        end if;
end process;


data_out(0)  <= TXD0_ipd when cnt = "1010" else shift_buffer(1);
data_out(1)  <= TXD1_ipd when cnt = "1010" else shift_buffer(2);
data_out(2)  <= TXD2_ipd when cnt = "1010" else shift_buffer(3);
data_out(3)  <= TXD3_ipd when cnt = "1010" else shift_buffer(4);
data_out(4)  <= TXD4_ipd when cnt = "1010" else shift_buffer(5);
data_out(5)  <= TXD5_ipd when cnt = "1010" else shift_buffer(6);
data_out(6)  <= TXD6_ipd when cnt = "1010" else shift_buffer(7);
data_out(7)  <= TXD7_ipd when cnt = "1010" else shift_buffer(8);
data_out(8)  <= TXD8_ipd when cnt = "1010" else shift_buffer(9);
data_out(9)  <= TXD9_ipd when cnt = "1010" else shift_buffer(0);

process (inthsrecclk,data_out)
begin
        if(inthsrecclk'event and inthsrecclk='1') then
          SOUT_int         <= data_out(0);
          shift_buffer(1)  <= data_out(1);
          shift_buffer(2)  <= data_out(2);
          shift_buffer(3)  <= data_out(3);
          shift_buffer(4)  <= data_out(4);
          shift_buffer(5)  <= data_out(5);
          shift_buffer(6)  <= data_out(6);
          shift_buffer(7)  <= data_out(7);
          shift_buffer(8)  <= data_out(8);
          shift_buffer(9)  <= data_out(9);
        end if;
end process;

SOUT <= SOUT_int1 after refclk_half_period*2*str2int(div)/str2int(mult);
SOUT_int1 <= SOUT_int after refclk_half_period*2*str2int(div)/str2int(mult);

end VITAL;

configuration CFG_TX_8B10B_VITAL of TX_8B10B is 
        for VITAL
        end for; 
end CFG_TX_8B10B_VITAL;

----- VITAL model for cell TX_SS_4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_unsigned.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity TX_SS_4 is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "4";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tsetup_TXD0_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD0_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD1_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD1_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD2_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD2_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD3_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD3_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tipd_REFCLK    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD0      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD1      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD2      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD3      :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      REFCLK            : in    STD_ULOGIC;
      TXD0              : in    STD_ULOGIC;
      TXD1              : in    STD_ULOGIC;
      TXD2              : in    STD_ULOGIC;
      TXD3              : in    STD_ULOGIC;
      SOUT              : out   STD_ULOGIC;
      SS_CLKOUT         : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TX_SS_4 : entity is FALSE;
end TX_SS_4;


architecture VITAL of TX_SS_4 is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL REFCLK_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD0_ipd        : STD_ULOGIC := 'X';
  SIGNAL TXD1_ipd        : STD_ULOGIC := 'X';
  SIGNAL TXD2_ipd        : STD_ULOGIC := 'X';
  SIGNAL TXD3_ipd        : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL data_out       : std_logic_vector(3 downto 0) := (others => '0');
  SIGNAL shift_buffer   : std_logic_vector(3 downto 0) := (others => '0');
  SIGNAL cnt            : std_logic_vector(3 downto 0) := (others => '0');
  
  
  signal sout1 : std_logic := '0'; --ct101304

  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);
  
  

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (REFCLK_ipd, REFCLK, tipd_REFCLK);
   VitalWireDelay (TXD0_ipd, TXD0, tipd_TXD0);
   VitalWireDelay (TXD1_ipd, TXD1, tipd_TXD1);
   VitalWireDelay (TXD2_ipd, TXD2, tipd_TXD2);
   VitalWireDelay (TXD3_ipd, TXD3, tipd_TXD3);
   end block;

   VITALBehavior  : process
        variable Tviol_TXD0_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD1_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD2_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD3_REFCLK_posedge     : std_ulogic  := '0';
        variable Tmkr_TXD0_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD1_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD2_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD3_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Violation                    : std_logic    := '0'; 
    begin
      if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD0_REFCLK_posedge,
          TimingData              => Tmkr_TXD0_REFCLK_posedge,
          TestSignal              => TXD0_ipd,
          TestSignalName          => "TXD0",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD0_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD0_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD0_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD0_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD1_REFCLK_posedge,
          TimingData              => Tmkr_TXD1_REFCLK_posedge,
          TestSignal              => TXD1_ipd,
          TestSignalName          => "TXD1",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD1_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD1_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD1_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD1_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD2_REFCLK_posedge,
          TimingData              => Tmkr_TXD2_REFCLK_posedge,
          TestSignal              => TXD2_ipd,
          TestSignalName          => "TXD2",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD2_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD2_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD2_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD2_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD3_REFCLK_posedge,
          TimingData              => Tmkr_TXD3_REFCLK_posedge,
          TestSignal              => TXD3_ipd,
          TestSignalName          => "TXD3",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD3_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD3_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD3_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD3_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_4",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

     Violation := Tviol_TXD0_REFCLK_posedge or Tviol_TXD1_REFCLK_posedge or 
                 Tviol_TXD2_REFCLK_posedge or Tviol_TXD3_REFCLK_posedge;

    wait on REFCLK_ipd, TXD0_ipd, TXD1_ipd, TXD2_ipd, TXD3_ipd;
  end process VITALBehavior; 

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= REFCLK_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= REFCLK_ipd;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;
    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ; --ct101804
    CSLOCK <= CSLOCK_sig;
    SS_CLKOUT <= intrecclk;

process (inthsrecclk)
begin
        if(inthsrecclk'event and inthsrecclk = '1') then
           if cnt = "0011" then
              cnt <= "0000";
            else
              cnt <= cnt + "0001";
           end if; 
        end if;
end process;


--data_out(0)  <= TXD0_ipd when cnt = "0011" else shift_buffer(1);
--data_out(1)  <= TXD1_ipd when cnt = "0011" else shift_buffer(2);
--data_out(2)  <= TXD2_ipd when cnt = "0011" else shift_buffer(3);
--data_out(3)  <= TXD3_ipd when cnt = "0011" else shift_buffer(0);

--process (inthsrecclk,data_out)
--begin
--        if(inthsrecclk'event and inthsrecclk='1') then
--          SOUT             <= data_out(0);
--          shift_buffer(1)  <= data_out(1);
--          shift_buffer(2)  <= data_out(2);
--          shift_buffer(3)  <= data_out(3);
--        end if;
--end process;

process (inthsrecclk)
  begin
     if(inthsrecclk'event and inthsrecclk='1') then
        if ( cnt = "0000" ) then
           data_out <= TXD3_ipd & TXD2_ipd & TXD1_ipd & TXD0_ipd;
        			
        else 
           data_out(2 downto 0) <= data_out(3 downto 1);
           data_out(3) <= data_out(0);
        end if;
     end if;
  end process;
  
  process (inthsrecclk)
  begin
     if(inthsrecclk'event and inthsrecclk='1') then
        sout1<= data_out(0);
        SOUT <= sout1;
     end if;
  end process;


end VITAL;

configuration CFG_TX_SS_4_VITAL of TX_SS_4 is 
        for VITAL
        end for; 
end CFG_TX_SS_4_VITAL;

----- VITAL model for cell TX_SS_6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_unsigned.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity TX_SS_6 is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "6";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  : string  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tsetup_TXD0_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD0_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD1_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD1_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD2_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD2_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD3_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD3_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD4_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD4_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD5_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD5_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tipd_REFCLK    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD0      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD1      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD2      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD3      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD4      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD5      :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      REFCLK            : in    STD_ULOGIC;
      TXD0              : in    STD_ULOGIC;
      TXD1              : in    STD_ULOGIC;
      TXD2              : in    STD_ULOGIC;
      TXD3              : in    STD_ULOGIC;
      TXD4              : in    STD_ULOGIC;
      TXD5              : in    STD_ULOGIC;
      SOUT              : out   STD_ULOGIC;
      SS_CLKOUT         : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TX_SS_6 : entity is FALSE;
end TX_SS_6;


architecture VITAL of TX_SS_6 is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL REFCLK_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD0_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD1_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD2_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD3_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD4_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD5_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';

  SIGNAL data_out       : std_logic_vector(5 downto 0) := (others => '0');
  SIGNAL shift_buffer   : std_logic_vector(5 downto 0) := (others => '0');
  SIGNAL cnt            : std_logic_vector(3 downto 0) := (others => '0');

  signal sout1 : std_logic := '0'; --ct101304
  
  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (REFCLK_ipd, REFCLK, tipd_REFCLK);
   VitalWireDelay (TXD0_ipd, TXD0, tipd_TXD0);
   VitalWireDelay (TXD1_ipd, TXD1, tipd_TXD1);
   VitalWireDelay (TXD2_ipd, TXD2, tipd_TXD2);
   VitalWireDelay (TXD3_ipd, TXD3, tipd_TXD3);
   VitalWireDelay (TXD4_ipd, TXD4, tipd_TXD4);
   VitalWireDelay (TXD5_ipd, TXD5, tipd_TXD5);
   end block;

   VITALBehavior : process

        variable Tviol_TXD0_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD1_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD2_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD3_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD4_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD5_REFCLK_posedge     : std_ulogic  := '0';
        variable Tmkr_TXD0_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD1_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD2_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD3_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD4_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD5_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Violation                    : std_ulogic   := '0';
     begin
       if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD0_REFCLK_posedge,
          TimingData              => Tmkr_TXD0_REFCLK_posedge,
          TestSignal              => TXD0_ipd,
          TestSignalName          => "TXD0",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD0_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD0_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD0_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD0_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_6",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD1_REFCLK_posedge,
          TimingData              => Tmkr_TXD1_REFCLK_posedge,
          TestSignal              => TXD1_ipd,
          TestSignalName          => "TXD1",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD1_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD1_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD1_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD1_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_6",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD2_REFCLK_posedge,
          TimingData              => Tmkr_TXD2_REFCLK_posedge,
          TestSignal              => TXD2_ipd,
          TestSignalName          => "TXD2",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD2_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD2_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD2_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD2_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_6",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD3_REFCLK_posedge,
          TimingData              => Tmkr_TXD3_REFCLK_posedge,
          TestSignal              => TXD3_ipd,
          TestSignalName          => "TXD3",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD3_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD3_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD3_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD3_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_6",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD4_REFCLK_posedge,
          TimingData              => Tmkr_TXD4_REFCLK_posedge,
          TestSignal              => TXD4_ipd,
          TestSignalName          => "TXD4",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD4_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD4_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD4_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD4_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_6",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD5_REFCLK_posedge,
          TimingData              => Tmkr_TXD5_REFCLK_posedge,
          TestSignal              => TXD5_ipd,
          TestSignalName          => "TXD5",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD5_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD5_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD5_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD5_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_6",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
        end if;

    Violation := Tviol_TXD0_REFCLK_posedge or Tviol_TXD1_REFCLK_posedge or 
                 Tviol_TXD2_REFCLK_posedge or Tviol_TXD3_REFCLK_posedge or 
                 Tviol_TXD4_REFCLK_posedge or Tviol_TXD5_REFCLK_posedge;
   
    wait on TXD0_ipd, TXD1_ipd, TXD2_ipd, TXD3_ipd, TXD4_ipd, TXD5_ipd, REFCLK_ipd;

   end  process VITALBehavior;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= REFCLK_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= REFCLK_ipd;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 
                          
    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ; --ct101804
    CSLOCK <= CSLOCK_sig;
    inthsrecclk <= CLK_OUT_plus_delay;
    SS_CLKOUT <= intrecclk;

process (inthsrecclk)
begin
        if(inthsrecclk'event and inthsrecclk = '1') then
           if cnt = "0101" then
              cnt <= "0000";
            else
              cnt <= cnt + "0001";
           end if; 
        end if;
end process;


--data_out(0)  <= TXD0_ipd when cnt = "0101" else shift_buffer(1);
--data_out(1)  <= TXD1_ipd when cnt = "0101" else shift_buffer(2);
--data_out(2)  <= TXD2_ipd when cnt = "0101" else shift_buffer(3);
--data_out(3)  <= TXD3_ipd when cnt = "0101" else shift_buffer(4);
--data_out(4)  <= TXD4_ipd when cnt = "0101" else shift_buffer(5);
--data_out(5)  <= TXD5_ipd when cnt = "0101" else shift_buffer(0);

--process (inthsrecclk,data_out)
--begin
--        if(inthsrecclk'event and inthsrecclk='1') then
--          SOUT             <= data_out(0);
--          shift_buffer(1)  <= data_out(1);
--          shift_buffer(2)  <= data_out(2);
--          shift_buffer(3)  <= data_out(3);
--          shift_buffer(4)  <= data_out(4);
--          shift_buffer(5)  <= data_out(5);
--        end if;
--end process;


  --ct101804
  process (inthsrecclk)
  begin
     if(inthsrecclk'event and inthsrecclk='1') then
        if ( cnt = "0000" ) then
           data_out <= TXD5_ipd & TXD4_ipd &
        			TXD3_ipd & TXD2_ipd & TXD1_ipd & TXD0_ipd;
        else 
           data_out(4 downto 0) <= data_out(5 downto 1);
           data_out(5) <= data_out(0);
        end if;
     end if;
  end process;
  
  process (inthsrecclk)
  begin
     if(inthsrecclk'event and inthsrecclk='1') then
        sout1<= data_out(0);
        SOUT <= sout1;
     end if;
  end process;

end VITAL;

configuration CFG_TX_SS_6_VITAL of TX_SS_6 is 
        for VITAL
        end for; 
end CFG_TX_SS_6_VITAL;

----- VITAL model for cell TX_SS_8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_unsigned.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity TX_SS_8 is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "8";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  :  STRING  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tsetup_TXD0_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD0_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD1_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD1_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD2_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD2_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD3_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD3_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD4_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD4_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD5_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD5_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD6_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD6_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD7_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD7_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tipd_REFCLK    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD0      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD1      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD2      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD3      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD4      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD5      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD6      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD7      :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      REFCLK            : in    STD_ULOGIC;
      TXD0              : in    STD_ULOGIC;
      TXD1              : in    STD_ULOGIC;
      TXD2              : in    STD_ULOGIC;
      TXD3              : in    STD_ULOGIC;
      TXD4              : in    STD_ULOGIC;
      TXD5              : in    STD_ULOGIC;
      TXD6              : in    STD_ULOGIC;
      TXD7              : in    STD_ULOGIC;
      SOUT              : out   STD_ULOGIC;
      SS_CLKOUT         : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TX_SS_8 : entity is FALSE;
end TX_SS_8;

architecture VITAL of TX_SS_8 is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL REFCLK_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD0_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD1_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD2_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD3_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD4_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD5_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD6_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD7_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL data_out       : std_logic_vector(7 downto 0) := (others => '0');
  SIGNAL shift_buffer   : std_logic_vector(7 downto 0) := (others => '0');
  SIGNAL cnt            : std_logic_vector(3 downto 0) := (others => '0');

  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(PLL_DLY);
  
  signal sout1 : std_logic := '0'; --ct101304
  
  --signal mult_r_tmp : real :=  real(str2int(mult));
  --signal div_r_tmp : real := real (str2int(div));
  --signal clockboost_tmp : real := mult_r_tmp/div_r_tmp;
  signal inv_clockboost_tmp :real := 1.0/(real(str2int(mult))/real(str2int(div)));
  signal clklock_half_period_tmp : time := 100 ns;

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (REFCLK_ipd, REFCLK, tipd_REFCLK);
   VitalWireDelay (TXD0_ipd, TXD0, tipd_TXD0);
   VitalWireDelay (TXD1_ipd, TXD1, tipd_TXD1);
   VitalWireDelay (TXD2_ipd, TXD2, tipd_TXD2);
   VitalWireDelay (TXD3_ipd, TXD3, tipd_TXD3);
   VitalWireDelay (TXD4_ipd, TXD4, tipd_TXD4);
   VitalWireDelay (TXD5_ipd, TXD5, tipd_TXD5);
   VitalWireDelay (TXD6_ipd, TXD6, tipd_TXD6);
   VitalWireDelay (TXD7_ipd, TXD7, tipd_TXD7);
   end block;

   VITALBehavior : process

        variable Tviol_TXD0_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD1_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD2_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD3_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD4_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD5_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD6_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD7_REFCLK_posedge     : std_ulogic  := '0';
        variable Tmkr_TXD0_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD1_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD2_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD3_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD4_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD5_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD6_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD7_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Violation                    : std_logic   := '0';
   begin
       if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD0_REFCLK_posedge,
          TimingData              => Tmkr_TXD0_REFCLK_posedge,
          TestSignal              => TXD0_ipd,
          TestSignalName          => "TXD0",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD0_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD0_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD0_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD0_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD1_REFCLK_posedge,
          TimingData              => Tmkr_TXD1_REFCLK_posedge,
          TestSignal              => TXD1_ipd,
          TestSignalName          => "TXD1",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD1_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD1_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD1_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD1_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD2_REFCLK_posedge,
          TimingData              => Tmkr_TXD2_REFCLK_posedge,
          TestSignal              => TXD2_ipd,
          TestSignalName          => "TXD2",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD2_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD2_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD2_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD2_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD3_REFCLK_posedge,
          TimingData              => Tmkr_TXD3_REFCLK_posedge,
          TestSignal              => TXD3_ipd,
          TestSignalName          => "TXD3",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD3_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD3_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD3_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD3_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD4_REFCLK_posedge,
          TimingData              => Tmkr_TXD4_REFCLK_posedge,
          TestSignal              => TXD4_ipd,
          TestSignalName          => "TXD4",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD4_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD4_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD4_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD4_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD5_REFCLK_posedge,
          TimingData              => Tmkr_TXD5_REFCLK_posedge,
          TestSignal              => TXD5_ipd,
          TestSignalName          => "TXD5",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD5_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD5_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD5_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD5_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD6_REFCLK_posedge,
          TimingData              => Tmkr_TXD6_REFCLK_posedge,
          TestSignal              => TXD6_ipd,
          TestSignalName          => "TXD6",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD6_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD6_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD6_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD6_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD7_REFCLK_posedge,
          TimingData              => Tmkr_TXD7_REFCLK_posedge,
          TestSignal              => TXD7_ipd,
          TestSignalName          => "TXD7",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD7_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD7_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD7_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD7_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_8",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
       end if;

    Violation := Tviol_TXD0_REFCLK_posedge or Tviol_TXD1_REFCLK_posedge or 
                 Tviol_TXD2_REFCLK_posedge or Tviol_TXD3_REFCLK_posedge or 
                 Tviol_TXD4_REFCLK_posedge or Tviol_TXD5_REFCLK_posedge or 
                 Tviol_TXD6_REFCLK_posedge or Tviol_TXD7_REFCLK_posedge;

    wait on REFCLK_ipd, TXD0_ipd, TXD1_ipd, TXD2_ipd, TXD3_ipd, TXD4_ipd, TXD5_ipd, TXD6_ipd, TXD7_ipd;

   end  process VITALBehavior;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= REFCLK_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_half_period_tmp <= (NOW - clklock_last_rising_edge) * inv_clockboost_tmp;
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= REFCLK_ipd;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;
    
    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus ; --ct101804
    CSLOCK <= CSLOCK_sig;
    
    SS_CLKOUT   <= intrecclk;

process (inthsrecclk)
begin
        if(inthsrecclk'event and inthsrecclk = '1') then
           if cnt = "0111" then
              cnt <= "0000";
            else
              cnt <= cnt + "0001";
           end if; 
        end if;
end process;

--ct101304
--data_out(0)  <= TXD0_ipd when cnt = "0111" else shift_buffer(1);
--data_out(1)  <= TXD1_ipd when cnt = "0111" else shift_buffer(2);
--data_out(2)  <= TXD2_ipd when cnt = "0111" else shift_buffer(3);
--data_out(3)  <= TXD3_ipd when cnt = "0111" else shift_buffer(4);
--data_out(4)  <= TXD4_ipd when cnt = "0111" else shift_buffer(5);
--data_out(5)  <= TXD5_ipd when cnt = "0111" else shift_buffer(6);
--data_out(6)  <= TXD6_ipd when cnt = "0111" else shift_buffer(7);
--data_out(7)  <= TXD7_ipd when cnt = "0111" else shift_buffer(0);

--process (inthsrecclk,data_out)
--begin
  --      if(inthsrecclk'event and inthsrecclk='1') then
  --      SOUT             <= data_out(0);
  --        shift_buffer(1)  <= data_out(1);
  --        shift_buffer(2)  <= data_out(2);
  --        shift_buffer(3)  <= data_out(3);
  --        shift_buffer(4)  <= data_out(4);
  --        shift_buffer(5)  <= data_out(5);
  --        shift_buffer(6)  <= data_out(6);
  --       shift_buffer(7)  <= data_out(7);
  --      end if;
--end process;

  --ct101304
  process (inthsrecclk)
  begin
     if(inthsrecclk'event and inthsrecclk='1') then
        if ( cnt = "0000" ) then
           data_out <= TXD7_ipd & TXD6_ipd & TXD5_ipd & TXD4_ipd &
        			TXD3_ipd & TXD2_ipd & TXD1_ipd & TXD0_ipd;
        else 
           data_out(6 downto 0) <= data_out(7 downto 1);
           data_out(7) <= data_out(0);
        end if;
     end if;
  end process;
  
  process (inthsrecclk)
  begin
     if(inthsrecclk'event and inthsrecclk='1') then
        sout1<= data_out(0);
        SOUT <= sout1;
     end if;
  end process;
     

end VITAL;

configuration CFG_TX_SS_8_VITAL of TX_SS_8 is 
        for VITAL
        end for; 
end CFG_TX_SS_8_VITAL;

----- VITAL model for cell TX_SS_10 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_unsigned.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library GDX2;
use GDX2.components.all;

-- entity declaration --
entity TX_SS_10 is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "10";
      DIV      : string  := "1";
      LOCK_CYC : integer := 2;
      PLL_DLY  :  STRING  := "0.0";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tsetup_TXD0_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD0_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD1_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD1_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD2_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD2_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD3_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD3_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD4_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD4_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD5_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD5_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD6_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD6_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD7_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD7_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD8_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD8_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tsetup_TXD9_REFCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_TXD9_REFCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;
      tipd_REFCLK    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD0      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD1      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD2      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD3      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD4      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD5      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD6      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD7      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD8      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_TXD9      :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      REFCLK            : in    STD_ULOGIC;
      TXD0              : in    STD_ULOGIC;
      TXD1              : in    STD_ULOGIC;
      TXD2              : in    STD_ULOGIC;
      TXD3              : in    STD_ULOGIC;
      TXD4              : in    STD_ULOGIC;
      TXD5              : in    STD_ULOGIC;
      TXD6              : in    STD_ULOGIC;
      TXD7              : in    STD_ULOGIC;
      TXD8              : in    STD_ULOGIC;
      TXD9              : in    STD_ULOGIC;
      SOUT              : out   STD_ULOGIC;
      SS_CLKOUT         : out   STD_ULOGIC;
      CSLOCK            : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of TX_SS_10 : entity is FALSE;
end TX_SS_10;

architecture VITAL of TX_SS_10 is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL REFCLK_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD0_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD1_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD2_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD3_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD4_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD5_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD6_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD7_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD8_ipd	 : STD_ULOGIC := 'X';
  SIGNAL TXD9_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL CSLOCK_sig  : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;
  SIGNAL clk_in_period : TIME ;
  SIGNAL clock_count  : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_2d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_2d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  SIGNAL inthsrecclk    : std_logic := '0';
  SIGNAL intrecclk      : std_logic := '0';
  SIGNAL intrecclk_d    : std_logic := '0';
  SIGNAL intrecclk_d1   : std_logic := '0';
  SIGNAL intrecclk_d2   : std_logic := '0';

  SIGNAL data_out       : std_logic_vector(9 downto 0) := (others => '0');
  SIGNAL shift_buffer   : std_logic_vector(9 downto 0) := (others => '0');
  SIGNAL cnt            : std_logic_vector(3 downto 0) := (others => '0');
  
   signal sout1 : std_logic := '0'; --ct101304

  CONSTANT clockboost: real := real(str2int(mult)) / real(str2int(div));
  CONSTANT tpd: time := 1.0 ns * str2real(PLL_DLY);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (REFCLK_ipd, REFCLK, tipd_REFCLK);
   VitalWireDelay (TXD0_ipd, TXD0, tipd_TXD0);
   VitalWireDelay (TXD1_ipd, TXD1, tipd_TXD1);
   VitalWireDelay (TXD2_ipd, TXD2, tipd_TXD2);
   VitalWireDelay (TXD3_ipd, TXD3, tipd_TXD3);
   VitalWireDelay (TXD4_ipd, TXD4, tipd_TXD4);
   VitalWireDelay (TXD5_ipd, TXD5, tipd_TXD5);
   VitalWireDelay (TXD6_ipd, TXD6, tipd_TXD6);
   VitalWireDelay (TXD7_ipd, TXD7, tipd_TXD7);
   VitalWireDelay (TXD8_ipd, TXD8, tipd_TXD8);
   VitalWireDelay (TXD9_ipd, TXD9, tipd_TXD9);
   end block;

   VITALBehavior : process

        variable Tviol_TXD0_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD1_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD2_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD3_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD4_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD5_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD6_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD7_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD8_REFCLK_posedge     : std_ulogic  := '0';
        variable Tviol_TXD9_REFCLK_posedge     : std_ulogic  := '0';
        variable Tmkr_TXD0_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD1_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD2_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD3_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD4_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD5_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD6_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD7_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD8_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Tmkr_TXD9_REFCLK_posedge     : VitalTimingDataType := VitalTimingDataInit; 
        variable Violation                    : std_logic   := '0';
   begin
       if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD0_REFCLK_posedge,
          TimingData              => Tmkr_TXD0_REFCLK_posedge,
          TestSignal              => TXD0_ipd,
          TestSignalName          => "TXD0",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD0_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD0_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD0_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD0_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_10",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD1_REFCLK_posedge,
          TimingData              => Tmkr_TXD1_REFCLK_posedge,
          TestSignal              => TXD1_ipd,
          TestSignalName          => "TXD1",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD1_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD1_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD1_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD1_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_10",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD2_REFCLK_posedge,
          TimingData              => Tmkr_TXD2_REFCLK_posedge,
          TestSignal              => TXD2_ipd,
          TestSignalName          => "TXD2",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD2_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD2_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD2_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD2_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_10",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD3_REFCLK_posedge,
          TimingData              => Tmkr_TXD3_REFCLK_posedge,
          TestSignal              => TXD3_ipd,
          TestSignalName          => "TXD3",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD3_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD3_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD3_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD3_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_10",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD4_REFCLK_posedge,
          TimingData              => Tmkr_TXD4_REFCLK_posedge,
          TestSignal              => TXD4_ipd,
          TestSignalName          => "TXD4",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD4_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD4_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD4_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD4_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_10",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD5_REFCLK_posedge,
          TimingData              => Tmkr_TXD5_REFCLK_posedge,
          TestSignal              => TXD5_ipd,
          TestSignalName          => "TXD5",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD5_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD5_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD5_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD5_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_10",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD6_REFCLK_posedge,
          TimingData              => Tmkr_TXD6_REFCLK_posedge,
          TestSignal              => TXD6_ipd,
          TestSignalName          => "TXD6",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD6_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD6_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD6_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD6_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_10",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD7_REFCLK_posedge,
          TimingData              => Tmkr_TXD7_REFCLK_posedge,
          TestSignal              => TXD7_ipd,
          TestSignalName          => "TXD7",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD7_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD7_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD7_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD7_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_10",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD8_REFCLK_posedge,
          TimingData              => Tmkr_TXD8_REFCLK_posedge,
          TestSignal              => TXD8_ipd,
          TestSignalName          => "TXD8",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD8_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD8_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD8_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD8_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_10",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_TXD9_REFCLK_posedge,
          TimingData              => Tmkr_TXD9_REFCLK_posedge,
          TestSignal              => TXD9_ipd,
          TestSignalName          => "TXD9",
          TestDelay               => 0 ns,
          RefSignal               => REFCLK_ipd,
          RefSignalName           => "REFCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_TXD9_REFCLK_noedge_posedge,
          SetupLow                => tsetup_TXD9_REFCLK_noedge_posedge,
          HoldLow                 => thold_TXD9_REFCLK_noedge_posedge,
          HoldHigh                => thold_TXD9_REFCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/TX_SS_10",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

       end if;

    Violation := Tviol_TXD0_REFCLK_posedge or Tviol_TXD1_REFCLK_posedge or 
                 Tviol_TXD2_REFCLK_posedge or Tviol_TXD3_REFCLK_posedge or 
                 Tviol_TXD4_REFCLK_posedge or Tviol_TXD5_REFCLK_posedge or 
                 Tviol_TXD6_REFCLK_posedge or Tviol_TXD7_REFCLK_posedge or
                 Tviol_TXD8_REFCLK_posedge or Tviol_TXD9_REFCLK_posedge;

    wait on REFCLK_ipd, TXD0_ipd, TXD1_ipd, TXD2_ipd, TXD3_ipd, TXD4_ipd, TXD5_ipd, TXD6_ipd, TXD7_ipd, TXD8_ipd, TXD9_ipd;

   end  process VITALBehavior;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN

  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     clklock_last_rising_edge <= NOW;
     IF clklock_rising_edge_count = 0 THEN	
	start_inclk <= REFCLK_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
     END IF;
     END IF;
 
  WAIT UNTIL (REFCLK_ipd'EVENT AND REFCLK_ipd='0');	  	
     IF clklock_rising_edge_count = 1 THEN	
	clklock_half_period <= (NOW - clklock_last_rising_edge)/clockboost; 	
	clklock_last_falling_edge <= NOW;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc THEN
        if(clockboost >1.0) then
	   FOR i IN 1 TO integer(2.0*clockboost) LOOP 	       
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

    intrecclk <= REFCLK_ipd;


    CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not after clklock_half_period when clock_count > 0 else
                     CLK_OUT_sig_d_not;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_sig_2d <= CLK_OUT_sig_d after clklock_half_period; 
    CLK_OUT_sig_3d <= CLK_OUT_sig_2d after clklock_half_period + tpd;

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    inthsrecclk <= CLK_OUT_plus_delay;
    
    CSLOCK_sig <= PLL_LOCK_plus when tpd >= 0 ns else
              PLL_LOCK_minus ; --ct101804
    CSLOCK <= CSLOCK_sig;
    
    SS_CLKOUT   <= intrecclk;

process (inthsrecclk)
begin
        if(inthsrecclk'event and inthsrecclk = '1') then
           if cnt = "1001" then
              cnt <= "0000";
            else
              cnt <= cnt + "0001";
           end if; 
        end if;
end process;


--data_out(0)  <= TXD0_ipd when cnt = "1001" else shift_buffer(1);
--data_out(1)  <= TXD1_ipd when cnt = "1001" else shift_buffer(2);
--data_out(2)  <= TXD2_ipd when cnt = "1001" else shift_buffer(3);
--data_out(3)  <= TXD3_ipd when cnt = "1001" else shift_buffer(4);
--data_out(4)  <= TXD4_ipd when cnt = "1001" else shift_buffer(5);
--data_out(5)  <= TXD5_ipd when cnt = "1001" else shift_buffer(6);
--data_out(6)  <= TXD6_ipd when cnt = "1001" else shift_buffer(7);
--data_out(7)  <= TXD7_ipd when cnt = "1001" else shift_buffer(8);
--data_out(8)  <= TXD8_ipd when cnt = "1001" else shift_buffer(9);
--data_out(9)  <= TXD9_ipd when cnt = "1001" else shift_buffer(0);

--process (inthsrecclk,data_out)
--begin
--        if(inthsrecclk'event and inthsrecclk='1') then
--          SOUT             <= data_out(0);
--          shift_buffer(1)  <= data_out(1);
--          shift_buffer(2)  <= data_out(2);
--          shift_buffer(3)  <= data_out(3);
--          shift_buffer(4)  <= data_out(4);
--          shift_buffer(5)  <= data_out(5);
--          shift_buffer(6)  <= data_out(6);
--          shift_buffer(7)  <= data_out(7);
--          shift_buffer(8)  <= data_out(8);
--          shift_buffer(9)  <= data_out(9);
--        end if;
--end process;

process (inthsrecclk)
  begin
     if(inthsrecclk'event and inthsrecclk='1') then
        if ( cnt = "0000" ) then
           data_out <= TXD9_ipd & TXD8_ipd & TXD7_ipd & TXD6_ipd & TXD5_ipd &
        			TXD4_ipd & TXD3_ipd & TXD2_ipd & TXD1_ipd & TXD0_ipd;
        else 
           data_out(8 downto 0) <= data_out(9 downto 1);
           data_out(9) <= data_out(0);
        end if;
     end if;
  end process;
  
  process (inthsrecclk)
  begin
     if(inthsrecclk'event and inthsrecclk='1') then
        sout1<= data_out(0);
        SOUT <= sout1;
     end if;
  end process;

end VITAL;

configuration CFG_TX_SS_10_VITAL of TX_SS_10 is 
        for VITAL
        end for; 
end CFG_TX_SS_10_VITAL;



-- ************************************************************************
--
--  Block Memory: Behavioral Model
--  The kernel of other RAM applications  
--
-- ************************************************************************
--
--  Init: Sep. 10, 2001
--  Written by: Zhou Xiao-qiu
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 224/226
--
-- ************************************************************************
--
--  Filename:  SC_BLOCK_RAM.vhd
--  Description: 16K X 1  BRAM behavioral model. 
--  May. 30, 2002 Read memory initialization file feature
-- ************************************************************************
library std;
use std.textio.all;

library ieee, std;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use std.textio.all;


-- ************************************************************************
-- Entity definition  
-- "generic" members 
-- ************************************************************************

entity SC_BRAM_16K is

  generic (

	 DEVICE_FAMILY : string  := "SuperCool";

         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;       
	 MEM_INIT_FLAG : integer := 0;  
	 MEM_INIT_FILE : string  := ""

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 

end SC_BRAM_16K;

-- ************************************************************************
-- Architecture
-- ************************************************************************

architecture LATTICE_BEHAV of SC_BRAM_16K is


procedure READ_MEM_INIT_FILE(
                              f_name : IN    STRING;
                              v_MEM  : OUT   STD_LOGIC_VECTOR
                             ) IS

    file     f_INIT_FILE   : TEXT is MEM_INIT_FILE;
    variable v_WORD        : line;
    variable v_GOODFLAG    : boolean;
    variable v_WORD_BIT    : string (WDATA_WIDTH_A downto 1) ;
    variable v_CHAR        : character;
    variable v_OFFSET      : integer := 0;
    variable v_LINE        : integer := 0;

    begin      
      
      while ( not(endfile(f_INIT_FILE)) and (v_LINE < 2**WADDR_WIDTH_A)) loop

      readline(f_INIT_FILE, v_WORD);
      read(v_WORD, v_WORD_BIT, v_GOODFLAG);

      for k in 0 to WDATA_WIDTH_A - 1 loop
        v_CHAR := v_WORD_BIT (k + 1);
        if (v_CHAR = '1') then
          v_MEM(v_OFFSET + k) := '1';

	elsif (v_CHAR = '0') then
          v_MEM(v_OFFSET + k) := '0';

--	else 
--          v_MEM(v_OFFSET + k) := 'X';

	end if;
      end loop;

      v_LINE := v_LINE + 1;
      v_OFFSET := v_OFFSET + WDATA_WIDTH_A;

    end loop;

  end READ_MEM_INIT_FILE;

--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Address (
    IN_ADDR : in std_logic_vector
 ) return boolean is

    variable v_Valid_Flag : boolean := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Address;

--------------------------------------------------------------------------
-- Signal Declaration
--------------------------------------------------------------------------

--------- Local signals used to propagate input wire delay ---------------

signal WADA_node   : std_logic_vector( WADDR_WIDTH_A -1 downto 0) := (others => 'X');
signal WEA_node    : std_logic := 'X';
signal WDA_node    : std_logic_vector( WDATA_WIDTH_A -1 downto 0) := (others => 'X');
signal RADA_node   : std_logic_vector( RADDR_WIDTH_A -1 downto 0) := (others => 'X');
signal REA_node    : std_logic := 'X';
signal RDA_node    : std_logic_vector( RDATA_WIDTH_A -1 downto 0) := (others => 'X');

signal WADB_node   : std_logic_vector( WADDR_WIDTH_B -1 downto 0) := (others => 'X');
signal WEB_node    : std_logic := 'X';
signal WDB_node    : std_logic_vector( WDATA_WIDTH_B -1 downto 0) := (others => 'X');
signal RADB_node   : std_logic_vector( RADDR_WIDTH_B -1 downto 0) := (others => 'X');
signal REB_node    : std_logic := 'X';
signal RDB_node    : std_logic_vector( RDATA_WIDTH_B -1 downto 0) := (others => 'X');

-- architecture
begin 

 WADA_node <= WADA;
 WEA_node  <= WEA;
 WDA_node  <= WDA;
 RADA_node <= RADA;
 REA_node  <= REA;
 RDA       <= RDA_node;
 
 WADB_node <= WADB;
 WEB_node  <= WEB;
 WDB_node  <= WDB;
 RADB_node <= RADB;
 REB_node  <= REB;
 RDB       <= RDB_node;

-----------------------------------------
--------- Behavior process  -------------
-----------------------------------------


  KERNEL_BEHAV : process( WADA_node, WEA_node, WDA_node, RADA_node, REA_node, WADB_node, WEB_node, WDB_node, RADB_node, REB_node)


--TSPEC: A note about sram initial values and rom mode: 
--       If the user does not provide any values, ... default 0 
--       for all ram locations in JECED
    variable v_MEM         : std_logic_vector(ARRAY_SIZE - 1 downto 0) := ( others => '0' ); 
    variable v_INI_DONE    : boolean := FALSE;
    variable v_WADDR_A     : integer;
    variable v_RADDR_A     : integer;
    variable v_WADDR_B     : integer;
    variable v_RADDR_B     : integer;

    variable v_WADDRA_Valid_Flag : boolean := TRUE;
    variable v_WADDRB_Valid_Flag : boolean := TRUE;
    variable v_RADDRA_Valid_Flag : boolean := TRUE;
    variable v_RADDRB_Valid_Flag : boolean := TRUE;

  begin -- Process
   
    if( MEM_INIT_FLAG = 1 and v_INI_DONE = FALSE) THEN
	READ_MEM_INIT_FILE(MEM_INIT_FILE, v_MEM);
	v_INI_DONE := TRUE;
    end if;

  -- Address Check    
    v_WADDRA_Valid_Flag := Valid_Address(WADA_node);	
    v_WADDRB_Valid_Flag := Valid_Address(WADB_node);
    v_RADDRA_Valid_Flag := Valid_Address(RADA_node);	
    v_RADDRB_Valid_Flag := Valid_Address(RADB_node);

    if ( v_WADDRA_Valid_Flag = TRUE ) then
 	v_WADDR_A := CONV_INTEGER(WADA_node);
--    else	
--      assert (Now = 0 ps) 
--        report "Write AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_WADDRB_Valid_Flag = TRUE ) then
      v_WADDR_B := CONV_INTEGER(WADB_node);
    else
--      assert (Now = 0 ps)
--        report "Write AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRA_Valid_Flag = TRUE ) then
      v_RADDR_A := CONV_INTEGER(RADA_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressA of Port contains invalid bit!"
--        severity warning;
    end if;	

    if (v_RADDRB_Valid_Flag = TRUE ) then
      v_RADDR_B := CONV_INTEGER(RADB_node);
--    else
--      assert (Now = 0 ps)
--        report "Read AddressB of Port contains invalid bit!"
--        severity warning;
    end if;	

  -- CHECK Operation
    if (WEA = '1' and WEB = '1' and 
         not( 
          (v_WADDR_A*WDATA_WIDTH_A + WDATA_WIDTH_A -1) < (v_WADDR_B*WDATA_WIDTH_B) 
                         or
          (v_WADDR_B*WDATA_WIDTH_B + WDATA_WIDTH_B -1) < (v_WADDR_A*WDATA_WIDTH_A)
         )
        ) then
      assert false
        report " Write collision! Writing in the same memory location using Port A and Port B will cause the memory content invalid."
        severity warning;
    end if;  

  -- MEM Operation	
    if (WEA_node = '1') then
        v_MEM((v_WADDR_A*WDATA_WIDTH_A + WDATA_WIDTH_A -1) downto (v_WADDR_A*WDATA_WIDTH_A)) := WDA_node;
    end if;

    if (WEB_node = '1') then
        v_MEM((v_WADDR_B*WDATA_WIDTH_B + WDATA_WIDTH_B -1) downto (v_WADDR_B*WDATA_WIDTH_B)) := WDB_node;
    end if;

    if (REA_node = '1') then
       RDA_node <= v_MEM((v_RADDR_A*RDATA_WIDTH_A + RDATA_WIDTH_A -1) downto (v_RADDR_A*RDATA_WIDTH_A));
--    else
--       RDA_node <= ( others => 'X');
    end if;
    
    if (REB_node = '1') then
       RDB_node <= v_MEM((v_RADDR_B*RDATA_WIDTH_B + RDATA_WIDTH_B -1) downto (v_RADDR_B*RDATA_WIDTH_B));
--    else
--       RDB_node <= ( others => 'X');
    end if;
    
  end process KERNEL_BEHAV;
    
end LATTICE_BEHAV;



-- ************************************************************************
--
--  FIFO: Behavioral Model
--  VHDL
--  
-- ************************************************************************
--
--  Init: Oct. 2001
--  Written by: Zhou Xiao-qiu (Sean ZHOU)
--  Email: xqzhou@lscsh.latticesemi.com
--  Tel: 86-21-64852865 ext. 226
--
-- ************************************************************************
--
--  Filename:  SC_FIFO.vhd
--  Description: FIFO behavioral model. 
--     
-- ************************************************************************

-- ************************************************************************
-- History: 
-- 1. Reset EMPTY & AMEMPTY to '0', '0' means 'Ture';   
-- 2. May. 30, 2002 Read memory initialization file feature
-- 3. Add control signal RE WE to BlockRAM 
-- 4. Add programable TERMINAL_COUNT
-- 5. Fix the Write 1-5, Read 2-6 issue
-- ************************************************************************

-- ************************************************************************
-- FIFO COMPONENTS READ_POINTER_CTRL
-- ************************************************************************
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity READ_POINTER_CTRL is
	generic (
              RPOINTER_WIDTH : integer := 9
		);
	port (
                TERMINAL_COUNT : in STD_LOGIC_VECTOR(RPOINTER_WIDTH -1 downto 0);--QQ
		GLOBAL_RST   : in STD_LOGIC ;
                RESET_RP     : in STD_LOGIC ;
                READ_EN      : in STD_LOGIC ;
                READ_CLK     : in STD_LOGIC ;
	        EMPTY_FLAG   : in STD_LOGIC ;
		READ_POINTER : out STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0)
	     );
end READ_POINTER_CTRL;

architecture LATTICE_BEHAV of READ_POINTER_CTRL is

  signal s_READ_POINTER : STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0) := (others => '0');

begin

  READ_POINTER <= s_READ_POINTER; 

process  (GLOBAL_RST, RESET_RP, READ_EN, READ_CLK)

	variable v_READ_POINTER: STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0):= (others => '0');

begin

	if GLOBAL_RST = '1'  or RESET_RP = '1' then 

          s_READ_POINTER <= TERMINAL_COUNT;--QQ 

	elsif (READ_CLK'EVENT and READ_CLK = '1') then
		if (READ_EN = '1' and EMPTY_FLAG = '1') then
                  v_READ_POINTER := s_READ_POINTER + '1';
                else  
                  v_READ_POINTER := s_READ_POINTER;
		end if;

		if (v_READ_POINTER = TERMINAL_COUNT + 1) then
		   s_READ_POINTER <= (others => '0');
		else
		   s_READ_POINTER <= v_READ_POINTER;
		end if;
	end if;

end process;
end LATTICE_BEHAV;

-- ************************************************************************
-- FIFO COMPONENTS WRITE_POINTER_CTRL
-- ************************************************************************
library ieee;
use ieee.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity WRITE_POINTER_CTRL is
        generic (
                WPOINTER_WIDTH : integer := 9;
                WDATA_WIDTH : integer := 32
		);
        port (
		TERMINAL_COUNT : in STD_LOGIC_VECTOR(WPOINTER_WIDTH -1 downto 0);--QQ
		GLOBAL_RST    : in STD_LOGIC ;
                WRITE_EN      : in STD_LOGIC ;
                WRITE_CLK     : in STD_LOGIC ;
                FULL_FLAG     : in STD_LOGIC ;
                WRITE_POINTER : out STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0)
            
	     );
end WRITE_POINTER_CTRL;

architecture LATTICE_BEHAV of WRITE_POINTER_CTRL is

 signal s_WRITE_POINTER : STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0):= (others => '0');

begin 

  WRITE_POINTER <= s_WRITE_POINTER;

  process  (GLOBAL_RST, WRITE_EN, WRITE_CLK)

    variable v_WRITE_POINTER: STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0):= (others => '0');

begin
	if GLOBAL_RST = '1'  then 
		s_WRITE_POINTER <= TERMINAL_COUNT ; 

	elsif (WRITE_CLK'EVENT and WRITE_CLK = '1') then
		if (WRITE_EN = '1' and FULL_FLAG /= '1') then
		   v_WRITE_POINTER := s_WRITE_POINTER + '1';
                else
		   v_WRITE_POINTER := s_WRITE_POINTER ;
                end if; 

		if (v_WRITE_POINTER = TERMINAL_COUNT + 1) then
		   s_WRITE_POINTER <= (others => '0');
		else
		   s_WRITE_POINTER <= v_WRITE_POINTER;
		end if;
	end if;
end process;
end LATTICE_BEHAV;

-- ************************************************************************
-- FIFO COMPONENTS FLAG LOGIC
-- ************************************************************************
library ieee;
use ieee.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity FLAG_LOGIC is
 	generic (
                WPOINTER_WIDTH : integer := 9;
                RPOINTER_WIDTH : integer := 9;
                WDATA_WIDTH    : integer := 32; 
                RDATA_WIDTH    : integer := 32; 
                AMFULL_X      : integer := 1;
                AMEMPTY_Y     : integer := 1
		);
	port (
		TERMINAL_COUNT : in STD_LOGIC_VECTOR(WPOINTER_WIDTH -1 downto 0);--QQ
		R_POINTER  : in STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0);
                W_POINTER  : in STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0);
                GLOBAL_RST : in STD_LOGIC ;
                READ_EN    : in STD_LOGIC ;
                READ_CLK   : in STD_LOGIC ;
                WRITE_EN   : in STD_LOGIC ;
                WRITE_CLK  : in STD_LOGIC ; 
                FULL_D     : out STD_LOGIC ;
                EMPTY_D    : out STD_LOGIC ;
                AMFULL_D   : out STD_LOGIC ;
                AMEMPTY_D  : out STD_LOGIC 
	);
end FLAG_LOGIC;

architecture LATTICE_BEHAV of FLAG_LOGIC is
--------------------------------------------------------------------------
-- Function: Valid_Address 
-- Description: 
--------------------------------------------------------------------------
function Valid_Pointer (
    IN_ADDR : in STD_LOGIC_VECTOR
 ) return BOOLEAN is

    variable v_Valid_Flag : BOOLEAN := TRUE;
 
begin

    for i in IN_ADDR'high downto IN_ADDR'low loop
        if (IN_ADDR(i) /= '0' and IN_ADDR(i) /= '1') then
            v_Valid_Flag := FALSE;
        end if;
    end loop;

    return v_Valid_Flag;
end Valid_Pointer;

--------------------------------------------------------------------------
-- Function: Calculate_Offset 
-- Description: 
--------------------------------------------------------------------------
function Calculate_Offset (
    IN_TC : in  STD_LOGIC_VECTOR;
    TC_LENGTH: in INTEGER
 ) return STD_LOGIC_VECTOR is

    variable vTC_FULL: STD_LOGIC_VECTOR (TC_LENGTH -1 downto 0) := (others => '1');
    variable vTC_TEMP: STD_LOGIC_VECTOR (TC_LENGTH -1 downto 0) := (others => '0');
    variable vOFFSET : STD_LOGIC_VECTOR (TC_LENGTH -1 downto 0) := (others => '0');
begin
    vTC_TEMP := IN_TC;
    vOFFSET := vTC_FULL-vTC_TEMP;
    return vOFFSET;
end Calculate_Offset;
   
begin 

--------------------------------------------------------------------------
-- Function: Main Process 
-- Description: 
--------------------------------------------------------------------------
FULL_AMFULL: process  (GLOBAL_RST, WRITE_EN, WRITE_CLK, W_POINTER, R_POINTER)
    variable v_WP_Valid_Flag : boolean := TRUE;
    variable v_RP_Valid_Flag : boolean := TRUE;
    --variable v_WP_Check_FULL_TMP : STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0):= (others => '0'); --QQ
    variable v_WP_Check_AMFL_TMP : STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0) := (others => '0'); --QQ
    variable v_WP_Check_AMFL_TMP1 : STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0) := (others => '0'); --QQ
    variable v_WP_Check_FULL : STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0) := (others => '0'); --QQ
    variable v_WP_Check_AMFL : STD_LOGIC_VECTOR (WPOINTER_WIDTH -1 downto 0) := (others => '0'); --QQ

begin
        v_WP_Valid_Flag := Valid_Pointer(W_POINTER);	
        v_RP_Valid_Flag := Valid_Pointer(R_POINTER);
        --v_WP_Check_FULL_TMP := W_POINTER + 1;
        v_WP_Check_AMFL_TMP := W_POINTER + AMFULL_X + 1;
        v_WP_Check_AMFL_TMP1 := v_WP_Check_AMFL_TMP + Calculate_Offset(TERMINAL_COUNT, WPOINTER_WIDTH);
	if (W_POINTER = TERMINAL_COUNT ) then
	    v_WP_Check_FULL := (others => '0');
	else
	    v_WP_Check_FULL := W_POINTER + 1; 
	end if;

	if GLOBAL_RST = '1'  then 
	    FULL_D <= '0';
	    AMFULL_D <= '0';

	elsif( v_WP_Valid_Flag = TRUE and v_RP_Valid_Flag = TRUE) then

	    if R_POINTER = v_WP_Check_FULL then
	     FULL_D <= '1';
            else
	     FULL_D <= '0';	
            end if;

            if (W_POINTER > R_POINTER) then
	      if (v_WP_Check_AMFL_TMP1 < W_POINTER) then
                if v_WP_Check_AMFL_TMP1 >= R_POINTER then
	         AMFULL_D <= '1';
	        else
	         AMFULL_D <= '0'; 	
	        end if; 
              else 
	         AMFULL_D <= '0'; 	
              end if;    
            elsif (W_POINTER < R_POINTER) then
	      if (v_WP_Check_AMFL_TMP1 < W_POINTER) then
	         AMFULL_D <= '1';
	      elsif (v_WP_Check_AMFL_TMP >= R_POINTER) then
	         AMFULL_D <= '1';
	      else 
	         AMFULL_D <= '0'; 	
	      end if; 
            end if;    

        end if;

end process FULL_AMFULL;

EMPTY_AMEMPTY: process  (GLOBAL_RST, READ_EN, READ_CLK, W_POINTER, R_POINTER)
    variable v_WP_Valid_Flag : boolean := TRUE;
    variable v_RP_Valid_Flag : boolean := TRUE;
    variable v_RP_Check_EMPT_TMP : STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0):= (others => '0'); --QQ
    variable v_RP_Check_AMET_TMP : STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0):= (others => '0'); --QQ
    variable v_RP_Check_AMET_TMP1 : STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0):= (others => '0'); --QQ
    --variable v_RP_Check_EMPT : STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0):= (others => '0'); --QQ
    variable v_RP_Check_AMET : STD_LOGIC_VECTOR (RPOINTER_WIDTH -1 downto 0):= (others => '0'); --QQ

begin
        v_WP_Valid_Flag := Valid_Pointer(W_POINTER);	
        v_RP_Valid_Flag := Valid_Pointer(R_POINTER);
        --v_RP_Check_AMET := R_POINTER + AMEMPTY_Y + 1;
	v_RP_Check_AMET_TMP := R_POINTER + AMEMPTY_Y ; -- Different from TSPEC QQ 07 17,2002
        v_RP_Check_AMET_TMP1 := v_RP_Check_AMET_TMP + Calculate_Offset(TERMINAL_COUNT, RPOINTER_WIDTH);

	if GLOBAL_RST = '1'  then 
	  EMPTY_D <= '0';
	  AMEMPTY_D <= '0';
	elsif( v_WP_Valid_Flag = TRUE and v_RP_Valid_Flag = TRUE) then
            if R_POINTER  = W_POINTER then   -- Different from TSPEC QQ 07 17,2002
                    EMPTY_D <= '0';
            else
                    EMPTY_D <= '1';
            end if;

	    
	    if (W_POINTER < R_POINTER) then
	      if (v_RP_Check_AMET_TMP1 < R_POINTER) then
	          v_RP_Check_AMET := v_RP_Check_AMET_TMP + Calculate_Offset(TERMINAL_COUNT, RPOINTER_WIDTH);
                if v_RP_Check_AMET >= W_POINTER then
	         AMEMPTY_D <= '0';
	        else
	         AMEMPTY_D <= '1'; 	
	        end if; 
              else 
	         AMEMPTY_D <= '1'; 	
              end if;    
            elsif (W_POINTER > R_POINTER) then
	      if (v_RP_Check_AMET_TMP1 < R_POINTER) then
	         AMEMPTY_D <= '0';
	      elsif (v_RP_Check_AMET_TMP >= W_POINTER) then
	         AMEMPTY_D <= '0';
	      else 
	         AMEMPTY_D <= '1'; 	
	      end if; 
            elsif (W_POINTER = R_POINTER) then
              AMEMPTY_D <= '0';
            end if;    
       end if;
end process EMPTY_AMEMPTY;

end LATTICE_BEHAV;


-- ************************************************************************
-- FIFO Main Body 
-- READ_POINTER_CTRL
-- WRITE_POINTER_CTRL
-- FLAG_LOGIC 
-- SC_BRAM_16K
-- ************************************************************************
-- ************************************************************************
-- Top Design Entity definition  
-- ************************************************************************

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.ALL;

--LIBRARY SC_LIB;
--USE SC_LIB.SC_FIFO_COMPS.ALL;

--ctse 062404
--------------------------------------------------------------------------------
 entity SC_FIFO_16K is 
  generic (
	DEVICE_FAMILY  : string  := "SuperCool";
  	TERMINAL_COUNT : integer := 511; --QQ: Word number < 2**WADDR_WIDTH
	WADDR_WIDTH    : integer :=   9;
        WDATA_WIDTH    : integer :=  32;
        RADDR_WIDTH    : integer :=   9;
        RDATA_WIDTH    : integer :=  32;
        ALMOST_FULL_X  : integer :=   1;
        ALMOST_EMPTY_Y : integer :=   1;
        MEM_INIT_FLAG  : integer :=   0;  
        MEM_INIT_FILE  : string  := "mem_init_file"

         );

  port (
        WE      : in STD_LOGIC ;
        WCLK    : in STD_LOGIC ;
        RST     : in STD_LOGIC ;
        RPRST   : in STD_LOGIC ;
        RE      : in STD_LOGIC ;
        RCLK    : in STD_LOGIC ;
        FULLIN  : in STD_LOGIC ;
        EMPTYIN : in STD_LOGIC ;
        DI      : in STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);

        FULL    : out STD_LOGIC ;
        EMPTY   : out STD_LOGIC ;
        AMFULL  : out STD_LOGIC ;
        AMEMPTY : out STD_LOGIC ;
        DO      : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)

        ); 

end SC_FIFO_16K; 

-- ************************************************************************
-- ARCHITECTURE
-- ************************************************************************
architecture LATTICE_BEHAV of SC_FIFO_16K is 

-- ************************************************************************
-- COMPONENT DECLARATIONS
-- ************************************************************************
component SC_BRAM_16K

  generic (
 	     
         DEVICE_FAMILY : string  := "SuperCool";
         WADDR_WIDTH_A : integer := 14;
         RADDR_WIDTH_A : integer := 12;
         WADDR_WIDTH_B : integer := 14;
         RADDR_WIDTH_B : integer := 12;
         WDATA_WIDTH_A : integer := 1;
         RDATA_WIDTH_A : integer := 4;
         WDATA_WIDTH_B : integer := 1;
         RDATA_WIDTH_B : integer := 4;
         ARRAY_SIZE    : integer := 16384;
         MEM_INIT_FLAG : integer := 0;  
         MEM_INIT_FILE : string  := "mem_init_file"

          );

  port (
         WADA : in  STD_LOGIC_VECTOR (WADDR_WIDTH_A -1 downto 0);
         WEA  : in  STD_LOGIC ;
         WDA  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_A -1 downto 0);
         RADA : in  STD_LOGIC_VECTOR (RADDR_WIDTH_A -1 downto 0);
         REA  : in  STD_LOGIC ;
         RDA  : out STD_LOGIC_VECTOR (RDATA_WIDTH_A -1 downto 0);
         
         WADB : in  STD_LOGIC_VECTOR (WADDR_WIDTH_B -1 downto 0);
         WEB  : in  STD_LOGIC;
         WDB  : in  STD_LOGIC_VECTOR (WDATA_WIDTH_B -1 downto 0);
         RADB : in  STD_LOGIC_VECTOR (RADDR_WIDTH_B -1 downto 0);
         REB  : in  STD_LOGIC;
         RDB  : out STD_LOGIC_VECTOR (RDATA_WIDTH_B -1 downto 0)
        ); 
 end component;

-- ************************************************************************
-- SIGNAL DECLARATIONS
-- ************************************************************************
signal we_ram : STD_LOGIC := '0';
signal re_ram : STD_LOGIC := '0';
signal full_bit : STD_LOGIC := '0';
signal empty_bit : STD_LOGIC := '1';
signal wptr_wrap_bit : STD_LOGIC := '0';
signal rptr_wrap_bit : STD_LOGIC := '0';
signal wptr : STD_LOGIC_VECTOR (WADDR_WIDTH - 1 downto 0) := (others => '0');
signal rptr : STD_LOGIC_VECTOR (RADDR_WIDTH - 1 downto 0) := (others => '0');
signal wptr_wrap_appended : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				:= (others => '0');
signal rptr_wrap_appended : STD_LOGIC_VECTOR (RADDR_WIDTH downto 0) 
				:= (others => '0');
signal next_wptr_wrap_appended : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				:= (others => '0');

signal next_rptr_wrap_appended : STD_LOGIC_VECTOR (RADDR_WIDTH downto 0) 
				:= (others => '0');

signal num_unread_loc : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				:= (others => '0');
signal num_empty_loc : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				:= (others => '0');
signal TERM_CNT_VEC : STD_LOGIC_VECTOR (WADDR_WIDTH  downto 0);
signal DEPTH : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0);   

signal wptr_rdomain : STD_LOGIC_VECTOR (WADDR_WIDTH - 1 downto 0) := (others => '0');
signal rptr_wdomain : STD_LOGIC_VECTOR (RADDR_WIDTH - 1 downto 0) := (others => '0');

signal wptr_wrap_bit_rdomain : STD_LOGIC := '0';
signal rptr_wrap_bit_wdomain : STD_LOGIC := '0';

signal wptr_wrap_appended_rdomain : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				  := (others => '0');
signal rptr_wrap_appended_wdomain : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0) 
				  := (others => '0');


signal ram_waddr : STD_LOGIC_VECTOR (WADDR_WIDTH - 1 downto 0) := (others => '0');
signal ram_raddr : STD_LOGIC_VECTOR (RADDR_WIDTH - 1 downto 0) := (others => '0');
signal ram_wdata : STD_LOGIC_VECTOR (WDATA_WIDTH - 1 downto 0) := (others => '0');
-- ************************************************************************
-- FUNCTIONS
-- ************************************************************************
function next_ptr (
   ptr_wrap_bit :  STD_LOGIC;
   ptr :  STD_LOGIC_VECTOR;
   TERMINAL_COUNT :  integer )

  return STD_LOGIC_VECTOR is

  variable result_ptr : STD_LOGIC_VECTOR (WADDR_WIDTH downto 0); 
  variable tmp_ptr : STD_LOGIC_VECTOR (WADDR_WIDTH - 1 downto 0);
  
begin
   if (ptr = TERMINAL_COUNT) then
      tmp_ptr := (others => '1');
   else
      tmp_ptr :=  ptr;
   end if;
   result_ptr := (ptr_wrap_bit & tmp_ptr) + 1;
  
   return result_ptr;

end next_ptr;

function INT_TO_VEC ( INPUT_INT : integer; INPUT_LENGTH: integer)
 return std_logic_vector is

   variable vDATA_STD_VEC: std_logic_vector(INPUT_LENGTH -1 downto 0) := (others => '0');
   variable vTRANS: integer := 0;
   variable vQUOTIENT: integer := 0;
 
 begin 
    vQUOTIENT := INPUT_INT;

    for i in 0 to INPUT_LENGTH -1 loop
	vTRANS := 0;
	while vQUOTIENT >1 loop
	    vQUOTIENT := vQUOTIENT - 2;
            vTRANS := vTRANS + 1;
	end loop;
        case vQUOTIENT is
              when 1 =>
                 vDATA_STD_VEC(i) := '1';
              when 0 =>
                 vDATA_STD_VEC(i) := '0';
              when others =>
                 null;
        end case;
        vQUOTIENT := vTRANS; 
    end loop;
  return vDATA_STD_VEC; 	  
 end INT_TO_VEC; 

-- ************************************************************************
-- BODY
-- ************************************************************************

begin 


-- ************************************************************************
-- CONCURRENT ASSIGNMENTS
-- ************************************************************************
TERM_CNT_VEC (WADDR_WIDTH downto 0) <= INT_TO_VEC(TERMINAL_COUNT, WADDR_WIDTH + 1);

DEPTH (WADDR_WIDTH downto 0)  <= TERM_CNT_VEC  + 1;


--we_ram  <= WE and not(full_bit);
--re_ram <= RE and not(empty_bit);

wptr <= wptr_wrap_appended(WADDR_WIDTH - 1 downto 0);
rptr <= rptr_wrap_appended(RADDR_WIDTH - 1 downto 0);
wptr_rdomain <= wptr_wrap_appended_rdomain(WADDR_WIDTH - 1 downto 0);
rptr_wdomain <= rptr_wrap_appended_wdomain(RADDR_WIDTH - 1 downto 0);

wptr_wrap_bit <= wptr_wrap_appended(WADDR_WIDTH);
rptr_wrap_bit <= rptr_wrap_appended(RADDR_WIDTH);
wptr_wrap_bit_rdomain  <= wptr_wrap_appended_rdomain (WADDR_WIDTH);
rptr_wrap_bit_wdomain  <= rptr_wrap_appended_wdomain (RADDR_WIDTH);

next_rptr_wrap_appended <= next_ptr(rptr_wrap_bit, rptr, TERMINAL_COUNT);
next_wptr_wrap_appended <= next_ptr(wptr_wrap_bit, wptr, TERMINAL_COUNT);

num_empty_loc <= -- used for full, computed in wdomain
   ( DEPTH + rptr_wdomain) - wptr when (rptr_wrap_bit_wdomain = wptr_wrap_bit)
else
   "0" & (rptr_wdomain -  wptr);

num_unread_loc <= --used for empty, computed in rdomain
   ( DEPTH + wptr_rdomain) - rptr when (wptr_wrap_bit_rdomain /= rptr_wrap_bit)
else
   "0" & (wptr_rdomain -  rptr);

full_bit <= '1' when (num_empty_loc = 0) else '0';
empty_bit <= '1' when (num_unread_loc = 0) else '0';


FULL <= full_bit;
EMPTY <= empty_bit; -- ACTIVE HIGH !!!!!!!!!!!!!!!!!!!!!!!!!!!!

AMFULL <= '1' when (num_empty_loc <= ALMOST_FULL_X) else '0';

-- AMEMPTY IS ACTIVE HIGH !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
AMEMPTY <= '1' when (num_unread_loc <= ALMOST_EMPTY_Y) else '0';
-- ************************************************************************
-- WRITE READ POINTERS
-- ************************************************************************

process (RST, RCLK)
begin

   if (RST = '1')  then
      rptr_wrap_appended <= (others => '0') ;
   elsif ( RCLK'event and RCLK = '1') then
      if ( (RE and not(empty_bit)) = '1') then
         rptr_wrap_appended <= next_rptr_wrap_appended after 1 ns;
      end if;
   end if ;   
end process;

process (RST, WCLK)
begin

   if (RST = '1')  then
      wptr_wrap_appended <= (others => '0');
   elsif ( WCLK'event and WCLK = '1') then
      if (WE = '1' and full_bit = '0') then
         wptr_wrap_appended <= next_wptr_wrap_appended after 1 ns;
      end if;
   end if;
end process;

-- ************************************************************************
-- POINTER SYNCHRONIZATIONS (SIMPLY DONE TO MATCH THE GATE-LEVEL MODEL)
-- ************************************************************************

process (RST, WCLK)
begin
   if (RST = '1')  then
      rptr_wrap_appended_wdomain <= (others => '0');
   elsif ( WCLK'event and WCLK = '1') then
      rptr_wrap_appended_wdomain <= rptr_wrap_appended after 1 ns;
   end if;
end process;

process (RST, RCLK)
begin
   if (RST = '1')  then
      wptr_wrap_appended_rdomain <= (others => '0');
   elsif ( RCLK'event and RCLK = '1') then
      wptr_wrap_appended_rdomain <= wptr_wrap_appended after 1 ns;
   end if;
end process;
-- ************************************************************************
-- SIGNALS TO RAM
-- ************************************************************************
process (RST, WCLK)
begin
   if (RST = '1')  then
      we_ram <= '0';
   else
      we_ram <= WE and not(full_bit);
   end if;
end process;

process (RST, RCLK)
begin
   if (RST = '1')  then
      re_ram <= '0';
   else
      re_ram <= RE and not(empty_bit);
end if;
end process;

process (RST, WCLK)
begin
   if (RST = '1')  then
      ram_waddr <= (others => '0');
   else
      ram_waddr <= wptr;
end if;
end process;

process (RST, RCLK)
begin
   if (RST = '1')  then
      ram_raddr <= (others => '0');
   else
      ram_raddr <= rptr;
   end if;
end process;

process (RST, WCLK)
begin
   if (RST = '1')  then
      ram_wdata <= (others => '0');
   else
      ram_wdata <= DI;
   end if;
end process;
-- ************************************************************************
-- INSTANTIATIONS
-- ************************************************************************

FIFO_BRAM_INST: SC_BRAM_16K

    generic map(
         DEVICE_FAMILY  => open ,
         WADDR_WIDTH_A  => WADDR_WIDTH, 
         RADDR_WIDTH_A  => RADDR_WIDTH, 
         WADDR_WIDTH_B  => WADDR_WIDTH, 
         RADDR_WIDTH_B  => RADDR_WIDTH, 
         WDATA_WIDTH_A  => WDATA_WIDTH, 
         RDATA_WIDTH_A  => RDATA_WIDTH, 
         WDATA_WIDTH_B  => WDATA_WIDTH, 
         RDATA_WIDTH_B  => RDATA_WIDTH, 
         ARRAY_SIZE     => open,
    	 MEM_INIT_FLAG  => MEM_INIT_FLAG,  
	 MEM_INIT_FILE  => MEM_INIT_FILE

       )
    port map (
         --WADA => wptr,
         WADA => ram_waddr,
         WEA  => we_ram,
         --WDA  => DI, 
         WDA  => ram_wdata,
         --RADA => rptr,
         RADA => ram_raddr,
         REA  => re_ram,
         RDA  => DO, 
         
         --WADB => wptr, 
         WADB => ram_waddr,
         WEB  => '0', 
         WDB  => DI, 
         --RADB => rptr,
         RADB => ram_raddr, 
         REB  => '0', 
         RDB  => open
      );


-- ************************************************************************
-- END ARCHITECTURE: SC_FIFO_16K
-- ************************************************************************
end LATTICE_BEHAV; 
 
----- CELL FIFO15X10A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity FIFO15X10A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      FIFO_FULL_FLAG     : integer  := 15;
      FIFO_AMFULL_FLAG   : integer :=  6;

      tpd_RCLK_DO0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_DO1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_DO2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_DO3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_DO4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_DO5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_DO6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_DO7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_DO8                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RCLK_DO9                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_RST_DO0                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_DO1                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_DO2                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_DO3                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_DO4                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_DO5                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_DO6                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_DO7                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_DO8                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_RST_DO9                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_DI0_DO0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI1_DO0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI2_DO0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI3_DO0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI4_DO0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI5_DO0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI6_DO0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI7_DO0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI8_DO0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI9_DO0                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_DI0_DO1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI1_DO1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI2_DO1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI3_DO1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI4_DO1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI5_DO1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI6_DO1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI7_DO1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI8_DO1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI9_DO1                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_DI0_DO2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI1_DO2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI2_DO2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI3_DO2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI4_DO2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI5_DO2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI6_DO2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI7_DO2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI8_DO2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI9_DO2                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_DI0_DO3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI1_DO3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI2_DO3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI3_DO3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI4_DO3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI5_DO3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI6_DO3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI7_DO3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI8_DO3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI9_DO3                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_DI0_DO4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI1_DO4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI2_DO4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI3_DO4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI4_DO4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI5_DO4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI6_DO4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI7_DO4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI8_DO4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI9_DO4                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_DI0_DO5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI1_DO5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI2_DO5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI3_DO5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI4_DO5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI5_DO5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI6_DO5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI7_DO5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI8_DO5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI9_DO5                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_DI0_DO6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI1_DO6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI2_DO6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI3_DO6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI4_DO6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI5_DO6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI6_DO6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI7_DO6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI8_DO6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI9_DO6                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_DI0_DO7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI1_DO7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI2_DO7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI3_DO7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI4_DO7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI5_DO7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI6_DO7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI7_DO7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI8_DO7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI9_DO7                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_DI0_DO8                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI1_DO8                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI2_DO8                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI3_DO8                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI4_DO8                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI5_DO8                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI6_DO8                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI7_DO8                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI8_DO8                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI9_DO8                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_DI0_DO9                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI1_DO9                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI2_DO9                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI3_DO9                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI4_DO9                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI5_DO9                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI6_DO9                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI7_DO9                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI8_DO9                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_DI9_DO9                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_WCLK_FULL                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_WCLK_START_RD                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tpd_RCLK_EMPTY                     :	VitalDelayType01 := (0.0 ns, 0.0 ns);

      tsetup_WE_WCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_WE_WCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;

      tsetup_RE_RCLK_noedge_posedge      :	VitalDelayType   := 0.1 ns;
      thold_RE_RCLK_noedge_posedge       :	VitalDelayType   := 0.0 ns;

      tsetup_DI0_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_DI0_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;
      tsetup_DI1_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_DI1_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;
      tsetup_DI2_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_DI2_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;
      tsetup_DI3_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_DI3_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;
      tsetup_DI4_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_DI4_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;
      tsetup_DI5_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_DI5_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;
      tsetup_DI6_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_DI6_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;
      tsetup_DI7_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_DI7_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;
      tsetup_DI8_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_DI8_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;
      tsetup_DI9_WCLK_noedge_posedge     :	VitalDelayType   := 0.1 ns;
      thold_DI9_WCLK_noedge_posedge      :	VitalDelayType   := 0.0 ns;

      trecovery_RST_RCLK_posedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_RST_RCLK_posedge_posedge     :	VitalDelayType   := 0.0 ns;

      tpw_WCLK_posedge                   :	VitalDelayType   := 2.0 ns;
      tpw_RCLK_posedge                   :	VitalDelayType   := 2.0 ns;
      tpw_RST_posedge                    :	VitalDelayType   := 2.0 ns;

      tipd_WE                            :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      tipd_RE                            :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RCLK                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      tipd_RST                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      tipd_DI0                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DI1                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DI2                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DI3                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DI4                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DI5                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DI6                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DI7                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DI8                           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DI9                           :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      WE                              :	in    STD_ULOGIC;
      WCLK                            :	in    STD_ULOGIC;
      RE                              :	in    STD_ULOGIC;
      RCLK                            :	in    STD_ULOGIC;
      RST                             :	in    STD_ULOGIC;
      DI0                             :	in    STD_ULOGIC;
      DI1                             :	in    STD_ULOGIC;
      DI2                             :	in    STD_ULOGIC;
      DI3                             :	in    STD_ULOGIC;
      DI4                             :	in    STD_ULOGIC;
      DI5                             :	in    STD_ULOGIC;
      DI6                             :	in    STD_ULOGIC;
      DI7                             :	in    STD_ULOGIC;
      DI8                             :	in    STD_ULOGIC;
      DI9                             :	in    STD_ULOGIC;
      DO0                             :	out   STD_ULOGIC;
      DO1                             :	out   STD_ULOGIC;
      DO2                             :	out   STD_ULOGIC;
      DO3                             :	out   STD_ULOGIC;
      DO4                             :	out   STD_ULOGIC;
      DO5                             :	out   STD_ULOGIC;
      DO6                             :	out   STD_ULOGIC;
      DO7                             :	out   STD_ULOGIC;
      DO8                             :	out   STD_ULOGIC;
      DO9                             :	out   STD_ULOGIC;
      FULL                            :	out   STD_ULOGIC;
      EMPTY                           :	out   STD_ULOGIC;
      START_RD                        :	out   STD_ULOGIC);

attribute VITAL_LEVEL0 of FIFO15X10A : entity is FALSE;
end FIFO15X10A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of FIFO15X10A is
  attribute VITAL_LEVEL0 of VITAL : architecture is FALSE;

  component SC_FIFO_16K
  generic (
        DEVICE_FAMILY  : string  := "SuperCool";
  	TERMINAL_COUNT : integer  := 511; 
        WADDR_WIDTH    : integer :=  9;
        WDATA_WIDTH    : integer := 32;
        RADDR_WIDTH    : integer :=  9;
        RDATA_WIDTH    : integer := 32;
        ALMOST_FULL_X  : integer :=  1;
        ALMOST_EMPTY_Y  : integer := 1;
        MEM_INIT_FLAG  : integer := 0;  
        MEM_INIT_FILE  : string  := "mem_init_file"
         );
  port (
        WE      : in STD_LOGIC ;
        WCLK    : in STD_LOGIC ;
        RST     : in STD_LOGIC ;
        RPRST   : in STD_LOGIC ;
        RE      : in STD_LOGIC ;
        RCLK    : in STD_LOGIC ;
        FULLIN  : in STD_LOGIC ;
        EMPTYIN : in STD_LOGIC ;
        DI      : in STD_LOGIC_VECTOR (WDATA_WIDTH -1 downto 0);
        FULL    : out STD_LOGIC ;
        EMPTY   : out STD_LOGIC ;
        AMFULL  : out STD_LOGIC ;
        AMEMPTY : out STD_LOGIC ;
        DO      : out STD_LOGIC_VECTOR (RDATA_WIDTH -1 downto 0)
        ); 
end component ;

      signal WE_ipd        : std_ulogic := 'X';
      signal WCLK_ipd      : std_ulogic := 'X';

      signal RE_ipd        : std_ulogic := 'X';
      signal RCLK_ipd      : std_ulogic := 'X';

      signal RST_ipd       : std_ulogic := 'X';
      signal WCLK_sig       : std_ulogic := 'X';

      signal DI0_ipd       : std_ulogic := 'X';
      signal DI1_ipd       : std_ulogic := 'X';
      signal DI2_ipd       : std_ulogic := 'X';
      signal DI3_ipd       : std_ulogic := 'X';
      signal DI4_ipd       : std_ulogic := 'X';
      signal DI5_ipd       : std_ulogic := 'X';
      signal DI6_ipd       : std_ulogic := 'X';
      signal DI7_ipd       : std_ulogic := 'X';
      signal DI8_ipd       : std_ulogic := 'X';
      signal DI9_ipd       : std_ulogic := 'X';

      signal DI : std_logic_vector(9 downto 0);
      signal DO : std_logic_vector(9 downto 0);
      signal FULL_sig  : std_logic;
      signal AMFULL_sig  : std_logic;
      signal EMPTY_sig : std_logic;
      signal RST_sig : std_logic;
      signal FULLIN, EMPTYIN, RPRST : std_logic;
      signal START_RD_sig : std_logic;

begin 
      RPRST <= '0';
      FULLIN <= '0';
      EMPTYIN <= '0';
      START_RD_sig <= NOT AMFULL_sig;
   --   RST_sig <= NOT RST_ipd;
      RST_sig <= RST_ipd;
      WCLK_sig <= WCLK_ipd;
      DI <= DI9_ipd & DI8_ipd & DI7_ipd & DI6_ipd & DI5_ipd & 
            DI4_ipd & DI3_ipd & DI2_ipd & DI1_ipd & DI0_ipd ; 

  ----------------------
  --  Wire Delay Section
  ----------------------
      WireDelay : block
      begin

        VitalWireDelay (WE_ipd, WE, tipd_WE);
        VitalWireDelay (WCLK_ipd, WCLK, tipd_WCLK);

        VitalWireDelay (RE_ipd, RE, tipd_RE);
        VitalWireDelay (RCLK_Ipd, RCLK, tipd_RCLK);

        VitalWireDelay (RST_ipd, RST, tipd_RST);

        VitalWireDelay (DI0_ipd, DI0, tipd_DI0);
        VitalWireDelay (DI1_ipd, DI1, tipd_DI1);
        VitalWireDelay (DI2_ipd, DI2, tipd_DI2);
        VitalWireDelay (DI3_ipd, DI3, tipd_DI3);
        VitalWireDelay (DI4_ipd, DI4, tipd_DI4);
        VitalWireDelay (DI5_ipd, DI5, tipd_DI5);
        VitalWireDelay (DI6_ipd, DI6, tipd_DI6);
        VitalWireDelay (DI7_ipd, DI7, tipd_DI7);
        VitalWireDelay (DI8_ipd, DI8, tipd_DI8);
        VitalWireDelay (DI9_ipd, DI9, tipd_DI9);

      end block;

      --------------------
      -- FIFO Write Behavior
      --------------------
      VITALBehavior : process
        -- Local variables used for timing checks

        variable Tviol_WE_WCLK_posedge      : std_ulogic  := '0';
        variable Tviol_RE_RCLK_posedge      : std_ulogic  := '0';

        variable Tviol_DI0_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_DI1_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_DI2_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_DI3_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_DI4_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_DI5_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_DI6_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_DI7_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_DI8_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_DI9_WCLK_posedge     : std_ulogic  := '0';

        variable Tviol_RST_RCLK_posedge_posedge   : std_ulogic  := '0';

        variable Tmkr_WE_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_RE_RCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_DI0_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DI1_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DI2_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DI3_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DI4_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DI5_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DI6_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DI7_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DI8_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DI9_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_RST_RCLK_posedge_posedge   : VitalTimingDataType := VitalTimingDataInit;

        variable PViol_WCLK       : std_ulogic := '0';
        variable PInfo_WCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        variable PViol_RCLK       : std_ulogic := '0';
        variable PInfo_RCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        variable PViol_RST        : std_ulogic := '0';
        variable PInfo_RST        : VitalPeriodDataType := VitalPeriodDataInit;

        -- Local variables used for functionality
        variable Violation       : std_ulogic := '0';
        variable DO0_zd          : std_ulogic := 'X';
        variable DO1_zd          : std_ulogic := 'X';
        variable DO2_zd          : std_ulogic := 'X';
        variable DO3_zd          : std_ulogic := 'X';
        variable DO4_zd          : std_ulogic := 'X';
        variable DO5_zd          : std_ulogic := 'X';
        variable DO6_zd          : std_ulogic := 'X';
        variable DO7_zd          : std_ulogic := 'X';
        variable DO8_zd          : std_ulogic := 'X';
        variable DO9_zd          : std_ulogic := 'X';
        variable FULL_zd         : std_ulogic := 'X';
        variable EMPTY_zd        : std_ulogic := 'X';
        variable START_RD_zd       : std_ulogic := 'X';
        variable O_GlitchData    : VitalGlitchDataType;

    begin

    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_posedge,
          SetupLow                => tsetup_WE_WCLK_noedge_posedge,
          HoldLow                 => thold_WE_WCLK_noedge_posedge,
          HoldHigh                => thold_WE_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_RE_RCLK_posedge,
          TimingData              => Tmkr_RE_RCLK_posedge,
          TestSignal              => RE_ipd,
          TestSignalName          => "RE",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName           => "RCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_RE_RCLK_noedge_posedge,
          SetupLow                => tsetup_RE_RCLK_noedge_posedge,
          HoldLow                 => thold_RE_RCLK_noedge_posedge,
          HoldHigh                => thold_Re_RCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DI0_WCLK_posedge,
          TimingData              => Tmkr_DI0_WCLK_posedge,
          TestSignal              => DI0_ipd,
          TestSignalName          => "DI0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DI0_WCLK_noedge_posedge,
          SetupLow                => tsetup_DI0_WCLK_noedge_posedge,
          HoldLow                 => thold_DI0_WCLK_noedge_posedge,
          HoldHigh                => thold_DI0_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DI1_WCLK_posedge,
          TimingData              => Tmkr_DI1_WCLK_posedge,
          TestSignal              => DI1_ipd,
          TestSignalName          => "DI1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DI1_WCLK_noedge_posedge,
          SetupLow                => tsetup_DI1_WCLK_noedge_posedge,
          HoldLow                 => thold_DI1_WCLK_noedge_posedge,
          HoldHigh                => thold_DI1_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DI2_WCLK_posedge,
          TimingData              => Tmkr_DI2_WCLK_posedge,
          TestSignal              => DI2_ipd,
          TestSignalName          => "DI2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DI2_WCLK_noedge_posedge,
          SetupLow                => tsetup_DI2_WCLK_noedge_posedge,
          HoldLow                 => thold_DI2_WCLK_noedge_posedge,
          HoldHigh                => thold_DI2_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DI3_WCLK_posedge,
          TimingData              => Tmkr_DI3_WCLK_posedge,
          TestSignal              => DI3_ipd,
          TestSignalName          => "DI3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DI3_WCLK_noedge_posedge,
          SetupLow                => tsetup_DI3_WCLK_noedge_posedge,
          HoldLow                 => thold_DI3_WCLK_noedge_posedge,
          HoldHigh                => thold_DI3_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DI4_WCLK_posedge,
          TimingData              => Tmkr_DI4_WCLK_posedge,
          TestSignal              => DI4_ipd,
          TestSignalName          => "DI4",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DI4_WCLK_noedge_posedge,
          SetupLow                => tsetup_DI4_WCLK_noedge_posedge,
          HoldLow                 => thold_DI4_WCLK_noedge_posedge,
          HoldHigh                => thold_DI4_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DI5_WCLK_posedge,
          TimingData              => Tmkr_DI5_WCLK_posedge,
          TestSignal              => DI5_ipd,
          TestSignalName          => "DI5",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DI5_WCLK_noedge_posedge,
          SetupLow                => tsetup_DI5_WCLK_noedge_posedge,
          HoldLow                 => thold_DI5_WCLK_noedge_posedge,
          HoldHigh                => thold_DI5_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DI6_WCLK_posedge,
          TimingData              => Tmkr_DI6_WCLK_posedge,
          TestSignal              => DI6_ipd,
          TestSignalName          => "DI6",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DI6_WCLK_noedge_posedge,
          SetupLow                => tsetup_DI6_WCLK_noedge_posedge,
          HoldLow                 => thold_DI6_WCLK_noedge_posedge,
          HoldHigh                => thold_DI6_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DI7_WCLK_posedge,
          TimingData              => Tmkr_DI7_WCLK_posedge,
          TestSignal              => DI7_ipd,
          TestSignalName          => "DI7",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DI7_WCLK_noedge_posedge,
          SetupLow                => tsetup_DI7_WCLK_noedge_posedge,
          HoldLow                 => thold_DI7_WCLK_noedge_posedge,
          HoldHigh                => thold_DI7_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DI8_WCLK_posedge,
          TimingData              => Tmkr_DI8_WCLK_posedge,
          TestSignal              => DI8_ipd,
          TestSignalName          => "DI8",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DI8_WCLK_noedge_posedge,
          SetupLow                => tsetup_DI8_WCLK_noedge_posedge,
          HoldLow                 => thold_DI8_WCLK_noedge_posedge,
          HoldHigh                => thold_DI8_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DI9_WCLK_posedge,
          TimingData              => Tmkr_DI9_WCLK_posedge,
          TestSignal              => DI9_ipd,
          TestSignalName          => "DI9",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DI9_WCLK_noedge_posedge,
          SetupLow                => tsetup_DI9_WCLK_noedge_posedge,
          HoldLow                 => thold_DI9_WCLK_noedge_posedge,
          HoldHigh                => thold_DI9_WCLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_posedge,
          PulseWidthLow           => tpw_WCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_RCLK,
          PeriodData              => PInfo_RCLK,
          TestSignal              => RCLK_ipd,
          TestSignalName          => "RCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_RCLK_posedge,
          PulseWidthLow           => tpw_RCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_RST,
          PeriodData              => PInfo_RST,
          TestSignal              => RST_ipd,
          TestSignalName          => "RST",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_RST_posedge,
          PulseWidthLow           => tpw_RST_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalRecoveryRemovalCheck (
          Violation               => Tviol_RST_RCLK_posedge_posedge,
          TimingData              => Tmkr_RST_RCLK_posedge_posedge,
          TestSignal              => RST_ipd,
          TestSignalName          => "RST",
          TestDelay               => 0 ns,
          RefSignal               => RCLK_ipd,
          RefSignalName          => "RCLK",
          RefDelay                => 0 ns,
          Recovery                => trecovery_RST_RCLK_posedge_posedge,
          Removal                 => thold_RST_RCLK_posedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/FIFO15X10A",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

    end if;

    Violation := Tviol_WE_WCLK_posedge or Tviol_RE_RCLK_posedge or 
                 Tviol_DI0_WCLK_posedge or Tviol_DI1_WCLK_posedge or 
                 Tviol_DI2_WCLK_posedge or Tviol_DI3_WCLK_posedge or 
                 Tviol_DI4_WCLK_posedge or Tviol_DI5_WCLK_posedge or 
                 Tviol_DI6_WCLK_posedge or Tviol_DI7_WCLK_posedge or 
                 Tviol_DI8_WCLK_posedge or Tviol_DI9_WCLK_posedge or 
                 Pviol_WCLK or Pviol_RCLK or 
                 Pviol_RST or Tviol_RST_RCLK_posedge_posedge;

    -------------------------
    --  Functionality Section
    -------------------------

      wait on WE_ipd, WCLK_ipd, RE_ipd, RCLK_ipd, RST_ipd, DI;

      end process VITALBehavior;

    VitalBehavior_DO0  : process
      variable DO0_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      DO0_zd := DO(0);

    VitalPathDelay01 (
      OutSignal => DO0,
      GlitchData => O_GlitchData,
      OutSignalName => "DO0",
      OutTemp => DO0_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_DO0, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_DO0, TRUE),
                2 => (DI0_ipd'last_event, tpd_DI0_DO0, TRUE),
                3 => (DI1_ipd'last_event, tpd_DI1_DO0, TRUE),
                4 => (DI2_ipd'last_event, tpd_DI2_DO0, TRUE),
                5 => (DI3_ipd'last_event, tpd_DI3_DO0, TRUE),
                6 => (DI4_ipd'last_event, tpd_DI4_DO0, TRUE),
                7 => (DI5_ipd'last_event, tpd_DI5_DO0, TRUE),
                8 => (DI6_ipd'last_event, tpd_DI6_DO0, TRUE),
                9 => (DI7_ipd'last_event, tpd_DI7_DO0, TRUE),
               10 => (DI8_ipd'last_event, tpd_DI8_DO0, TRUE),
               11 => (DI9_ipd'last_event, tpd_DI9_DO0, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on DO(0);
      end process;

    VitalBehavior_DO1  : process
      variable DO1_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      DO1_zd := DO(1);

    VitalPathDelay01 (
      OutSignal => DO1,
      GlitchData => O_GlitchData,
      OutSignalName => "DO1",
      OutTemp => DO1_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_DO1, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_DO1, TRUE),
                2 => (DI0_ipd'last_event, tpd_DI0_DO1, TRUE),
                3 => (DI1_ipd'last_event, tpd_DI1_DO1, TRUE),
                4 => (DI2_ipd'last_event, tpd_DI2_DO1, TRUE),
                5 => (DI3_ipd'last_event, tpd_DI3_DO1, TRUE),
                6 => (DI4_ipd'last_event, tpd_DI4_DO1, TRUE),
                7 => (DI5_ipd'last_event, tpd_DI5_DO1, TRUE),
                8 => (DI6_ipd'last_event, tpd_DI6_DO1, TRUE),
                9 => (DI7_ipd'last_event, tpd_DI7_DO1, TRUE),
               10 => (DI8_ipd'last_event, tpd_DI8_DO1, TRUE),
               11 => (DI9_ipd'last_event, tpd_DI9_DO1, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on DO(1);
      end process;

    VitalBehavior_DO2  : process
      variable DO2_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      DO2_zd := DO(2);

    VitalPathDelay01 (
      OutSignal => DO2,
      GlitchData => O_GlitchData,
      OutSignalName => "DO2",
      OutTemp => DO2_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_DO2, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_DO2, TRUE),
                2 => (DI0_ipd'last_event, tpd_DI0_DO2, TRUE),
                3 => (DI1_ipd'last_event, tpd_DI1_DO2, TRUE),
                4 => (DI2_ipd'last_event, tpd_DI2_DO2, TRUE),
                5 => (DI3_ipd'last_event, tpd_DI3_DO2, TRUE),
                6 => (DI4_ipd'last_event, tpd_DI4_DO2, TRUE),
                7 => (DI5_ipd'last_event, tpd_DI5_DO2, TRUE),
                8 => (DI6_ipd'last_event, tpd_DI6_DO2, TRUE),
                9 => (DI7_ipd'last_event, tpd_DI7_DO2, TRUE),
               10 => (DI8_ipd'last_event, tpd_DI8_DO2, TRUE),
               11 => (DI9_ipd'last_event, tpd_DI9_DO2, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on DO(2);
      end process;

    VitalBehavior_DO3  : process
      variable DO3_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      DO3_zd := DO(3);

    VitalPathDelay01 (
      OutSignal => DO3,
      GlitchData => O_GlitchData,
      OutSignalName => "DO3",
      OutTemp => DO3_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_DO3, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_DO3, TRUE),
                2 => (DI0_ipd'last_event, tpd_DI0_DO3, TRUE),
                3 => (DI1_ipd'last_event, tpd_DI1_DO3, TRUE),
                4 => (DI2_ipd'last_event, tpd_DI2_DO3, TRUE),
                5 => (DI3_ipd'last_event, tpd_DI3_DO3, TRUE),
                6 => (DI4_ipd'last_event, tpd_DI4_DO3, TRUE),
                7 => (DI5_ipd'last_event, tpd_DI5_DO3, TRUE),
                8 => (DI6_ipd'last_event, tpd_DI6_DO3, TRUE),
                9 => (DI7_ipd'last_event, tpd_DI7_DO3, TRUE),
               10 => (DI8_ipd'last_event, tpd_DI8_DO3, TRUE),
               11 => (DI9_ipd'last_event, tpd_DI9_DO3, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on DO(3);
      end process;

    VitalBehavior_DO4  : process
      variable DO4_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      DO4_zd := DO(4);

    VitalPathDelay01 (
      OutSignal => DO4,
      GlitchData => O_GlitchData,
      OutSignalName => "DO4",
      OutTemp => DO4_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_DO4, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_DO4, TRUE),
                2 => (DI0_ipd'last_event, tpd_DI0_DO4, TRUE),
                3 => (DI1_ipd'last_event, tpd_DI1_DO4, TRUE),
                4 => (DI2_ipd'last_event, tpd_DI2_DO4, TRUE),
                5 => (DI3_ipd'last_event, tpd_DI3_DO4, TRUE),
                6 => (DI4_ipd'last_event, tpd_DI4_DO4, TRUE),
                7 => (DI5_ipd'last_event, tpd_DI5_DO4, TRUE),
                8 => (DI6_ipd'last_event, tpd_DI6_DO4, TRUE),
                9 => (DI7_ipd'last_event, tpd_DI7_DO4, TRUE),
               10 => (DI8_ipd'last_event, tpd_DI8_DO4, TRUE),
               11 => (DI9_ipd'last_event, tpd_DI9_DO4, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on DO(4);
      end process;

    VitalBehavior_DO5  : process
      variable DO5_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      DO5_zd := DO(5);

    VitalPathDelay01 (
      OutSignal => DO5,
      GlitchData => O_GlitchData,
      OutSignalName => "DO5",
      OutTemp => DO5_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_DO5, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_DO5, TRUE),
                2 => (DI0_ipd'last_event, tpd_DI0_DO5, TRUE),
                3 => (DI1_ipd'last_event, tpd_DI1_DO5, TRUE),
                4 => (DI2_ipd'last_event, tpd_DI2_DO5, TRUE),
                5 => (DI3_ipd'last_event, tpd_DI3_DO5, TRUE),
                6 => (DI4_ipd'last_event, tpd_DI4_DO5, TRUE),
                7 => (DI5_ipd'last_event, tpd_DI5_DO5, TRUE),
                8 => (DI6_ipd'last_event, tpd_DI6_DO5, TRUE),
                9 => (DI7_ipd'last_event, tpd_DI7_DO5, TRUE),
               10 => (DI8_ipd'last_event, tpd_DI8_DO5, TRUE),
               11 => (DI9_ipd'last_event, tpd_DI9_DO5, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on DO(5);
      end process;

    VitalBehavior_DO6  : process
      variable DO6_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      DO6_zd := DO(6);

    VitalPathDelay01 (
      OutSignal => DO6,
      GlitchData => O_GlitchData,
      OutSignalName => "DO6",
      OutTemp => DO6_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_DO6, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_DO6, TRUE),
                2 => (DI0_ipd'last_event, tpd_DI0_DO6, TRUE),
                3 => (DI1_ipd'last_event, tpd_DI1_DO6, TRUE),
                4 => (DI2_ipd'last_event, tpd_DI2_DO6, TRUE),
                5 => (DI3_ipd'last_event, tpd_DI3_DO6, TRUE),
                6 => (DI4_ipd'last_event, tpd_DI4_DO6, TRUE),
                7 => (DI5_ipd'last_event, tpd_DI5_DO6, TRUE),
                8 => (DI6_ipd'last_event, tpd_DI6_DO6, TRUE),
                9 => (DI7_ipd'last_event, tpd_DI7_DO6, TRUE),
               10 => (DI8_ipd'last_event, tpd_DI8_DO6, TRUE),
               11 => (DI9_ipd'last_event, tpd_DI9_DO6, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on DO(6);
      end process;

    VitalBehavior_DO7  : process
      variable DO7_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      DO7_zd := DO(7);

    VitalPathDelay01 (
      OutSignal => DO7,
      GlitchData => O_GlitchData,
      OutSignalName => "DO7",
      OutTemp => DO7_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_DO7, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_DO7, TRUE),
                2 => (DI0_ipd'last_event, tpd_DI0_DO7, TRUE),
                3 => (DI1_ipd'last_event, tpd_DI1_DO7, TRUE),
                4 => (DI2_ipd'last_event, tpd_DI2_DO7, TRUE),
                5 => (DI3_ipd'last_event, tpd_DI3_DO7, TRUE),
                6 => (DI4_ipd'last_event, tpd_DI4_DO7, TRUE),
                7 => (DI5_ipd'last_event, tpd_DI5_DO7, TRUE),
                8 => (DI6_ipd'last_event, tpd_DI6_DO7, TRUE),
                9 => (DI7_ipd'last_event, tpd_DI7_DO7, TRUE),
               10 => (DI8_ipd'last_event, tpd_DI8_DO7, TRUE),
               11 => (DI9_ipd'last_event, tpd_DI9_DO7, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on DO(7);
      end process;

    VitalBehavior_DO8  : process
      variable DO8_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      DO8_zd := DO(8);

    VitalPathDelay01 (
      OutSignal => DO8,
      GlitchData => O_GlitchData,
      OutSignalName => "DO8",
      OutTemp => DO8_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_DO8, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_DO8, TRUE),
                2 => (DI0_ipd'last_event, tpd_DI0_DO8, TRUE),
                3 => (DI1_ipd'last_event, tpd_DI1_DO8, TRUE),
                4 => (DI2_ipd'last_event, tpd_DI2_DO8, TRUE),
                5 => (DI3_ipd'last_event, tpd_DI3_DO8, TRUE),
                6 => (DI4_ipd'last_event, tpd_DI4_DO8, TRUE),
                7 => (DI5_ipd'last_event, tpd_DI5_DO8, TRUE),
                8 => (DI6_ipd'last_event, tpd_DI6_DO8, TRUE),
                9 => (DI7_ipd'last_event, tpd_DI7_DO8, TRUE),
               10 => (DI8_ipd'last_event, tpd_DI8_DO8, TRUE),
               11 => (DI9_ipd'last_event, tpd_DI9_DO8, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on DO(8);
      end process;

    VitalBehavior_DO9  : process
      variable DO9_zd		: std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      DO9_zd := DO(9);

    VitalPathDelay01 (
      OutSignal => DO9,
      GlitchData => O_GlitchData,
      OutSignalName => "DO9",
      OutTemp => DO9_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_DO9, TRUE),
                1 => (RST_ipd'last_event, tpd_RST_DO9, TRUE),
                2 => (DI0_ipd'last_event, tpd_DI0_DO9, TRUE),
                3 => (DI1_ipd'last_event, tpd_DI1_DO9, TRUE),
                4 => (DI2_ipd'last_event, tpd_DI2_DO9, TRUE),
                5 => (DI3_ipd'last_event, tpd_DI3_DO9, TRUE),
                6 => (DI4_ipd'last_event, tpd_DI4_DO9, TRUE),
                7 => (DI5_ipd'last_event, tpd_DI5_DO9, TRUE),
                8 => (DI6_ipd'last_event, tpd_DI6_DO9, TRUE),
                9 => (DI7_ipd'last_event, tpd_DI7_DO9, TRUE),
               10 => (DI8_ipd'last_event, tpd_DI8_DO9, TRUE),
               11 => (DI9_ipd'last_event, tpd_DI9_DO9, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on DO(9);
      end process;


    VitalBehavior_FULL : process
      variable FULL_zd	  : std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      FULL_zd := FULL_sig;

    VitalPathDelay01 (
      OutSignal => FULL,
      GlitchData => O_GlitchData,
      OutSignalName => "FULL",
      OutTemp => FULL_zd,
      Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_FULL, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on FULL_sig;
      end process;

    VitalBehavior_START_RD : process
      variable START_RD_zd	  : std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      START_RD_zd := START_RD_sig;

    VitalPathDelay01 (
      OutSignal => START_RD,
      GlitchData => O_GlitchData,
      OutSignalName => "START_RD",
      OutTemp => START_RD_zd,
      Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_START_RD, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on START_RD_sig;
      end process;

    VitalBehavior_EMPTY : process
      variable EMPTY_zd	  : std_ulogic := 'X';
      variable O_GlitchData     : VitalGlitchDataType;

    begin

      EMPTY_zd := EMPTY_sig;

    VitalPathDelay01 (
      OutSignal => EMPTY,
      GlitchData => O_GlitchData,
      OutSignalName => "EMPTY",
      OutTemp => EMPTY_zd,
      Paths => (0 => (RCLK_ipd'last_event, tpd_RCLK_EMPTY, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

      wait on EMPTY_sig;
      end process;


  FIFO_INST: SC_FIFO_16K 
  generic map (
        WADDR_WIDTH    => 4,
        WDATA_WIDTH    => 10,
        RADDR_WIDTH    => 4,
        RDATA_WIDTH    => 10,
        MEM_INIT_FLAG  => 0, 
  	TERMINAL_COUNT => FIFO_FULL_FLAG,
        ALMOST_FULL_X  => FIFO_AMFULL_FLAG,
        ALMOST_EMPTY_Y => open, 
        MEM_INIT_FILE  => open
         )
  port map (
        WE     => WE_ipd, 
        WCLK   => WCLK_sig,
        RST    => RST_sig,

        RPRST  => RPRST,
        RE     => RE_ipd, 
        RCLK   => RCLK_ipd, 

        FULLIN =>  FULLIN,
        EMPTYIN => EMPTYIN,
        DI     => DI,
        FULL   => FULL_sig,
        EMPTY  => EMPTY_sig, 
        AMFULL => AMFULL_sig,

        AMEMPTY => open, 
        DO  => DO      ); 
end VITAL;

configuration CFG_FIFO15X10A_VITAL of FIFO15X10A is
   for VITAL
   end for;
end CFG_FIFO15X10A_VITAL;

